/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.BookmarkContainerInfo;
import codechicken.nei.FavoriteRecipes;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemsGrid;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.SearchField;
import codechicken.nei.bookmark.BookmarkGrid;
import codechicken.nei.bookmark.BookmarkGroup;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.bookmark.BookmarksGridSlot;
import codechicken.nei.recipe.AutoCraftingManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiFavoriteButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.chain.RecipeChainMath;
import codechicken.nei.util.NEIMouseUtils;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;

public abstract class ShortcutInputHandler {
    private static HotkeysCache hotkeysCache = new HotkeysCache();

    public static boolean handleKeyEvent(ItemStack stackover) {
        if (!NEIClientConfig.isLoaded()) {
            return false;
        }
        if (NEIClientConfig.isKeyHashDown("gui.overlay") && stackover == null && LayoutManager.overlayRenderer != null) {
            LayoutManager.overlayRenderer = null;
            return true;
        }
        if (stackover == null) {
            int groupId = ItemPanels.bookmarkPanel.getHoveredGroupId(true);
            if (groupId != -1) {
                RecipeChainMath math;
                if (NEIClientConfig.isKeyHashDown("gui.remove_recipe")) {
                    ItemPanels.bookmarkPanel.removeGroup(groupId);
                    return true;
                }
                if (NEIClientConfig.isKeyHashDown("gui.bookmark_pull_items")) {
                    return ItemPanels.bookmarkPanel.pullBookmarkItems(groupId, NEIClientUtils.shiftKey());
                }
                if (NEIClientConfig.autocraftingEnabled() && NEIClientConfig.isKeyHashDown("gui.craft_items") && NEIClientUtils.shiftKey() && ((BookmarkGrid)ItemPanels.bookmarkPanel.getGrid()).isCraftingMode(groupId) && (math = ((BookmarkGrid)ItemPanels.bookmarkPanel.getGrid()).createRecipeChainMath(groupId)) != null) {
                    if (!NEIClientUtils.controlKey()) {
                        ShortcutInputHandler.autocraftingIgnoreInventory(math);
                    }
                    AutoCraftingManager.runProcessing(math);
                    return true;
                }
            }
            return false;
        }
        stackover = stackover.copy();
        if (NEIClientConfig.isKeyHashDown("gui.overlay")) {
            return ShortcutInputHandler.openOverlayRecipe(stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.copy_name")) {
            return ShortcutInputHandler.copyItemStackName(stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.copy_id")) {
            return ShortcutInputHandler.copyItemStackID(stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.copy_oredict")) {
            return ShortcutInputHandler.copyItemStackOreDictionary(stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.chat_link_item")) {
            return ShortcutInputHandler.sendItemStackChatLink(stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.recipe")) {
            return GuiCraftingRecipe.openRecipeGui("item", stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.usage")) {
            return GuiUsageRecipe.openRecipeGui("item", stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.favorite")) {
            return ShortcutInputHandler.saveFavoriteTree(stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.bookmark")) {
            return ShortcutInputHandler.saveRecipeInBookmark(stackover, NEIClientUtils.shiftKey(), NEIClientUtils.controlKey());
        }
        if (NEIClientConfig.isKeyHashDown("gui.bookmark_pull_items")) {
            return ShortcutInputHandler.pullRecipeItems(stackover, NEIClientUtils.shiftKey());
        }
        if (NEIClientConfig.autocraftingEnabled() && NEIClientConfig.isKeyHashDown("gui.craft_items") && NEIClientUtils.shiftKey()) {
            return ShortcutInputHandler.runAutoCrafting(stackover, !NEIClientUtils.controlKey());
        }
        return false;
    }

    public static boolean handleMouseClick(ItemStack stackover) {
        if (!NEIClientConfig.isLoaded()) {
            return false;
        }
        if (stackover != null) {
            int button = Mouse.getEventButton();
            if (button == 0) {
                return GuiCraftingRecipe.openRecipeGui("item", stackover.copy());
            }
            if (button == 1) {
                return GuiUsageRecipe.openRecipeGui("item", stackover.copy());
            }
        }
        return false;
    }

    private static boolean copyItemStackName(ItemStack stackover) {
        GuiScreen.setClipboardString((String)SearchField.getEscapedSearchText(stackover));
        return true;
    }

    private static boolean copyItemStackID(ItemStack stackover) {
        if (stackover == null || stackover.getItem() == null) {
            return false;
        }
        GuiScreen.setClipboardString((String)(stackover.getItem().delegate.name() + (stackover.getItemDamage() != 0 ? "/" + stackover.getItemDamage() : "")));
        return true;
    }

    private static boolean sendItemStackChatLink(ItemStack stackover) {
        if (stackover == null) {
            return false;
        }
        NEIClientUtils.sendChatItemLink(stackover);
        return true;
    }

    private static boolean copyItemStackOreDictionary(ItemStack stackover) {
        StringBuilder builder = new StringBuilder();
        for (int id : OreDictionary.getOreIDs((ItemStack)stackover)) {
            String oreDictionaryName = OreDictionary.getOreName((int)id);
            if ("Unknown".equals(oreDictionaryName)) continue;
            builder.append(oreDictionaryName).append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        GuiScreen.setClipboardString((String)builder.toString());
        return true;
    }

    private static boolean runAutoCrafting(ItemStack stackover, boolean ignoreInventory) {
        Recipe.RecipeId recipeId = GuiCraftingRecipe.getRecipeId((GuiScreen)NEIClientUtils.getGuiContainer(), stackover);
        if (recipeId != null) {
            Point mouseover = GuiDraw.getMousePosition();
            BookmarksGridSlot slot = ItemPanels.bookmarkPanel.getSlotMouseOver(mouseover.x, mouseover.y);
            RecipeChainMath math = null;
            if (slot == null) {
                Recipe recipe = Recipe.of(recipeId);
                if (recipe != null) {
                    math = RecipeChainMath.of(recipe, 1L);
                }
            } else if (slot.getRecipeId() != null && !slot.isIngredient()) {
                if (slot.getGroup().crafting == null) {
                    Recipe recipe = Recipe.of(slot.getRecipeId());
                    if (recipe != null) {
                        math = RecipeChainMath.of(recipe, slot != null ? slot.getMultiplier() : 1L);
                    }
                } else {
                    math = ((BookmarkGrid)ItemPanels.bookmarkPanel.getGrid()).createRecipeChainMath(slot.getGroupId(), slot.getRecipeId());
                }
            }
            if (math != null) {
                if (ignoreInventory) {
                    ShortcutInputHandler.autocraftingIgnoreInventory(math);
                }
                AutoCraftingManager.runProcessing(math);
                return true;
            }
        }
        return false;
    }

    private static boolean openOverlayRecipe(ItemStack stackover) {
        RecipeHandlerRef handlerRef;
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Recipe.RecipeId recipeId = GuiCraftingRecipe.getRecipeId((GuiScreen)gui, stackover);
        if (recipeId != null && (handlerRef = RecipeHandlerRef.of(recipeId)) != null) {
            if (NEIClientUtils.shiftKey() && handlerRef.canFillCraftingGrid(gui)) {
                int multiplier = 0;
                if (NEIClientUtils.controlKey()) {
                    Point mouseover = GuiDraw.getMousePosition();
                    BookmarksGridSlot slot = ItemPanels.bookmarkPanel.getSlotMouseOver(mouseover.x, mouseover.y);
                    multiplier = slot != null ? (int)Math.min(64L, slot.getMultiplier()) : 1;
                }
                handlerRef.fillCraftingGrid(gui, multiplier);
            } else if (!NEIClientUtils.shiftKey() && handlerRef.canUseOverlayRenderer(gui)) {
                handlerRef.useOverlayRenderer(gui);
            }
        }
        return false;
    }

    private static boolean saveFavoriteTree(ItemStack stackover) {
        Point mouse = GuiDraw.getMousePosition();
        if (ItemPanels.itemPanel.contains(mouse.x, mouse.y) || ItemPanels.itemPanel.historyPanel.contains(mouse.x, mouse.y)) {
            RecipeHandlerRef handlerRef = RecipeHandlerRef.of(FavoriteRecipes.getFavorite(stackover));
            if (handlerRef != null) {
                GuiFavoriteButton button = new GuiFavoriteButton(handlerRef, 0, 0);
                button.saveRecipeInBookmark();
                return true;
            }
            return true;
        }
        return false;
    }

    private static boolean saveRecipeInBookmark(ItemStack stackover, boolean saveIngredients, boolean saveStackSize) {
        Point mousePos = GuiDraw.getMousePosition();
        if (!ItemPanels.bookmarkPanel.removeSlot(mousePos.x, mousePos.y, saveIngredients)) {
            Recipe recipe = ShortcutInputHandler.getFocusedRecipe(stackover, mousePos.x, mousePos.y, saveIngredients);
            if (recipe != null && saveIngredients) {
                if (!ItemPanels.bookmarkPanel.removeRecipe(recipe.getRecipeId(), 0)) {
                    Recipe singleRecipe = Recipe.of(Arrays.asList(recipe.getResult(stackover)), recipe.getHandlerName(), recipe.getIngredients());
                    singleRecipe.setCustomRecipeId(recipe.getRecipeId());
                    ItemPanels.bookmarkPanel.addRecipe(singleRecipe, saveStackSize ? 1 : 0, 0);
                }
            } else {
                Recipe.RecipeId recipeId = recipe != null ? recipe.getRecipeId() : null;
                boolean existsRecipe = recipeId != null && ItemPanels.bookmarkPanel.existsRecipe(recipeId, 0) || NEIClientConfig.getBooleanSetting("inventory.bookmarks.bookmarkItemsWithRecipe");
                if (!ItemPanels.bookmarkPanel.removeItem(stackover, existsRecipe ? recipeId : null, 0)) {
                    boolean bl = saveStackSize = saveStackSize || saveIngredients || ItemPanels.bookmarkPanel.existsRecipe(recipeId, 0);
                    if (!saveStackSize) {
                        stackover = StackInfo.withAmount(stackover, 0L);
                    } else if (ItemPanels.itemPanel.containsWithSubpanels(mousePos.x, mousePos.y)) {
                        stackover = ItemQuantityField.prepareStackWithQuantity(stackover, 0L);
                    }
                    ItemPanels.bookmarkPanel.addItem(stackover, existsRecipe ? recipeId : null, 0);
                }
            }
        }
        return true;
    }

    private static Recipe getFocusedRecipe(ItemStack stackover, int mousex, int mousey, boolean useFavorites) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Recipe recipe = null;
        if (useFavorites) {
            Recipe.RecipeId recipeId;
            ItemsGrid.ItemsGridSlot itemSlot = ItemPanels.itemPanel.getSlotMouseOver(mousex, mousey);
            if (itemSlot == null) {
                itemSlot = ItemPanels.itemPanel.historyPanel.getSlotMouseOver(mousex, mousey);
            }
            if (itemSlot == null) {
                itemSlot = ItemPanels.itemPanel.craftablesPanel.getSlotMouseOver(mousex, mousey);
            }
            if (itemSlot != null && (recipeId = ((ItemsGrid.ItemsGridSlot)itemSlot).getRecipeId()) != null && (recipe = Recipe.of(recipeId)) != null) {
                recipe.getIngredients().stream().forEach(ingr -> {
                    List<ItemStack> permutations = ingr.getPermutations();
                    for (int index = 0; index < permutations.size(); ++index) {
                        if (!FavoriteRecipes.contains(permutations.get(index))) continue;
                        ingr.setActiveIndex(index);
                        break;
                    }
                });
            }
        }
        if (gui instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)gui;
            recipe = guiRecipe.getFocusedRecipe();
        }
        return recipe;
    }

    private static boolean pullRecipeItems(ItemStack stackover, boolean shift) {
        Point mousePos = GuiDraw.getMousePosition();
        stackover = ItemPanels.bookmarkPanel.contains(mousePos.x, mousePos.y) ? ItemPanels.bookmarkPanel.getStackMouseOverWithQuantity(mousePos.x, mousePos.y) : (ItemPanels.itemPanel.contains(mousePos.x, mousePos.y) ? ItemPanels.itemPanel.getStackMouseOverWithQuantity(mousePos.x, mousePos.y) : (ItemPanels.itemPanel.historyPanel.contains(mousePos.x, mousePos.y) ? ItemPanels.itemPanel.historyPanel.getStackMouseOverWithQuantity(mousePos.x, mousePos.y) : ItemQuantityField.prepareStackWithQuantity(stackover, 0L)));
        RecipeChainMath math = RecipeChainMath.of(Arrays.asList(BookmarkItem.of(-3, stackover)), Collections.emptySet());
        return ItemPanels.bookmarkPanel.pullBookmarkItems(math, shift);
    }

    public static Map<String, String> handleHotkeys(int mousex, int mousey, ItemStack stack) {
        RecipeHandlerRef handlerRef;
        int groupId = ItemPanels.bookmarkPanel.getHoveredGroupId(true);
        if (hotkeysCache.matches(mousex, mousey, stack, groupId)) {
            return ShortcutInputHandler.hotkeysCache.hotkeys;
        }
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        HashMap<String, String> hotkeys = new HashMap<String, String>();
        if (groupId != -1) {
            hotkeys.put(NEIClientConfig.getKeyName("gui.remove_recipe"), NEIClientUtils.translate("bookmark.group.remove_recipe", new Object[0]));
            if (BookmarkContainerInfo.getBookmarkContainerHandler(gui) != null) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items"), NEIClientUtils.translate("bookmark.group.pull_items", new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items", 0x4000000), NEIClientUtils.translate("bookmark.group.pull_items_shift", new Object[0]));
            }
            if (NEIClientConfig.autocraftingEnabled() && ((BookmarkGrid)ItemPanels.bookmarkPanel.getGrid()).isCraftingMode(groupId)) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.craft_items", 0x6000000), NEIClientUtils.translate("bookmark.group.craft_missing", new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName("gui.craft_items", 0x4000000), NEIClientUtils.translate("bookmark.group.craft_all", new Object[0]));
            }
            hotkeysCache.update(mousex, mousey, stack, groupId, hotkeys);
            return hotkeys;
        }
        if (stack == null) {
            hotkeysCache.update(mousex, mousey, stack, groupId, hotkeys);
            return hotkeys;
        }
        BookmarksGridSlot slot = ItemPanels.bookmarkPanel.getSlotMouseOver(mousex, mousey);
        Recipe.RecipeId recipeId = ShortcutInputHandler.getHotkeyRecipeId(gui, mousex, mousey, stack, slot);
        if (slot != null) {
            BookmarkGroup group = slot.getGroup();
            if (group.crafting != null && group.collapsed) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("bookmark.group.remove_recipe", new Object[0]));
            } else if (slot.getRecipeId() == null) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark"), NEIClientUtils.translate("bookmark.remove_item", new Object[0]));
            } else if (group.crafting != null && group.crafting.recipeRelations.entrySet().stream().anyMatch(entry -> ((Recipe.RecipeId)entry.getKey()).equals(slot.getRecipeId()) || ((Set)entry.getValue()).contains(slot.getRecipeId()))) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("bookmark.remove_recipe", new Object[0]));
            } else {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("bookmark.remove_recipe", new Object[0]));
                if (slot.isIngredient()) {
                    hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark"), NEIClientUtils.translate("bookmark.remove_item", new Object[0]));
                    hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("bookmark.remove_recipe", new Object[0]));
                } else {
                    BookmarkItem item = slot.getBookmarkItem();
                    if (((BookmarkGrid)ItemPanels.bookmarkPanel.getGrid()).createChainItems(groupId).values().stream().noneMatch(m -> !m.isIngredient && !m.equals(item) && item.equalsRecipe((BookmarkItem)m))) {
                        hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark"), NEIClientUtils.translate("bookmark.remove_recipe", new Object[0]));
                    } else {
                        hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark"), NEIClientUtils.translate("bookmark.remove_item", new Object[0]));
                        hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("bookmark.remove_recipe", new Object[0]));
                    }
                }
            }
            if (BookmarkContainerInfo.getBookmarkContainerHandler(gui) != null) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items"), NEIClientUtils.translate("bookmark.group.pull_items", new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items", 0x4000000), NEIClientUtils.translate("bookmark.group.pull_items_shift", new Object[0]));
            }
        } else {
            hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark"), NEIClientUtils.translate("bookmark.add_item", new Object[0]));
            if (StackInfo.getAmount(stack) > 0) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x2000000), NEIClientUtils.translate("bookmark.add_item_with_count", new Object[0]));
            }
            if (recipeId != null) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x6000000), NEIClientUtils.translate("bookmark.add_item_with_recipe_and_count", new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("bookmark.add_item_with_recipe", new Object[0]));
            }
            if ((ItemPanels.itemPanel.contains(mousex, mousey) || ItemPanels.itemPanel.historyPanel.contains(mousex, mousey)) && FavoriteRecipes.contains(stack)) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.favorite"), NEIClientUtils.translate("recipe.favorite.bookmark_recipe", new Object[0]));
            }
        }
        hotkeys.put(NEIClientConfig.getKeyName("gui.recipe"), NEIClientUtils.translate("itempanel.open_crafting", new Object[0]));
        hotkeys.put(NEIClientConfig.getKeyName("gui.usage"), NEIClientUtils.translate("itempanel.open_usage", new Object[0]));
        hotkeys.put(NEIClientConfig.getKeyName("gui.copy_name"), NEIClientUtils.translate("itempanel.copy_name", new Object[0]));
        hotkeys.put(NEIClientConfig.getKeyName("gui.copy_oredict"), NEIClientUtils.translate("itempanel.copy_oredict", new Object[0]));
        hotkeys.put(NEIClientConfig.getKeyName("gui.copy_id"), NEIClientUtils.translate("itempanel.copy_id", new Object[0]));
        hotkeys.put(NEIClientConfig.getKeyName("gui.chat_link_item"), NEIClientUtils.translate("itempanel.chat_link_item", new Object[0]));
        if (!(gui instanceof GuiRecipe) && NEIClientConfig.canCheatItem(stack)) {
            hotkeys.put(NEIClientUtils.getKeyName(0x4000000, 0), NEIClientUtils.translate("itempanel.open_crafting", new Object[0]));
            hotkeys.put(NEIClientUtils.getKeyName(0x4000000, 1), NEIClientUtils.translate("itempanel.open_usage", new Object[0]));
        } else {
            hotkeys.put(NEIMouseUtils.getKeyName(0), NEIClientUtils.translate("itempanel.open_crafting", new Object[0]));
            hotkeys.put(NEIMouseUtils.getKeyName(1), NEIClientUtils.translate("itempanel.open_usage", new Object[0]));
        }
        if (recipeId != null && (handlerRef = RecipeHandlerRef.of(recipeId)) != null) {
            if (handlerRef.canUseOverlayRenderer(gui)) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.overlay"), NEIClientUtils.translate("itempanel.overlay_recipe", new Object[0]));
            }
            if (handlerRef.canFillCraftingGrid(gui)) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.overlay", 0x4000000), NEIClientUtils.translate("itempanel.fill_crafting_grid", new Object[0]));
                if (handlerRef.allowedTransferAlghoritm(gui)) {
                    hotkeys.put(NEIClientConfig.getKeyName("gui.overlay", 0x6000000), NEIClientUtils.translate("itempanel.fill_crafting_grid_quantity", new Object[0]));
                }
            }
            if (NEIClientConfig.autocraftingEnabled()) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.craft_items", 0x6000000), NEIClientUtils.translate("itempanel.craft_missing", new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName("gui.craft_items", 0x4000000), NEIClientUtils.translate("itempanel.craft_all", new Object[0]));
            }
        }
        hotkeysCache.update(mousex, mousey, stack, groupId, hotkeys);
        return hotkeys;
    }

    private static void autocraftingIgnoreInventory(RecipeChainMath math) {
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        List<ItemStack> playerInventory = AutoCraftingManager.getInventoryItems(guiContainer).values();
        Recipe.RecipeId rootRecipeId = math.createMasterRoot();
        for (BookmarkItem item : math.recipeIngredients) {
            if (item.amount <= 0L || !rootRecipeId.equals(item.recipeId)) continue;
            long amount = 0L;
            for (ItemStack stack : playerInventory) {
                if (!NEIClientUtils.areStacksSameTypeCraftingWithNBT(stack, item.itemStack)) continue;
                amount += (long)StackInfo.getAmount(stack);
            }
            if (amount < item.amount) continue;
            item.factor = item.amount = amount + item.amount - amount % item.amount;
        }
    }

    private static Recipe.RecipeId getHotkeyRecipeId(GuiContainer gui, int mousex, int mousey, ItemStack stack, BookmarksGridSlot slot) {
        GuiRecipe guiRecipe;
        Recipe focusedRecipe;
        if (slot != null) {
            return slot.isIngredient() ? null : slot.getRecipeId();
        }
        ItemsGrid.ItemsGridSlot itemSlot = ItemPanels.itemPanel.getSlotMouseOver(mousex, mousey);
        if (itemSlot == null) {
            itemSlot = ItemPanels.itemPanel.historyPanel.getSlotMouseOver(mousex, mousey);
        }
        if (itemSlot == null) {
            itemSlot = ItemPanels.itemPanel.craftablesPanel.getSlotMouseOver(mousex, mousey);
        }
        if (itemSlot != null) {
            return ((ItemsGrid.ItemsGridSlot)itemSlot).getRecipeId();
        }
        if (gui instanceof GuiRecipe && (focusedRecipe = (guiRecipe = (GuiRecipe)gui).getFocusedRecipe()) != null) {
            return focusedRecipe.getRecipeId();
        }
        return null;
    }

    private static class HotkeysCache {
        public int mousex;
        public int mousey;
        public ItemStack stack;
        public int groupId;
        public Map<String, String> hotkeys = new HashMap<String, String>();

        private HotkeysCache() {
        }

        public boolean matches(int mousex, int mousey, ItemStack stack, int groupId) {
            return Math.abs(this.mousex - mousex) < 16 && Math.abs(this.mousey - mousey) < 16 && (this.stack == null ? stack == null && this.groupId == groupId : stack != null && NEIClientUtils.areStacksSameTypeWithNBT(stack, this.stack));
        }

        public void update(int mousex, int mousey, ItemStack stack, int groupId, Map<String, String> hotkeys) {
            this.mousex = mousex;
            this.mousey = mousey;
            this.stack = stack != null ? stack.copy() : null;
            this.groupId = groupId;
            this.hotkeys = hotkeys;
        }
    }
}

