/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.BookmarkPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.bookmark.BookmarkGrid;
import codechicken.nei.bookmark.BookmarkGroup;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.bookmark.RecipeChainDetails;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.ReadableNumberConverter;
import java.awt.Color;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class BookmarksGridSlot
extends ItemsGrid.ItemsGridSlot {
    protected static final float LINE_WIDTH = 0.75f;
    protected static final Color INGREDIENTS_COLOR = new Color(1715853941, true);
    protected static final Color RESULTS_COLOR = new Color(-1721316097, true);
    protected static final Color RESULTS_BG_COLOR = new Color(862375167, true);
    protected static final Color RESULTS_BG_FLUID_COLOR = new Color(1432800511, true);
    protected static final Color REMAINDER_COLOR = new Color(1436562336, true);
    protected static final Color REMAINDER_BG_COLOR = new Color(0x33A033A0, true);
    protected static final Color REMAINDER_BG_FLUID_COLOR = new Color(1151349664, true);
    protected final ItemStack emptyItemStack;
    protected final long realAmount;
    protected final long shiftAmount;
    protected final long calculatedAmount;
    protected final long realMultiplier;
    protected final long calculatedMultiplier;
    protected final BookmarkGroup group;
    protected final boolean isFluidDisplay;
    protected final RecipeChainDetails.CalculatedType calculatedType;
    protected final RecipeChainDetails.CalculatedType realType;
    protected final BookmarkItem bookmarkItem;
    protected HandlerInfo handlerInfo = null;
    protected final boolean isOutputRecipe;
    protected final boolean isFirstOutput;
    protected final int rowIndex;

    public BookmarksGridSlot(int slotIndex, int itemIndex, long realAmount, long shiftAmount, long calculatedAmount, BookmarkItem bookmarkItem, RecipeChainDetails.CalculatedType calculatedType, BookmarkGroup group) {
        super(slotIndex, itemIndex, calculatedType != null ? bookmarkItem.getItemStack(calculatedAmount) : bookmarkItem.getItemStack(realAmount));
        this.emptyItemStack = bookmarkItem.getItemStack(0L);
        this.realAmount = realAmount;
        this.shiftAmount = shiftAmount;
        this.calculatedAmount = calculatedAmount;
        this.group = group;
        this.calculatedType = calculatedType;
        this.bookmarkItem = bookmarkItem;
        this.isOutputRecipe = group.crafting != null && group.crafting.outputRecipes.contains(bookmarkItem.recipeId);
        this.isFluidDisplay = StackInfo.itemStackToNBT(bookmarkItem.itemStack).hasKey("gtFluidName");
        this.realMultiplier = bookmarkItem.getMultiplier(realAmount);
        this.calculatedMultiplier = bookmarkItem.getMultiplier(calculatedAmount);
        this.realType = this.group.crafting != null && this.group.crafting.calculatedItems.containsKey(this.itemIndex) ? (this.group.crafting.calculatedItems.get((Object)Integer.valueOf((int)this.itemIndex)).calculatedType == RecipeChainDetails.CalculatedType.INGREDIENT ? RecipeChainDetails.CalculatedType.INGREDIENT : RecipeChainDetails.CalculatedType.RESULT) : (this.bookmarkItem.isIngredient || this.group.crafting != null && this.bookmarkItem.recipeId == null ? RecipeChainDetails.CalculatedType.INGREDIENT : RecipeChainDetails.CalculatedType.RESULT);
        BookmarkGrid grid = (BookmarkGrid)ItemPanels.bookmarkPanel.getGrid();
        BookmarkItem prevItem = grid.getCalculatedItem(grid.gridGenerator.slotToItem.getOrDefault(grid.gridGenerator.itemToSlot.get(this.itemIndex) - 1, -1));
        this.isFirstOutput = !(this.itemIndex < 0 || this.bookmarkItem.isIngredient || this.slotIndex % grid.getColumns() != 0 && group.viewMode != BookmarkPanel.BookmarkViewMode.DEFAULT || prevItem != null && !prevItem.isIngredient && this.bookmarkItem.equalsRecipe(prevItem));
        this.rowIndex = this.slotIndex / grid.getColumns();
    }

    public long getMultiplier() {
        return this.calculatedType != null ? this.calculatedMultiplier : this.realMultiplier;
    }

    public BookmarkItem getBookmarkItem() {
        return this.bookmarkItem;
    }

    @Override
    public Recipe.RecipeId getRecipeId() {
        return this.bookmarkItem.recipeId;
    }

    public boolean isIngredient() {
        return this.bookmarkItem.isIngredient;
    }

    public BookmarkGroup getGroup() {
        return this.group;
    }

    public int getGroupId() {
        return this.bookmarkItem.groupId;
    }

    protected ShownItemType getShownItemType(BookmarkGrid.BookmarkMouseContext mouseContext) {
        if (mouseContext != null) {
            if (this.showShiftItem(mouseContext)) {
                return ShownItemType.SHIFT;
            }
            if (this.showRealItem(mouseContext)) {
                return ShownItemType.REAL;
            }
        }
        if (this.calculatedType != null) {
            return ShownItemType.CALCULATED;
        }
        return null;
    }

    protected boolean showShiftItem(BookmarkGrid.BookmarkMouseContext mouseContext) {
        if (!mouseContext.shiftKey || this.bookmarkItem.groupId != mouseContext.groupId) {
            return false;
        }
        if (this.group.crafting != null) {
            return true;
        }
        return this.bookmarkItem.equalsRecipe(mouseContext.recipeId, mouseContext.groupId);
    }

    protected boolean showRealItem(BookmarkGrid.BookmarkMouseContext mouseContext) {
        if (!mouseContext.controlKey || this.bookmarkItem.groupId != mouseContext.groupId) {
            return false;
        }
        if (this.slotIndex == mouseContext.slotIndex || this.group.collapsed) {
            return true;
        }
        if (mouseContext.recipeId == null && this.group.viewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST && mouseContext.rowIndex == this.rowIndex) {
            return true;
        }
        if (this.bookmarkItem.equalsRecipe(mouseContext.recipeId, mouseContext.groupId)) {
            return true;
        }
        return this.group.crafting != null && mouseContext.recipeId != null && mouseContext.recipeId.equals(this.group.crafting.itemToRecipe.get(this.itemIndex));
    }

    protected HandlerInfo getHandlerInfo() {
        if (this.bookmarkItem.recipeId != null && this.handlerInfo == null) {
            this.handlerInfo = GuiRecipeTab.getHandlerInfo(this.bookmarkItem.recipeId.getHandleName(), null);
        }
        return this.handlerInfo;
    }

    @Override
    public void drawItem(Rectangle4i rect) {
        super.drawItem(this.emptyItemStack, rect);
    }

    @Override
    public <M extends ItemsGrid.MouseContext> void beforeDraw(Rectangle4i rect, M mouseContext) {
        ShownItemType shownItemType = this.getShownItemType((BookmarkGrid.BookmarkMouseContext)mouseContext);
        boolean showMarker = NEIClientConfig.showRecipeMarkerMode() == 2;
        RecipeChainDetails.CalculatedType calculatedType = null;
        if (shownItemType == ShownItemType.REAL) {
            calculatedType = this.realType;
        } else if (shownItemType == ShownItemType.SHIFT) {
            if (this.calculatedType != null) {
                calculatedType = this.shiftAmount > 0L ? this.calculatedType : null;
                showMarker = false;
            } else if (this.group.crafting == null) {
                calculatedType = this.realType;
            }
        }
        if (!this.bookmarkItem.isIngredient && this.bookmarkItem.recipeId != null && calculatedType == null && showMarker && (mouseContext == null || mouseContext.slotIndex != this.slotIndex)) {
            this.drawMerkerBackground(rect);
        }
        if (calculatedType == null || !this.drawBackground(rect, calculatedType)) {
            super.beforeDraw(rect, mouseContext);
        }
    }

    protected boolean drawBackground(Rectangle4i rect, RecipeChainDetails.CalculatedType calculatedType) {
        switch (calculatedType) {
            case INGREDIENT: {
                NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, INGREDIENTS_COLOR);
                break;
            }
            case RESULT: {
                NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, RESULTS_COLOR);
                break;
            }
            case REMAINDER: {
                NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, REMAINDER_COLOR);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void drawMerkerBackground(Rectangle4i rect) {
        Color color;
        Color color2 = color = this.isFluidDisplay ? RESULTS_BG_FLUID_COLOR : RESULTS_BG_COLOR;
        if (this.shiftAmount > 0L && this.calculatedType == RecipeChainDetails.CalculatedType.REMAINDER) {
            color = this.isFluidDisplay ? REMAINDER_BG_FLUID_COLOR : REMAINDER_BG_COLOR;
        }
        NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, color);
    }

    @Override
    public <M extends ItemsGrid.MouseContext> void afterDraw(Rectangle4i rect, M mouseContext) {
        ShownItemType shownItemType = this.getShownItemType((BookmarkGrid.BookmarkMouseContext)mouseContext);
        this.drawStackSize(rect, shownItemType);
        if (this.bookmarkItem.isIngredient || this.bookmarkItem.recipeId == null) {
            return;
        }
        if (this.isFirstOutput) {
            if (shownItemType == ShownItemType.REAL) {
                this.drawMarker(rect, "x" + ReadableNumberConverter.INSTANCE.toWideReadableForm(this.realMultiplier), 0xFFFFFF, NEIClientUtils.Alignment.TopLeft);
            } else if (shownItemType == ShownItemType.SHIFT) {
                this.drawMarker(rect, "x" + ReadableNumberConverter.INSTANCE.toWideReadableForm(this.getMultiplier()), 0xFFFFFF, NEIClientUtils.Alignment.TopLeft);
            } else if (this.isOutputRecipe || this.realMultiplier > 1L) {
                this.drawMarker(rect, "x" + ReadableNumberConverter.INSTANCE.toWideReadableForm(this.realMultiplier), NEIClientConfig.getSetting("inventory.bookmarks.recipeMarkerColor").getHexValue(), NEIClientUtils.Alignment.TopLeft);
            }
            if (NEIClientConfig.getBooleanSetting("inventory.bookmarks.showRecipeHandlerIcon") && this.getHandlerInfo() != null) {
                this.drawHandlerIcon(rect);
            } else if (NEIClientConfig.showRecipeMarkerMode() == 1) {
                this.drawMarker(rect, "R", NEIClientConfig.getSetting("inventory.bookmarks.recipeMarkerColor").getHexValue(), NEIClientUtils.Alignment.TopRight);
            }
        } else if (NEIClientConfig.showRecipeMarkerMode() == 1) {
            this.drawMarker(rect, "R", NEIClientConfig.getSetting("inventory.bookmarks.recipeMarkerColor").getHexValue(), NEIClientUtils.Alignment.TopRight);
        }
    }

    protected void drawHandlerIcon(Rectangle4i rect) {
        float panelFactor = 1.0f;
        if ((float)rect.w != 18.0f) {
            panelFactor = (float)(rect.w - 2) / 16.0f;
        }
        float x = (float)(rect.x + 2 + 16) - 16.0f * (panelFactor *= 0.4f);
        GL11.glTranslatef((float)x, (float)rect.y, (float)0.0f);
        GL11.glScaled((double)panelFactor, (double)panelFactor, (double)1.5);
        if (this.handlerInfo.getImage() != null) {
            this.handlerInfo.getImage().draw(0, 0);
        } else {
            GuiContainerManager.drawItem(0, 0, this.handlerInfo.getItemStack(), true, "");
        }
        GL11.glScaled((double)(1.0f / panelFactor), (double)(1.0f / panelFactor), (double)0.6666666865348816);
        GL11.glTranslatef((float)(-1.0f * x), (float)(-1 * rect.y), (float)0.0f);
    }

    protected void drawMarker(Rectangle4i rect, String text, int color, NEIClientUtils.Alignment alignment) {
        float panelFactor = (float)(rect.w - 2) / 16.0f;
        NEIClientUtils.drawNEIOverlayText(text, new Rectangle4i(rect.x + 1, rect.y + 1, rect.w - 2, rect.h - 2), panelFactor, color, true, alignment);
    }

    protected void drawStackSize(Rectangle4i rect, ShownItemType shownItemType) {
        long amount = this.calculatedAmount;
        if (shownItemType == null || shownItemType == ShownItemType.REAL || this.calculatedType == null) {
            amount = this.realAmount;
        } else if (shownItemType == ShownItemType.SHIFT) {
            amount = this.shiftAmount;
        }
        if (amount > 0L || shownItemType == ShownItemType.REAL && this.bookmarkItem.factor > 0L) {
            float panelFactor = (float)(rect.w - 2) / 16.0f;
            long stackSize = this.bookmarkItem.getStackSize(amount);
            String amountString = "";
            amountString = stackSize < 10000L ? String.valueOf(stackSize) : ReadableNumberConverter.INSTANCE.toWideReadableForm(stackSize);
            if (this.isFluidDisplay) {
                amountString = amountString + "L";
            }
            NEIClientUtils.drawNEIOverlayText(amountString, new Rectangle4i(rect.x + 1, rect.y + 1, rect.w - 2, rect.h - 2), panelFactor, 0xFFFFFF, true, this.isFluidDisplay ? NEIClientUtils.Alignment.BottomLeft : NEIClientUtils.Alignment.BottomRight);
        }
    }

    protected static enum ShownItemType {
        REAL,
        SHIFT,
        CALCULATED;

    }
}

