/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe.chain;

import codechicken.nei.ItemStackAmount;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.chain.RecipeChainMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeChainIterator
implements Iterator<Map<Recipe.RecipeId, Long>> {
    public final ItemStackAmount inventory = new ItemStackAmount();
    private final Set<Recipe.RecipeId> precessedRecipes = new HashSet<Recipe.RecipeId>();
    private RecipeChainMath math;
    private Set<Recipe.RecipeId> topRecipes;
    private Set<Recipe.RecipeId> processedRecipes;
    private List<BookmarkItem> initialItems;

    public RecipeChainIterator(RecipeChainMath math, List<BookmarkItem> initialItems) {
        this.math = math;
        this.topRecipes = this.math.outputRecipes.keySet();
        this.initialItems = new ArrayList<BookmarkItem>(initialItems);
        this.processedRecipes = new HashSet<Recipe.RecipeId>(this.topRecipes);
    }

    public void updateInventory(ItemStack[] mainInventory) {
        this.updateInventory(ItemStackAmount.of(Arrays.asList(mainInventory)));
    }

    public void updateInventory(ItemStackAmount mainInventory) {
        this.inventory.clear();
        this.inventory.putAll(mainInventory);
    }

    @Override
    public Map<Recipe.RecipeId, Long> next() {
        this.refreshInitialItems(this.math, this.initialItems);
        this.math.refresh();
        HashSet<Recipe.RecipeId> skipRecipes = new HashSet<Recipe.RecipeId>();
        HashMap<Recipe.RecipeId, Long> rootRecipes = new HashMap<Recipe.RecipeId, Long>();
        HashMap<BookmarkItem, BookmarkItem> preferredItems = new HashMap<BookmarkItem, BookmarkItem>(this.math.preferredItems);
        preferredItems.values().removeIf(item -> item == null || item.amount == 0L || this.precessedRecipes.contains(item.recipeId));
        preferredItems.keySet().removeIf(item -> item.amount == 0L);
        for (Map.Entry<BookmarkItem, BookmarkItem> entry : preferredItems.entrySet()) {
            BookmarkItem keyItem = entry.getKey();
            if (!this.topRecipes.contains(keyItem.recipeId) || skipRecipes.contains(keyItem.recipeId)) continue;
            BookmarkItem item2 = entry.getValue();
            if (preferredItems.entrySet().stream().anyMatch(pref -> !this.processedRecipes.contains(((BookmarkItem)pref.getKey()).recipeId) && item2.equals(pref.getValue()))) {
                skipRecipes.add(item2.recipeId);
                continue;
            }
            rootRecipes.put(item2.recipeId, Math.max(rootRecipes.getOrDefault(item2.recipeId, 0L), item2.getMultiplier()));
        }
        for (Recipe.RecipeId recipeId : skipRecipes) {
            rootRecipes.remove(recipeId);
        }
        this.processedRecipes.addAll(rootRecipes.keySet());
        rootRecipes.values().removeIf(amount -> amount == 0L);
        this.topRecipes = rootRecipes.keySet();
        this.precessedRecipes.addAll(this.topRecipes);
        return rootRecipes;
    }

    @Override
    public boolean hasNext() {
        return !this.topRecipes.isEmpty();
    }

    private void refreshInitialItems(RecipeChainMath math, List<BookmarkItem> initialItems) {
        math.initialItems.clear();
        math.initialItems.addAll(initialItems);
        for (ItemStack stack : this.inventory.values()) {
            long invStackSize = this.inventory.getOrDefault(stack, 0L);
            if (invStackSize <= 0L) continue;
            math.initialItems.add(BookmarkItem.of(-1, StackInfo.withAmount(stack, invStackSize)));
        }
    }
}

