/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.Widget;
import codechicken.nei.api.ShortcutInputHandler;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.scroll.ScrollBar;
import codechicken.nei.scroll.ScrollContainer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GuiRecipeCatalyst
extends ScrollContainer {
    private static final int SLOT_SIZE = 16;
    private static final int BORDER_PADDING = 6;
    private static final DrawableResource BG_TEXTURE = new DrawableBuilder("nei:textures/catalyst_tab.png", 0, 0, 28, 28).setTextureSize(28, 28).build();
    private static final DrawableResource FG_TEXTURE = new DrawableBuilder("nei:textures/slot.png", 0, 0, 18, 18).setTextureSize(18, 18).build();
    private static final ScrollBar VERTICAL_SCROLLBAR = ScrollBar.defaultVerticalBar().setOverflowType(ScrollBar.OverflowType.AUTO).setMarginStart(6).setMarginEnd(6).setPadding(-13).setScrollPlace(ScrollBar.ScrollPlace.START);
    private final List<PositionedStack> items = new ArrayList<PositionedStack>();
    private boolean showWidget = false;
    private int availableHeight = 0;
    @Deprecated
    public static final int ingredientSize = 16;
    @Deprecated
    public static final int ingredientBorder = 1;
    @Deprecated
    public static final int tabBorder = 5;
    @Deprecated
    public static final int fullBorder = 6;

    public GuiRecipeCatalyst() {
        this.setPaddingBlock(7, 7);
    }

    public void setCatalysts(List<PositionedStack> items) {
        this.items.clear();
        this.items.addAll(items);
        this.createWidgets();
    }

    public void setAvailableHeight(int height) {
        if (this.availableHeight != height) {
            this.availableHeight = height;
            this.createWidgets();
        }
    }

    public int getAvailableHeight() {
        return this.availableHeight;
    }

    public boolean isShowWidget() {
        return this.showWidget;
    }

    public int getColumnCount() {
        if (NEIClientConfig.getJEIStyleRecipeCatalysts() == 1) {
            int maxItemsPerColumn = Math.max(0, this.availableHeight - 2 - 12) / 16;
            return maxItemsPerColumn > 0 ? NEIServerUtils.divideCeil(this.items.size(), maxItemsPerColumn) : 0;
        }
        return 1;
    }

    public int getRowCount() {
        int columnCount = this.getColumnCount();
        return columnCount > 0 ? NEIServerUtils.divideCeil(this.items.size(), columnCount) : 0;
    }

    protected void createWidgets() {
        int columns = this.getColumnCount();
        int rows = this.getRowCount();
        this.setVerticalScroll(null);
        this.setPaddingInline(7, 3);
        this.h = rows * 16 + this.paddingBlockStart + this.paddingBlockEnd;
        this.w = columns * 16 + this.paddingInlineStart + this.paddingInlineEnd;
        if (NEIClientConfig.getJEIStyleRecipeCatalysts() == 2 && rows * 16 + this.paddingBlockStart + this.paddingBlockEnd > this.availableHeight) {
            this.h = Math.min(this.h, this.availableHeight);
            this.w += VERTICAL_SCROLLBAR.getScrollbarSize();
            this.setVerticalScroll(VERTICAL_SCROLLBAR);
            this.setPaddingInline(7 + VERTICAL_SCROLLBAR.getScrollbarSize(), this.paddingInlineEnd);
        }
        boolean bl = this.showWidget = rows * columns > 0;
        if (rows == 0 || columns == 0) {
            return;
        }
        int visibleWidth = this.getVisibleWidth();
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        int index = 0;
        for (PositionedStack pStack : this.items) {
            if (pStack.items.length > 1) {
                int stackIndex = (pStack.items.length + pStack.getPermutationIndex(pStack.item) + 1) % pStack.items.length;
                pStack.setPermutationToRender(stackIndex);
            }
            pStack.relx = visibleWidth - 16 - index / rows * 16;
            pStack.rely = index % rows * 16;
            ++index;
            widgets.add(new ItemStackWidget(pStack));
        }
        this.setWidgets(widgets);
    }

    @Override
    public void draw(int mx, int my) {
        if (!this.showWidget) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BG_TEXTURE.draw(this.x, this.y, this.w, this.h, 6, 6, 6, 6);
        FG_TEXTURE.draw(this.x + this.paddingInlineStart - 1, this.y + this.paddingBlockStart - 1, this.w - this.paddingInlineStart - this.paddingInlineEnd + 2, this.h - this.paddingBlockStart - this.paddingBlockEnd + 2, 1, 1, 1, 1);
        super.draw(mx, my);
    }

    public PositionedStack getPositionedStackMouseOver(int mx, int my) {
        Widget widget = this.getWidgetUnderMouse(mx, my);
        if (widget instanceof ItemStackWidget) {
            ItemStackWidget stackWidget = (ItemStackWidget)widget;
            return stackWidget.pStack;
        }
        return null;
    }

    protected static class ItemStackWidget
    extends Widget {
        private final PositionedStack pStack;

        public ItemStackWidget(PositionedStack pStack) {
            this.pStack = pStack;
            this.x = pStack.relx;
            this.y = pStack.rely;
            this.w = 16;
            this.h = 16;
        }

        @Override
        public void draw(int mx, int my) {
            GuiContainerManager.drawItem(this.x, this.y, this.pStack.item);
            if (this.contains(mx, my)) {
                NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)this.x, (int)this.y, (int)this.w, (int)this.h, (int)-2130706433));
            }
        }

        @Override
        public boolean handleClick(int mx, int my, int button) {
            return ShortcutInputHandler.handleMouseClick(this.pStack.item);
        }
    }
}

