/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.util;

import codechicken.nei.NEIClientUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class NEIKeyboardUtils {
    public static final int ALT_HASH = 0x8000000;
    public static final int SHIFT_HASH = 0x4000000;
    public static final int CTRL_HASH = 0x2000000;
    private static final Map<Integer, Integer> keyHashMap = new HashMap<Integer, Integer>();

    private NEIKeyboardUtils() {
    }

    public static boolean isHashKey(int keycode) {
        return keyHashMap.containsKey(keycode);
    }

    public static String getHashName(int keyBind) {
        StringJoiner keyText = new StringJoiner(" + ");
        if ((keyBind & 0x2000000) != 0) {
            keyText.add(NEIClientUtils.translate(Minecraft.field_142025_a ? "key.ctrl.mac" : "key.ctrl", new Object[0]));
        }
        if ((keyBind & 0x4000000) != 0) {
            keyText.add(NEIClientUtils.translate("key.shift", new Object[0]));
        }
        if ((keyBind & 0x8000000) != 0) {
            keyText.add(NEIClientUtils.translate("key.alt", new Object[0]));
        }
        return keyText.toString();
    }

    public static String getKeyName(int keyBind) {
        keyBind = keyHashMap.getOrDefault(keyBind, keyBind);
        StringJoiner keyText = new StringJoiner(" + ");
        String hashText = NEIKeyboardUtils.getHashName(keyBind);
        int keyID = NEIKeyboardUtils.unhash(keyBind);
        if (!hashText.isEmpty()) {
            keyText.add(hashText);
        }
        if (keyID != 0 || hashText.isEmpty()) {
            keyText.add(Keyboard.getKeyName((int)keyID));
        }
        return keyText.toString();
    }

    public static int unhash(int keyBind) {
        return keyBind & 0xF1FFFFFF;
    }

    static {
        keyHashMap.put(42, 0x4000000);
        keyHashMap.put(54, 0x4000000);
        keyHashMap.put(29, 0x2000000);
        keyHashMap.put(29, 0x2000000);
        keyHashMap.put(219, 0x2000000);
        keyHashMap.put(220, 0x2000000);
        keyHashMap.put(56, 0x8000000);
        keyHashMap.put(56, 0x8000000);
    }
}

