/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.nei.BookmarkPanel;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.bookmark.BookmarkGrid;
import codechicken.nei.bookmark.BookmarkGroup;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NBTJson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

public class BookmarkStorage {
    protected List<BookmarkGrid> namespaces = new ArrayList<BookmarkGrid>();
    protected int activeNamespaceIndex = 0;
    protected File bookmarkFile = null;

    public BookmarkStorage() {
        this.namespaces.add(new BookmarkGrid());
    }

    public boolean prevNamespace() {
        this.getNamespaceSize();
        this.removeEmptyNamespaces();
        if (this.activeNamespaceIndex == 0) {
            this.setNamespace(this.getNamespaceSize() - 1);
        } else {
            this.setNamespace(this.activeNamespaceIndex - 1);
        }
        return true;
    }

    public boolean nextNamespace() {
        if (this.removeEmptyNamespaces()) {
            return true;
        }
        if (this.activeNamespaceIndex == this.getNamespaceSize() - 1) {
            this.setNamespace(0);
        } else {
            this.setNamespace(this.activeNamespaceIndex + 1);
        }
        return true;
    }

    private void setNamespace(int namespaceIndex) {
        this.activeNamespaceIndex = Math.min(namespaceIndex, this.namespaces.size() - 1);
        BookmarkGrid grid = this.namespaces.get(this.activeNamespaceIndex);
        if (grid.size() == 0 && this.activeNamespaceIndex > 0) {
            grid.setViewMode(0, this.namespaces.get(this.activeNamespaceIndex - 1).getViewMode(0));
        }
    }

    public int getNamespaceSize() {
        if (this.namespaces.get(this.namespaces.size() - 1).size() > 0) {
            this.namespaces.add(new BookmarkGrid());
        } else if (this.activeNamespaceIndex == this.namespaces.size() - 2 && this.getActiveGrid().size() == 0) {
            this.namespaces.remove(this.namespaces.size() - 1);
        }
        return this.namespaces.size();
    }

    public boolean isEmpty() {
        return this.namespaces.size() <= 1 && this.getActiveGrid().isEmpty();
    }

    public int getActiveIndex() {
        return this.activeNamespaceIndex;
    }

    public BookmarkGrid getActiveGrid() {
        return this.namespaces.get(this.activeNamespaceIndex);
    }

    private boolean removeEmptyNamespaces() {
        if (this.activeNamespaceIndex != this.namespaces.size() - 1 && this.getActiveGrid().size() == 0) {
            this.namespaces.remove(this.activeNamespaceIndex);
            this.setNamespace(this.activeNamespaceIndex);
            return true;
        }
        return false;
    }

    public void load(File bookmarkFile) {
        if (bookmarkFile.equals(this.bookmarkFile)) {
            return;
        }
        List itemStrings = Collections.emptyList();
        if (bookmarkFile.exists()) {
            try (FileInputStream reader = new FileInputStream(bookmarkFile);){
                NEIClientConfig.logger.info("Loading bookmarks from file {}", new Object[]{bookmarkFile});
                itemStrings = IOUtils.readLines((InputStream)reader, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Failed to load bookmarks from file {}", new Object[]{bookmarkFile, e});
                return;
            }
        }
        JsonParser parser = new JsonParser();
        ArrayList<BookmarkGrid> namespaces = new ArrayList<BookmarkGrid>();
        NBTTagCompound navigation = new NBTTagCompound();
        namespaces.add(new BookmarkGrid());
        BookmarkGrid grid = (BookmarkGrid)namespaces.get(0);
        if (NEIClientConfig.world.nbt.hasKey("bookmark")) {
            navigation = NEIClientConfig.world.nbt.getCompoundTag("bookmark");
        }
        for (String itemStr : itemStrings) {
            try {
                if (itemStr.isEmpty()) {
                    itemStr = "; {}";
                }
                if (itemStr.startsWith("; ")) {
                    JsonObject settings = parser.parse(itemStr.substring(2)).getAsJsonObject();
                    if (grid.size() > 0) {
                        grid = new BookmarkGrid();
                        namespaces.add(grid);
                    }
                    if (navigation.hasKey("namespacePage." + (namespaces.size() - 1))) {
                        grid.setPage(navigation.getInteger("namespacePage." + (namespaces.size() - 1)));
                    }
                    if (settings.get("viewmode") != null) {
                        grid.groups.get((Object)Integer.valueOf((int)0)).viewMode = BookmarkPanel.BookmarkViewMode.valueOf(settings.get("viewmode").getAsString());
                        continue;
                    }
                    JsonElement jsonElement = settings.get("groups");
                    if (!(jsonElement instanceof JsonObject)) continue;
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                        Object object = jsonEntry.getValue();
                        if (!(object instanceof JsonObject)) continue;
                        JsonObject value = (JsonObject)object;
                        BookmarkGroup group = new BookmarkGroup(value.has("viewmode") ? BookmarkPanel.BookmarkViewMode.valueOf(value.get("viewmode").getAsString()) : BookmarkPanel.BookmarkViewMode.DEFAULT, value.has("crafting") && value.get("crafting").getAsBoolean());
                        boolean bl = group.collapsed = value.has("collapsed") && value.get("collapsed").getAsBoolean();
                        if (value.has("collapsedRecipes")) {
                            for (JsonElement recipeId : value.get("collapsedRecipes").getAsJsonArray()) {
                                if (!(recipeId instanceof JsonObject)) continue;
                                JsonObject item = (JsonObject)recipeId;
                                group.collapsedRecipes.add(Recipe.RecipeId.of(item));
                            }
                        }
                        grid.groups.put(Integer.valueOf((String)jsonEntry.getKey()), group);
                    }
                    continue;
                }
                if (this.addItemToGrid(grid, parser.parse(itemStr).getAsJsonObject())) continue;
                NEIClientConfig.logger.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", new Object[]{itemStr});
            }
            catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException e) {
                NEIClientConfig.logger.error("Failed to load bookmarked ItemStack from json string:\n{}", new Object[]{itemStr});
            }
        }
        this.prepareOldRecipeFormat(namespaces);
        for (BookmarkGrid gr : namespaces) {
            gr.onItemsChanged();
        }
        this.namespaces = namespaces;
        if (navigation.hasKey("namespaceIndex")) {
            this.setNamespace(navigation.getInteger("namespaceIndex"));
        } else {
            this.setNamespace(0);
        }
        this.bookmarkFile = bookmarkFile;
    }

    private boolean addItemToGrid(BookmarkGrid grid, JsonObject jsonObject) {
        NBTTagCompound itemStackNBT = jsonObject.get("item") != null ? (NBTTagCompound)NBTJson.toNbt(jsonObject.get("item")) : (NBTTagCompound)NBTJson.toNbt((JsonElement)jsonObject);
        ItemStack itemStack = StackInfo.loadFromNBT(itemStackNBT);
        if (itemStack != null) {
            int groupId;
            Recipe.RecipeId recipeId = null;
            boolean isFluid = itemStackNBT.hasKey("gtFluidName");
            int n = groupId = jsonObject.has("groupId") ? jsonObject.get("groupId").getAsInt() : 0;
            int factor = jsonObject.has("factor") ? Math.abs(jsonObject.get("factor").getAsInt()) : (isFluid ? 144 : 1);
            boolean isIngredient = jsonObject.has("ingredient") && jsonObject.get("ingredient").getAsBoolean();
            JsonElement jsonElement = jsonObject.get("recipeId");
            if (jsonElement instanceof JsonObject) {
                JsonObject recipeJson = (JsonObject)jsonElement;
                recipeId = Recipe.RecipeId.of(recipeJson);
            }
            if (!grid.groups.containsKey(groupId)) {
                groupId = 0;
            }
            grid.addItem(BookmarkItem.of(groupId, itemStack, factor, recipeId, isIngredient), false);
        }
        return itemStack != null;
    }

    private void prepareOldRecipeFormat(List<BookmarkGrid> namespaces) {
        for (BookmarkGrid grid : namespaces) {
            String recipeGUID;
            JsonObject recipeJson;
            if (grid.bookmarkItems.stream().noneMatch(item -> item.recipeId != null && item.recipeId.getResult() == null)) continue;
            HashMap<String, Recipe.RecipeId> recipes = new HashMap<String, Recipe.RecipeId>();
            for (BookmarkItem item2 : grid.bookmarkItems) {
                if (item2.recipeId == null || item2.isIngredient || item2.recipeId.getResult() != null) continue;
                recipeJson = item2.recipeId.toJsonObject();
                recipeGUID = item2.groupId + ":" + NBTJson.toJson((JsonElement)recipeJson);
                if (recipes.containsKey(recipeGUID)) continue;
                recipeJson.add("result", NBTJson.toJsonObject((NBTBase)StackInfo.itemStackToNBT(item2.itemStack)));
                item2.recipeId = Recipe.RecipeId.of(recipeJson);
                recipes.put(recipeGUID, item2.recipeId);
            }
            for (BookmarkItem item2 : grid.bookmarkItems) {
                if (item2.recipeId == null || item2.recipeId.getResult() != null) continue;
                recipeJson = item2.recipeId.toJsonObject();
                recipeGUID = item2.groupId + ":" + NBTJson.toJson((JsonElement)recipeJson);
                if (recipes.containsKey(recipeGUID)) {
                    item2.recipeId = ((Recipe.RecipeId)recipes.get(recipeGUID)).copy();
                    item2.permutations = BookmarkItem.generatePermutations(item2.itemStack, item2.recipeId, item2.isIngredient);
                    continue;
                }
                item2.recipeId = null;
            }
        }
    }

    public void save() {
        if (this.bookmarkFile == null) {
            return;
        }
        ArrayList<String> strings = new ArrayList<String>();
        NBTTagCompound navigation = new NBTTagCompound();
        navigation.setInteger("namespaceIndex", this.activeNamespaceIndex);
        for (int grpIdx = 0; grpIdx < this.namespaces.size(); ++grpIdx) {
            BookmarkGrid grid = this.namespaces.get(grpIdx);
            JsonObject settings = new JsonObject();
            JsonObject groups = new JsonObject();
            Iterator<Object> iterator = grid.groups.keySet().iterator();
            while (iterator.hasNext()) {
                int groupId = iterator.next();
                BookmarkGroup group = grid.groups.get(groupId);
                JsonObject groupJson = new JsonObject();
                groupJson.add("viewmode", (JsonElement)new JsonPrimitive(group.viewMode.toString()));
                groupJson.add("crafting", (JsonElement)new JsonPrimitive(Boolean.valueOf(group.crafting != null)));
                groupJson.add("collapsed", (JsonElement)new JsonPrimitive(Boolean.valueOf(group.collapsed)));
                if (!group.collapsedRecipes.isEmpty()) {
                    JsonArray collapsedRecipes = new JsonArray();
                    for (Recipe.RecipeId recipeId : group.collapsedRecipes) {
                        collapsedRecipes.add((JsonElement)recipeId.toJsonObject());
                    }
                    groupJson.add("collapsedRecipes", (JsonElement)collapsedRecipes);
                }
                groups.add(String.valueOf(groupId), (JsonElement)groupJson);
            }
            settings.add("groups", (JsonElement)groups);
            strings.add("; " + NBTJson.toJson((JsonElement)settings));
            navigation.setInteger("namespacePage." + grpIdx, grid.getPage() - 1);
            for (BookmarkItem item : grid.bookmarkItems) {
                try {
                    JsonObject row = new JsonObject();
                    row.add("item", NBTJson.toJsonObject((NBTBase)StackInfo.itemStackToNBT(item.getItemStack())));
                    row.add("factor", (JsonElement)new JsonPrimitive((Number)item.getFactor()));
                    row.add("ingredient", (JsonElement)new JsonPrimitive(Boolean.valueOf(item.isIngredient)));
                    if (item.groupId != 0) {
                        row.add("groupId", (JsonElement)new JsonPrimitive((Number)item.groupId));
                    }
                    if (item.recipeId != null) {
                        row.add("recipeId", (JsonElement)item.recipeId.toJsonObject());
                    }
                    strings.add(NBTJson.toJson((JsonElement)row));
                }
                catch (JsonSyntaxException e) {
                    NEIClientConfig.logger.error("Failed to stringify bookmarked ItemStack to json string");
                }
            }
        }
        try (FileOutputStream output = new FileOutputStream(this.bookmarkFile);){
            IOUtils.writeLines(strings, (String)"\n", (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            NEIClientConfig.world.nbt.setTag("bookmark", (NBTBase)navigation);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to save bookmarks list to file {}", new Object[]{this.bookmarkFile, e});
        }
    }
}

