/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.nei.FastTransferManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DefaultOverlayHandler
implements IOverlayHandler {
    public int offsetx;
    public int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    @Override
    public void overlayRecipe(GuiContainer gui, IRecipeHandler handler, int recipeIndex, boolean maxTransfer) {
        this.transferRecipe(gui, handler, recipeIndex, maxTransfer ? Integer.MAX_VALUE : 1);
    }

    @Override
    public int transferRecipe(GuiContainer gui, IRecipeHandler handler, int recipeIndex, int multiplier) {
        List<PositionedStack> ingredients = handler.getIngredientStacks(recipeIndex);
        List<DistributedIngred> ingredStacks = this.getPermutationIngredients(ingredients);
        if (!this.clearIngredients(gui)) {
            return 0;
        }
        this.findInventoryQuantities(gui, ingredStacks);
        List<IngredientDistribution> assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return 0;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        multiplier = Math.min(multiplier == 0 ? 64 : multiplier, this.calculateRecipeQuantity(assignedIngredients));
        this.moveIngredients(gui, assignedIngredients, Math.max(1, multiplier));
        return assignedIngredients.stream().anyMatch(distrib -> distrib.distrib.distributed == 0) ? 0 : multiplier;
    }

    @Override
    public boolean canFillCraftingGrid(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex) {
        return true;
    }

    @Override
    public boolean canCraft(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex) {
        return this.canFillCraftingGrid(firstGui, handler, recipeIndex) && this.presenceOverlay(firstGui, handler, recipeIndex).stream().allMatch(state -> state.isPresent());
    }

    @Override
    public boolean craft(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, int multiplier) {
        int transfer;
        EntityClientPlayerMP thePlayer = NEIClientUtils.mc().thePlayer;
        boolean craft = false;
        block0: while (multiplier > 0 && (transfer = this.transferRecipe(firstGui, recipe, recipeIndex, multiplier)) > 0) {
            multiplier -= transfer;
            for (Slot slot : firstGui.inventorySlots.inventorySlots) {
                if (!slot.getHasStack() || !(slot instanceof SlotCrafting) || !slot.canTakeStack((EntityPlayer)thePlayer)) continue;
                FastTransferManager.clickSlot(firstGui, slot.slotNumber, 0, 1);
                craft = true;
                continue block0;
            }
        }
        this.clearIngredients(firstGui);
        return craft;
    }

    private boolean clearIngredients(GuiContainer gui) {
        EntityClientPlayerMP thePlayer = NEIClientUtils.mc().thePlayer;
        for (Slot slot : gui.inventorySlots.inventorySlots) {
            if (!slot.getHasStack() || this.canMoveFrom(slot, gui) || slot instanceof SlotCrafting || !slot.canTakeStack((EntityPlayer)thePlayer)) continue;
            FastTransferManager.clickSlot(gui, slot.slotNumber, 0, 1);
            if (!slot.getHasStack()) continue;
            return false;
        }
        return this.dropOffMouseStack((EntityPlayer)thePlayer, gui);
    }

    private void moveIngredients(GuiContainer gui, List<IngredientDistribution> assignedIngredients, int multiplier) {
        EntityClientPlayerMP thePlayer = NEIClientUtils.mc().thePlayer;
        for (Slot slot : gui.inventorySlots.inventorySlots) {
            if (slot instanceof SlotCrafting || !slot.getHasStack() || !this.canMoveFrom(slot, gui) || !slot.canTakeStack((EntityPlayer)thePlayer)) continue;
            ItemStack stack = slot.getStack();
            int slotTransferCap = stack.getMaxStackSize();
            for (IngredientDistribution distrib : assignedIngredients) {
                if (distrib.slots.length == 0 || !slot.getHasStack() || !this.canStack(distrib.permutation, stack)) continue;
                int transferCap = Math.min(slotTransferCap, multiplier * distrib.permutation.stackSize);
                int stackSize = slot.getStack().stackSize;
                boolean pickup = false;
                for (Slot dest : distrib.slots) {
                    int amount = Math.min(transferCap - (dest.getHasStack() ? dest.getStack().stackSize : 0), stackSize);
                    if (stackSize <= amount) {
                        if (!pickup) {
                            FastTransferManager.clickSlot(gui, slot.slotNumber);
                        }
                        FastTransferManager.clickSlot(gui, dest.slotNumber);
                        break;
                    }
                    for (int c = 0; c < amount; ++c) {
                        boolean bl = pickup;
                        pickup = true;
                        if (!bl) {
                            FastTransferManager.clickSlot(gui, slot.slotNumber);
                        }
                        FastTransferManager.clickSlot(gui, dest.slotNumber, 1);
                        --stackSize;
                    }
                }
                if (thePlayer.inventory.getItemStack() == null) continue;
                FastTransferManager.clickSlot(gui, slot.slotNumber);
            }
        }
    }

    protected boolean dropOffMouseStack(EntityPlayer entityPlayer, GuiContainer gui) {
        if (entityPlayer.inventory.getItemStack() == null) {
            return true;
        }
        for (int i = 0; i < gui.inventorySlots.inventorySlots.size(); ++i) {
            Slot slot = (Slot)gui.inventorySlots.inventorySlots.get(i);
            if (slot.inventory != entityPlayer.inventory) continue;
            ItemStack mouseItem = entityPlayer.inventory.getItemStack();
            ItemStack slotStack = slot.getStack();
            if (slotStack == null || NEIClientUtils.areStacksSameType(mouseItem, slotStack)) {
                FastTransferManager.clickSlot(gui, i, 0, 0);
            }
            if (entityPlayer.inventory.getItemStack() != null) continue;
            return true;
        }
        return entityPlayer.inventory.getItemStack() == null;
    }

    private int calculateRecipeQuantity(List<IngredientDistribution> assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (IngredientDistribution distrib : assignedIngredients) {
            DistributedIngred istack = distrib.distrib;
            if (istack.distributed == 0) continue;
            if (istack.numSlots == 0) {
                return 0;
            }
            int maxStackSize = istack.stack.getMaxStackSize();
            if (maxStackSize == 1 && istack.isContainerItem) continue;
            int allSlots = Math.min(istack.invAmount, istack.numSlots * maxStackSize);
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        if (quantity == Integer.MAX_VALUE) {
            quantity = 1;
        }
        return quantity;
    }

    private Slot[][] assignIngredSlots(GuiContainer gui, List<PositionedStack> ingredients, List<IngredientDistribution> assignedIngredients) {
        Slot[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<Slot, Integer> distribution = new HashMap<Slot, Integer>();
        Slot[][] slotArray = recipeSlots;
        int n = slotArray.length;
        for (int i = 0; i < n; ++i) {
            Slot[] recipeSlot;
            for (Slot slot : recipeSlot = slotArray[i]) {
                if (distribution.containsKey(slot)) continue;
                distribution.put(slot, -1);
            }
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            remainingIngreds.add(i);
            assignedSlots.add(new LinkedList());
        }
        while (!avaliableSlots.isEmpty() && !remainingIngreds.isEmpty()) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean assigned = false;
                DistributedIngred istack = assignedIngredients.get((int)i).distrib;
                for (Slot slot : recipeSlots[i]) {
                    if (!avaliableSlots.contains(slot)) continue;
                    avaliableSlots.remove(slot);
                    if (slot.getHasStack()) continue;
                    ++istack.numSlots;
                    ((LinkedList)assignedSlots.get(i)).add(slot);
                    assigned = true;
                    break;
                }
                if (assigned && istack.numSlots * istack.stack.getMaxStackSize() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            assignedIngredients.get((int)i).slots = ((LinkedList)assignedSlots.get(i)).toArray(new Slot[0]);
        }
        return recipeSlots;
    }

    private List<IngredientDistribution> assignIngredients(List<PositionedStack> ingredients, List<DistributedIngred> ingredStacks) {
        ArrayList<IngredientDistribution> assignedIngredients = new ArrayList<IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DistributedIngred biggestIngred = null;
            ItemStack permutation = null;
            int biggestSize = 0;
            block1: for (ItemStack pstack : posstack.items) {
                for (DistributedIngred istack : ingredStacks) {
                    int relsize;
                    if (!this.canStack(pstack, istack.stack) || istack.invAmount - istack.distributed < pstack.stackSize || istack.recipeAmount == 0 || pstack.stackSize == 0 || (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.stackSize) <= biggestSize) continue;
                    biggestSize = relsize;
                    biggestIngred = istack;
                    permutation = pstack;
                    continue block1;
                }
            }
            if (biggestIngred == null) {
                biggestIngred = new DistributedIngred(posstack.item);
                permutation = InventoryUtils.copyStack((ItemStack)posstack.item, (int)0);
            }
            biggestIngred.distributed += permutation.stackSize;
            assignedIngredients.add(new IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(GuiContainer gui, List<DistributedIngred> ingredStacks) {
        for (Slot slot : gui.inventorySlots.inventorySlots) {
            ItemStack pstack;
            DistributedIngred istack;
            if (!slot.getHasStack() || !this.canMoveFrom(slot, gui) || (istack = this.findIngred(ingredStacks, pstack = slot.getStack())) == null) continue;
            istack.invAmount += pstack.stackSize;
            if (istack.isContainerItem || pstack.getMaxStackSize() != 1 || !pstack.getItem().hasContainerItem(pstack)) continue;
            NBTTagCompound tagCompound = pstack.getTagCompound();
            if (tagCompound != null && tagCompound.hasKey("GT.ToolStats")) {
                istack.isContainerItem = true;
                continue;
            }
            boolean isPausedItemDamageSound = StackInfo.isPausedItemDamageSound();
            StackInfo.pauseItemDamageSound(true);
            ItemStack containerItem = pstack.getItem().getContainerItem(pstack);
            if (containerItem != null) {
                istack.isContainerItem = pstack.getItem() == containerItem.getItem();
            }
            StackInfo.pauseItemDamageSound(isPausedItemDamageSound);
        }
    }

    private List<DistributedIngred> getPermutationIngredients(List<PositionedStack> ingredients) {
        ArrayList<DistributedIngred> ingredStacks = new ArrayList<DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            for (ItemStack pstack : posstack.items) {
                DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.stackSize;
            }
        }
        return ingredStacks;
    }

    public boolean canMoveFrom(Slot slot, GuiContainer gui) {
        return slot.inventory instanceof InventoryPlayer;
    }

    public Slot[][] mapIngredSlots(GuiContainer gui, List<PositionedStack> ingredients) {
        Slot[][] recipeSlotList = new Slot[ingredients.size()][];
        for (int i = 0; i < ingredients.size(); ++i) {
            LinkedList<Slot> recipeSlots = new LinkedList<Slot>();
            PositionedStack pstack = ingredients.get(i);
            for (Slot slot : gui.inventorySlots.inventorySlots) {
                if (slot.xDisplayPosition != pstack.relx + this.offsetx || slot.yDisplayPosition != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new Slot[0]);
        }
        return recipeSlotList;
    }

    public DistributedIngred findIngred(List<DistributedIngred> ingredStacks, ItemStack pstack) {
        for (DistributedIngred istack : ingredStacks) {
            if (!this.canStack(istack.stack, pstack)) continue;
            return istack;
        }
        return null;
    }

    protected boolean canStack(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return true;
        }
        return NEIClientUtils.areStacksSameTypeCraftingWithNBT(stack1, stack2);
    }

    public static class IngredientDistribution {
        public DistributedIngred distrib;
        public ItemStack permutation;
        public Slot[] slots;

        public IngredientDistribution(DistributedIngred distrib, ItemStack permutation) {
            this.distrib = distrib;
            this.permutation = permutation;
        }
    }

    public static class DistributedIngred {
        public ItemStack stack;
        public int invAmount;
        public int distributed;
        public int numSlots;
        public int recipeAmount;
        public boolean isContainerItem = false;

        public DistributedIngred(ItemStack item) {
            this.stack = InventoryUtils.copyStack((ItemStack)item, (int)1);
        }
    }
}

