/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.scroll;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.Widget;
import codechicken.nei.WidgetContainer;
import codechicken.nei.scroll.GuiHelper;
import codechicken.nei.scroll.ScrollBar;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.lwjgl.opengl.GL11;

public class ScrollContainer
extends WidgetContainer {
    protected static final int MOUSE_SCROLL_SPEED = 16;
    protected static final int KEYBOARD_SCROLL_SPEED = 36;
    protected static final int FADE_TICKS = 24;
    protected int xScroll = 0;
    protected int yScroll = 0;
    protected int actualWidth = 0;
    protected int actualHeight = 0;
    protected int marginInline = 0;
    protected int marginBlock = 0;
    protected final Map<Widget, Point> relativePostion = new HashMap<Widget, Point>();
    protected ScrollBar horizontalScrollBar;
    protected ScrollBar verticalScrollBar;
    protected int fade = 0;

    public Rectangle4i boundsOutside() {
        int width = this.w;
        int height = this.h;
        if (this.canScrollVertical() && (this.verticalScrollBar.getOverflowType() == ScrollBar.OverflowType.SCROLL || this.verticalScrollBar.getOverflowType() == ScrollBar.OverflowType.AUTO)) {
            width += this.verticalScrollBar.getMargin();
            if (this.verticalScrollBar.getScrollPlace() == ScrollBar.ScrollPlace.OUTSIDE) {
                width += this.verticalScrollBar.getScrollbarSize();
            }
        }
        if (this.canScrollHorizontal() && (this.horizontalScrollBar.getOverflowType() == ScrollBar.OverflowType.SCROLL || this.horizontalScrollBar.getOverflowType() == ScrollBar.OverflowType.AUTO)) {
            height += this.horizontalScrollBar.getMargin();
            if (this.horizontalScrollBar.getScrollPlace() == ScrollBar.ScrollPlace.OUTSIDE) {
                height += this.horizontalScrollBar.getScrollbarSize();
            }
        }
        return new Rectangle4i(this.x, this.y, width, height);
    }

    public Rectangle4i boundsInside() {
        return new Rectangle4i(this.x, this.y, this.getVisibleWidth(), this.getVisibleHeight());
    }

    @Override
    public void clear() {
        super.clear();
        this.relativePostion.clear();
    }

    @Override
    public boolean removeIf(Predicate<Widget> filter) {
        this.relativePostion.keySet().removeIf(filter);
        return super.removeIf(filter);
    }

    @Override
    public void addWidget(Widget widget) {
        super.addWidget(widget);
        this.relativePostion.put(widget, new Point(widget.x, widget.y));
    }

    public Point getWidgetPosition(Widget widget) {
        return this.relativePostion.get(widget);
    }

    public void setMarginInline(int marginInline) {
        this.marginInline = marginInline;
    }

    public void setMarginBlock(int marginBlock) {
        this.marginBlock = marginBlock;
    }

    public int getMarginInline() {
        return this.marginInline;
    }

    public int getMarginBlock() {
        return this.marginBlock;
    }

    public int getVisibleWidth() {
        if (this.canScrollVertical() && this.verticalScrollBar.getScrollPlace() == ScrollBar.ScrollPlace.INSIDE && (this.verticalScrollBar.getOverflowType() == ScrollBar.OverflowType.SCROLL || this.verticalScrollBar.getOverflowType() == ScrollBar.OverflowType.AUTO)) {
            return this.w - this.verticalScrollBar.getScrollbarSize();
        }
        return this.w;
    }

    public int getActualWidth() {
        return this.actualWidth;
    }

    public boolean setHorizontalScrollOffset(int offset) {
        if (!this.canScrollHorizontal() && this.w < this.getActualWidth()) {
            offset = 0;
        }
        int scroll = this.xScroll;
        this.xScroll = Math.max(0, Math.min(this.getActualWidth() - this.getVisibleWidth(), offset));
        if (scroll != this.xScroll) {
            for (Widget widget : this.widgets) {
                widget.x += scroll - this.xScroll;
            }
            this.fade = 24;
            return true;
        }
        return false;
    }

    public int getHorizontalScrollOffset() {
        return this.xScroll;
    }

    public boolean canScrollHorizontal() {
        return this.horizontalScrollBar != null && (this.horizontalScrollBar.getOverflowType() != ScrollBar.OverflowType.NONE && this.w < this.getActualWidth() || this.horizontalScrollBar.getOverflowType() == ScrollBar.OverflowType.SCROLL);
    }

    public ScrollBar getHorizontalScroll() {
        return this.horizontalScrollBar;
    }

    public ScrollContainer setHorizontalScroll() {
        return this.setHorizontalScroll(ScrollBar.defaultScrollBar());
    }

    public ScrollContainer setHorizontalScroll(ScrollBar scrollBar) {
        this.horizontalScrollBar = scrollBar;
        if (this.horizontalScrollBar != null) {
            this.horizontalScrollBar.setScrollType(ScrollBar.ScrollType.HORIZONTAL);
        }
        return this;
    }

    public int getVisibleHeight() {
        if (this.canScrollHorizontal() && this.horizontalScrollBar.getScrollPlace() == ScrollBar.ScrollPlace.INSIDE && (this.horizontalScrollBar.getOverflowType() == ScrollBar.OverflowType.SCROLL || this.horizontalScrollBar.getOverflowType() == ScrollBar.OverflowType.AUTO)) {
            return this.h - this.horizontalScrollBar.getScrollbarSize();
        }
        return this.h;
    }

    public int getActualHeight() {
        return this.actualHeight;
    }

    public boolean setVerticalScrollOffset(int offset) {
        if (!this.canScrollVertical() && this.h < this.getActualHeight()) {
            offset = 0;
        }
        int scroll = this.yScroll;
        this.yScroll = Math.max(0, Math.min(this.getActualHeight() - this.getVisibleHeight(), offset));
        if (scroll != this.yScroll) {
            for (Widget widget : this.widgets) {
                widget.y += scroll - this.yScroll;
            }
            this.fade = 24;
            return true;
        }
        return false;
    }

    public int getVerticalScrollOffset() {
        return this.yScroll;
    }

    public boolean canScrollVertical() {
        return this.verticalScrollBar != null && (this.verticalScrollBar.getOverflowType() != ScrollBar.OverflowType.NONE && this.h < this.getActualHeight() || this.verticalScrollBar.getOverflowType() == ScrollBar.OverflowType.SCROLL);
    }

    public ScrollBar getVerticalScroll() {
        return this.verticalScrollBar;
    }

    public ScrollContainer setVerticalScroll() {
        return this.setVerticalScroll(ScrollBar.defaultScrollBar());
    }

    public ScrollContainer setVerticalScroll(ScrollBar scrollBar) {
        this.verticalScrollBar = scrollBar;
        if (this.verticalScrollBar != null) {
            this.verticalScrollBar.setScrollType(ScrollBar.ScrollType.VERTICAL);
        }
        return this;
    }

    @Override
    public void draw(int mousex, int mousey) {
        boolean canScrollVertical = this.canScrollVertical();
        boolean canScrollHorizontal = this.canScrollHorizontal();
        if (canScrollVertical || canScrollHorizontal) {
            GuiHelper.useScissor(this.x, this.y, this.getVisibleWidth(), this.getVisibleHeight(), () -> this.drawContent(mousex, mousey));
            GL11.glPushAttrib((int)1048575);
            if (canScrollVertical) {
                this.verticalScrollBar.draw(this, mousex, mousey, this.getScrollBarOpacity());
            }
            if (canScrollHorizontal) {
                this.horizontalScrollBar.draw(this, mousex, mousey, this.getScrollBarOpacity());
            }
            GL11.glPopAttrib();
        } else {
            this.drawContent(mousex, mousey);
        }
    }

    protected void drawContent(int mousex, int mousey) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.draw(mousex, mousey);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private float getScrollBarOpacity() {
        return Math.min(2.0f * (float)this.fade, 24.0f) / 24.0f;
    }

    @Override
    public void update() {
        this.actualHeight = 0;
        this.actualWidth = 0;
        for (Map.Entry<Widget, Point> entry : this.relativePostion.entrySet()) {
            entry.getKey().x = entry.getValue().x;
            entry.getKey().y = entry.getValue().y;
        }
        super.update();
        for (Widget widget : this.widgets) {
            this.actualWidth = Math.max(this.actualWidth, widget.x + widget.w + this.marginInline * 2);
            this.actualHeight = Math.max(this.actualHeight, widget.y + widget.h + this.marginBlock * 2);
            widget.x += this.marginInline + this.x - this.xScroll;
            widget.y += this.marginBlock + this.y - this.yScroll;
        }
        if (this.fade > 0) {
            Point mouse = GuiDraw.getMousePosition();
            this.fade = this.canScrollVertical() && (this.verticalScrollBar.isMouseDragged() || this.verticalScrollBar.trackBounds(this).contains(mouse.x, mouse.y)) ? 24 : (this.canScrollHorizontal() && (this.horizontalScrollBar.isMouseDragged() || this.horizontalScrollBar.trackBounds(this).contains(mouse.x, mouse.y)) ? 24 : --this.fade);
        }
        this.setHorizontalScrollOffset(this.xScroll);
        this.setVerticalScrollOffset(this.yScroll);
    }

    @Override
    public boolean onMouseWheel(int direction, int mousex, int mousey) {
        if (super.onMouseWheel(direction, mousex, mousey)) {
            return true;
        }
        if (this.boundsOutside().contains(mousex, mousey)) {
            if (this.canScrollHorizontal() && (NEIClientUtils.shiftKey() || this.horizontalScrollBar.trackBounds(this).contains(mousex, mousey))) {
                this.horizontalScrollBar.setScrollOffset(this, this.xScroll - direction * 16);
                return true;
            }
            if (this.canScrollVertical()) {
                this.verticalScrollBar.setScrollOffset(this, this.yScroll - direction * 16);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.canScrollVertical() && this.verticalScrollBar.onClick(this, mousex, mousey, button)) {
            return true;
        }
        if (this.canScrollHorizontal() && this.horizontalScrollBar.onClick(this, mousex, mousey, button)) {
            return true;
        }
        return super.handleClick(mousex, mousey, button);
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (this.canScrollVertical() && this.verticalScrollBar.onMouseDragged(this, mousex, mousey, button, heldTime)) {
            return;
        }
        if (this.canScrollHorizontal() && this.horizontalScrollBar.onMouseDragged(this, mousex, mousey, button, heldTime)) {
            return;
        }
        super.mouseDragged(mousex, mousey, button, heldTime);
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        if (this.canScrollVertical()) {
            this.verticalScrollBar.onClickReleased(this, mousex, mousey, button);
        }
        if (this.canScrollHorizontal()) {
            this.horizontalScrollBar.onClickReleased(this, mousex, mousey, button);
        }
        super.mouseUp(mousex, mousey, button);
    }

    @Override
    public boolean handleKeyPress(int keyCode, char keyChar) {
        if (this.isFocused()) {
            switch (keyCode) {
                case 200: {
                    return this.canScrollVertical() && this.verticalScrollBar.setScrollOffset(this, this.yScroll - 36);
                }
                case 208: {
                    return this.canScrollVertical() && this.verticalScrollBar.setScrollOffset(this, this.yScroll + 36);
                }
                case 203: {
                    return this.canScrollHorizontal() && this.horizontalScrollBar.setScrollOffset(this, this.xScroll - 36);
                }
                case 205: {
                    return this.canScrollHorizontal() && this.horizontalScrollBar.setScrollOffset(this, this.xScroll + 36);
                }
            }
        }
        return super.handleKeyPress(keyCode, keyChar);
    }
}

