/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.nei.BookmarkPanel;
import codechicken.nei.bookmark.RecipeChainDetails;
import codechicken.nei.recipe.Recipe;
import java.util.HashSet;
import java.util.Set;

public class BookmarkGroup {
    public RecipeChainDetails crafting = null;
    public BookmarkPanel.BookmarkViewMode viewMode;
    public boolean collapsed = false;
    public Set<Recipe.RecipeId> collapsedRecipes = new HashSet<Recipe.RecipeId>();

    public BookmarkGroup(BookmarkPanel.BookmarkViewMode viewMode) {
        this.viewMode = viewMode;
    }

    public BookmarkGroup(BookmarkPanel.BookmarkViewMode viewMode, boolean crafting) {
        this.viewMode = viewMode;
        this.setCraftingMode(crafting);
    }

    public void toggleViewMode() {
        this.viewMode = this.viewMode == BookmarkPanel.BookmarkViewMode.DEFAULT ? BookmarkPanel.BookmarkViewMode.TODO_LIST : BookmarkPanel.BookmarkViewMode.DEFAULT;
    }

    public void setCraftingMode(boolean crafting) {
        if (this.crafting != null != crafting) {
            this.crafting = crafting ? new RecipeChainDetails() : null;
        }
    }

    public void toggleCraftingMode() {
        this.setCraftingMode(this.crafting == null);
    }

    public void toggleCollapsedState() {
        this.collapsed = !this.collapsed;
    }

    public void toggleCollapsedRecipe(Recipe.RecipeId recipeId) {
        if (this.collapsedRecipes.contains(recipeId)) {
            this.collapsedRecipes.remove(recipeId);
        } else {
            this.collapsedRecipes.add(recipeId);
        }
    }

    public BookmarkGroup copy() {
        return new BookmarkGroup(this.viewMode);
    }
}

