/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.Widget;
import codechicken.nei.api.ShortcutInputHandler;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.guihook.GuiContainerManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiRecipeCatalyst
extends Widget {
    private static final int SLOT_SIZE = 16;
    private static final int BORDER_PADDING = 6;
    private static final DrawableResource BG_TEXTURE = new DrawableBuilder("nei:textures/catalyst_tab.png", 0, 0, 28, 28).setTextureSize(28, 28).build();
    private static final DrawableResource FG_TEXTURE = new DrawableBuilder("nei:textures/slot.png", 0, 0, 18, 18).setTextureSize(18, 18).build();
    private final List<PositionedStack> items = new ArrayList<PositionedStack>();
    private int availableHeight = 0;
    private boolean showWidget = false;
    @Deprecated
    public static final int ingredientSize = 16;
    @Deprecated
    public static final int ingredientBorder = 1;
    @Deprecated
    public static final int tabBorder = 5;
    @Deprecated
    public static final int fullBorder = 6;

    public void setCatalysts(List<PositionedStack> items) {
        this.items.clear();
        this.items.addAll(items);
    }

    public void setAvailableHeight(int height) {
        this.availableHeight = height;
    }

    public int getAvailableHeight() {
        return this.availableHeight;
    }

    public boolean isShowWidget() {
        return this.showWidget;
    }

    public int getColumnCount() {
        int maxItemsPerColumn = Math.max(0, this.availableHeight - 2 - 12) / 16;
        return maxItemsPerColumn > 0 ? NEIServerUtils.divideCeil(this.items.size(), maxItemsPerColumn) : 0;
    }

    public int getRowCount() {
        int columnCount = this.getColumnCount();
        return columnCount > 0 ? NEIServerUtils.divideCeil(this.items.size(), columnCount) : 0;
    }

    @Override
    public void update() {
        int columns = this.getColumnCount();
        int rows = this.getRowCount();
        this.showWidget = rows * columns > 0;
        this.w = columns * 16 + 2 + 12;
        this.h = rows * 16 + 2 + 12;
        if (rows == 0 || columns == 0) {
            return;
        }
        int index = 0;
        for (PositionedStack pStack : this.items) {
            if (pStack.items.length > 1) {
                int stackIndex = (pStack.items.length + pStack.getPermutationIndex(pStack.item) + 1) % pStack.items.length;
                pStack.setPermutationToRender(stackIndex);
            }
            pStack.relx = this.w - 6 - 1 - 16 - index / rows * 16;
            pStack.rely = 7 + index % rows * 16;
            ++index;
        }
    }

    @Override
    public void draw(int mx, int my) {
        if (!this.showWidget) {
            return;
        }
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BG_TEXTURE.draw(0, 0, this.w, this.h, 6, 6, 6, 6);
        FG_TEXTURE.draw(6, 6, this.w - 12, this.h - 12, 1, 1, 1, 1);
        GL11.glPushAttrib((int)1048575);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        for (PositionedStack pStack : this.items) {
            GuiContainerManager.drawItem(pStack.relx, pStack.rely, pStack.item);
            if (!pStack.contains(mx - this.x, my - this.y)) continue;
            NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)pStack.relx, (int)pStack.rely, (int)16, (int)16, (int)-2130706433));
        }
        GL11.glPopAttrib();
        GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)0.0f);
    }

    public PositionedStack getPositionedStackMouseOver(int mx, int my) {
        for (PositionedStack pStack : this.items) {
            if (!pStack.contains(mx - this.x, my - this.y)) continue;
            return pStack;
        }
        return null;
    }

    @Override
    public ItemStack getStackMouseOver(int mx, int my) {
        PositionedStack pStack = this.getPositionedStackMouseOver(mx, my);
        if (pStack != null) {
            return pStack.item;
        }
        return null;
    }

    @Override
    public boolean handleClick(int mx, int my, int button) {
        return ShortcutInputHandler.handleMouseClick(this.getStackMouseOver(mx, my));
    }
}

