/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.Image;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.Widget;
import java.util.List;

public abstract class Button
extends Widget {
    public final String label;
    public Image icon;
    public int state;

    public Button(String s) {
        this.label = s;
    }

    public Button() {
        this.label = "";
    }

    public int contentWidth() {
        return this.getRenderIcon() == null ? GuiDraw.getStringWidth((String)this.getRenderLabel()) : this.getRenderIcon().width;
    }

    @Override
    public void draw(int mousex, int mousey) {
        LayoutManager.getLayoutStyle().drawButton(this, mousex, mousey);
    }

    @Override
    public boolean handleClick(int mx, int my, int button) {
        if ((button == 1 || button == 0) && this.onButtonPress(button == 1)) {
            NEIClientUtils.playClickSound();
        }
        return true;
    }

    public abstract boolean onButtonPress(boolean var1);

    public Image getRenderIcon() {
        return this.icon;
    }

    @Override
    public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
        if (!this.contains(mx, my)) {
            return tooltip;
        }
        String tip = this.getButtonTip();
        if (tip != null) {
            tooltip.add(tip);
        }
        this.addTooltips(tooltip);
        return tooltip;
    }

    public String getButtonTip() {
        return null;
    }

    public void addTooltips(List<String> tooltip) {
    }

    public String getRenderLabel() {
        return this.label;
    }
}

