/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemStackAmount;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.ReadableNumberConverter;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class ItemsTooltipLineHandler
implements GuiDraw.ITooltipLineHandler {
    protected static final int SLOT_SIZE = 18;
    protected static final int MAX_COLUMNS = 11;
    protected static final int MARGIN_TOP = 2;
    protected String label;
    protected EnumChatFormatting labelColor = EnumChatFormatting.GRAY;
    protected List<ItemStack> items;
    protected int activeStackIndex = -1;
    protected Dimension size = new Dimension();
    protected boolean saveStackSize = false;
    protected int columns = 0;
    protected int count = 0;
    protected int rows = 0;
    protected int length = 0;

    public ItemsTooltipLineHandler(String label, List<ItemStack> items) {
        this(label, items, true, 5);
    }

    public ItemsTooltipLineHandler(String label, List<ItemStack> items, boolean saveStackSize, int maxRows) {
        this.label = label;
        this.items = this.groupingItemStacks(items);
        this.saveStackSize = saveStackSize;
        this.length = this.items.size();
        if (this.length > 0) {
            this.columns = Math.min(11, this.length);
            this.rows = Math.min(maxRows, (int)Math.ceil((float)this.length / (float)this.columns));
            this.size.width = Math.max(this.columns * 18, GuiDraw.fontRenderer.getStringWidth(this.label) + 15);
            this.size.height = this.rows * 18 + GuiDraw.fontRenderer.FONT_HEIGHT + 2 + 2;
            this.count = Math.min(this.length, Math.min(this.columns * this.rows, this.length > 11 * maxRows ? 11 * maxRows : Integer.MAX_VALUE));
            if (this.items.size() > this.count) {
                String text = "+" + (this.items.size() - this.count);
                this.count -= (int)Math.ceil((float)(GuiDraw.fontRenderer.getStringWidth(text) - 2) / 18.0f);
            }
        }
    }

    public void setActiveStack(ItemStack activeStack) {
        ItemStack realStack = this.items.stream().filter(stack -> NEIClientUtils.areStacksSameTypeWithNBT(stack, activeStack)).findFirst().orElse(null);
        this.activeStackIndex = this.items.indexOf(realStack);
    }

    public ItemStack getActiveStack() {
        return this.activeStackIndex == -1 ? null : this.items.get(this.activeStackIndex);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setLabelColor(EnumChatFormatting color) {
        this.labelColor = color;
    }

    public void draw(int x, int y) {
        if (this.length == 0) {
            return;
        }
        GuiDraw.fontRenderer.drawStringWithShadow(this.labelColor + this.label + ":", x, y += 2, 0);
        GL11.glEnable((int)32826);
        GL11.glPushAttrib((int)24640);
        RenderHelper.enableGUIStandardItemLighting();
        int xTranslation = x;
        int yTranslation = y + GuiDraw.fontRenderer.FONT_HEIGHT + 2;
        int zTranslation = 400;
        GL11.glTranslatef((float)xTranslation, (float)yTranslation, (float)400.0f);
        int indexShift = 0;
        if (this.activeStackIndex != -1) {
            indexShift = Math.max(0, Math.min(this.items.size() - this.count, this.activeStackIndex - this.count + 2));
        }
        for (int index = 0; index < this.count && index + indexShift < this.items.size(); ++index) {
            String stackSize;
            ItemStack drawStack = this.items.get(index + indexShift);
            int col = index % this.columns;
            int row = index / this.columns;
            String string = stackSize = !this.saveStackSize || drawStack.stackSize == 0 ? "" : ReadableNumberConverter.INSTANCE.toWideReadableForm(drawStack.stackSize);
            if (this.activeStackIndex == index + indexShift) {
                NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)(col * 18 - 1), (int)(row * 18 - 1), (int)18, (int)18, (int)0x66555555));
            }
            this.drawItem(col * 18, row * 18, drawStack, stackSize);
        }
        if (this.count < this.items.size()) {
            String text = "+" + (this.items.size() - this.count);
            NEIClientUtils.gl2DRenderContext(() -> GuiDraw.fontRenderer.drawStringWithShadow(text, 198 - GuiDraw.fontRenderer.getStringWidth(text) - 2, (this.rows - 1) * 18 + (18 - GuiDraw.fontRenderer.FONT_HEIGHT) / 2, -296397483));
        }
        GL11.glTranslatef((float)(-xTranslation), (float)(-yTranslation), (float)-400.0f);
        GL11.glPopAttrib();
    }

    protected void drawItem(int x, int y, ItemStack drawStack, String stackSize) {
        GuiContainerManager.drawItem(x, y, drawStack, true, stackSize);
    }

    private List<ItemStack> groupingItemStacks(List<ItemStack> items) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Map.Entry<NBTTagCompound, Long> entry : ItemStackAmount.of(items).entrySet()) {
            ItemStack stack = StackInfo.loadFromNBT(entry.getKey(), Math.max(0L, entry.getValue()));
            if (entry.getKey().hasKey("gtFluidName")) {
                stack.stackSize = 0;
            }
            result.add(stack);
        }
        if (result.isEmpty()) {
            result.addAll(items);
        }
        return result;
    }
}

