/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.math.MathHelper;
import codechicken.nei.KeyManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIModContainer;
import cpw.mods.fml.relauncher.ReflectionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;

public class WorldOverlayRenderer
implements KeyManager.IKeyStateTracker {
    public static int chunkOverlay = 0;
    public static int mobOverlay = 0;
    private static byte[] mobSpawnCache;
    private static long mobOverlayUpdateTime;
    private static String oregenPatternName;
    private static final Entity dummyEntity;
    private static final AxisAlignedBB aabb;

    public static void reset() {
        mobOverlay = 0;
        chunkOverlay = 0;
        oregenPatternName = null;
    }

    @Override
    public void tickKeyStates() {
        if (Minecraft.getMinecraft().currentScreen != null) {
            return;
        }
        if (KeyManager.keyStates.get((Object)"world.moboverlay").down) {
            mobOverlay = (mobOverlay + 1) % 2;
            NEIClientUtils.printChatMessage((IChatComponent)new ChatComponentText(NEIClientUtils.translate("chat.moboverlay." + mobOverlay, new Object[0])));
        }
        if (KeyManager.keyStates.get((Object)"world.chunkoverlay").down) {
            chunkOverlay = (chunkOverlay + 1) % (NEIModContainer.isGT5Loaded() ? 4 : 3);
            NEIClientUtils.printChatMessage((IChatComponent)new ChatComponentText(NEIClientUtils.translate("chat.chunkoverlay." + chunkOverlay, new Object[0])));
        }
    }

    public static void render(float frame) {
        GL11.glPushMatrix();
        EntityLivingBase entity = Minecraft.getMinecraft().renderViewEntity;
        double interpPosX = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)frame;
        double interpPosY = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)frame;
        double interpPosZ = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)frame;
        int intOffsetX = (int)interpPosX;
        int intOffsetY = (int)interpPosY;
        int intOffsetZ = (int)interpPosZ;
        GL11.glTranslated((double)(-interpPosX + (double)intOffsetX), (double)(-interpPosY + (double)intOffsetY), (double)(-interpPosZ + (double)intOffsetZ));
        WorldOverlayRenderer.renderChunkBounds((Entity)entity, intOffsetX, intOffsetY, intOffsetZ);
        WorldOverlayRenderer.renderMobSpawnOverlay((Entity)entity, intOffsetX, intOffsetY, intOffsetZ);
        GL11.glPopMatrix();
    }

    private static void buildMobSpawnOverlay(Entity entity) {
        if (mobSpawnCache == null) {
            mobSpawnCache = new byte[35937];
        }
        World world = entity.worldObj;
        int worldHeight = world.getHeight();
        int x1 = (int)entity.posX;
        int z1 = (int)entity.posZ;
        int y1 = (int)MathHelper.clip((double)entity.posY, (double)16.0, (double)(worldHeight - 16));
        for (int i = 0; i <= 32; ++i) {
            int x = x1 - 16 + i;
            block1: for (int j = 0; j <= 32; ++j) {
                int z = z1 - 16 + j;
                int bufIndex = (i * 33 + j) * 33;
                Chunk chunk = world.getChunkFromBlockCoords(x, z);
                BiomeGenBase biome = world.getBiomeGenForCoords(x, z);
                if (biome.getSpawnableList(EnumCreatureType.monster).isEmpty() || biome.getSpawningChance() <= 0.0f) {
                    WorldOverlayRenderer.mobSpawnCache[bufIndex] = -1;
                    continue;
                }
                int maxHeight = chunk.worldObj.getHeightValue(x, z);
                for (int k = 0; k <= 32; ++k) {
                    int y = y1 - 16 + k;
                    if (y >= worldHeight) {
                        WorldOverlayRenderer.mobSpawnCache[bufIndex + k] = -1;
                        continue;
                    }
                    if (y > maxHeight) {
                        WorldOverlayRenderer.mobSpawnCache[bufIndex + k] = -1;
                        continue block1;
                    }
                    WorldOverlayRenderer.mobSpawnCache[bufIndex + k] = WorldOverlayRenderer.getSpawnMode(chunk, x, y, z);
                }
            }
        }
    }

    private static void renderMobSpawnOverlay(Entity entity, int intOffsetX, int intOffsetY, int intOffsetZ) {
        if (mobOverlay == 0) {
            if (mobSpawnCache != null) {
                mobSpawnCache = null;
            }
            return;
        }
        long worldTime = entity.worldObj.getTotalWorldTime();
        if (mobSpawnCache == null || mobOverlayUpdateTime != worldTime) {
            mobOverlayUpdateTime = worldTime;
            WorldOverlayRenderer.buildMobSpawnOverlay(entity);
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        byte curSpawnMode = 2;
        World world = entity.worldObj;
        int x1 = (int)entity.posX - intOffsetX;
        int z1 = (int)entity.posZ - intOffsetZ;
        int y1 = (int)MathHelper.clip((double)entity.posY, (double)16.0, (double)(world.getHeight() - 16)) - intOffsetY;
        Tessellator tess = Tessellator.instance;
        tess.startDrawing(1);
        tess.setColorOpaque(255, 0, 0);
        for (int i = 0; i <= 32; ++i) {
            int x = x1 - 16 + i;
            block1: for (int j = 0; j <= 32; ++j) {
                int z = z1 - 16 + j;
                int cacheIndex = (i * 33 + j) * 33;
                for (int k = 0; k <= 32; ++k) {
                    int y = y1 - 16 + k;
                    byte spawnMode = mobSpawnCache[cacheIndex + k];
                    if (spawnMode == 0) continue;
                    if (spawnMode == -1) continue block1;
                    if (spawnMode != curSpawnMode) {
                        if (spawnMode == 1) {
                            tess.setColorOpaque(255, 255, 0);
                        } else {
                            tess.setColorOpaque(255, 0, 0);
                        }
                        curSpawnMode = spawnMode;
                    }
                    tess.addVertex((double)x, (double)y + 0.02, (double)z);
                    tess.addVertex((double)(x + 1), (double)y + 0.02, (double)(z + 1));
                    tess.addVertex((double)(x + 1), (double)y + 0.02, (double)z);
                    tess.addVertex((double)x, (double)y + 0.02, (double)(z + 1));
                }
            }
        }
        tess.draw();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static byte getSpawnMode(Chunk chunk, int x, int y, int z) {
        if (y >= chunk.worldObj.getHeight()) {
            return 0;
        }
        if (chunk.getSavedLightValue(EnumSkyBlock.Block, x & 0xF, y, z & 0xF) >= 8 || !SpawnerAnimals.canCreatureTypeSpawnAtLocation((EnumCreatureType)EnumCreatureType.monster, (World)chunk.worldObj, (int)x, (int)y, (int)z)) {
            return 0;
        }
        WorldOverlayRenderer.aabb.minX = (double)x + 0.2;
        WorldOverlayRenderer.aabb.maxX = (double)x + 0.8;
        WorldOverlayRenderer.aabb.minY = (double)y + 0.01;
        WorldOverlayRenderer.aabb.maxY = (double)y + 1.8;
        WorldOverlayRenderer.aabb.minZ = (double)z + 0.2;
        WorldOverlayRenderer.aabb.maxZ = (double)z + 0.8;
        if (!chunk.worldObj.getCollidingBoundingBoxes(dummyEntity, aabb).isEmpty() || chunk.worldObj.isAnyLiquid(aabb)) {
            return 0;
        }
        return (byte)(chunk.getSavedLightValue(EnumSkyBlock.Sky, x & 0xF, y, z & 0xF) >= 8 ? 1 : 2);
    }

    private static void renderChunkBounds(Entity entity, int intOffsetX, int intOffsetY, int intOffsetZ) {
        if (chunkOverlay == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        Tessellator tess = Tessellator.instance;
        tess.startDrawing(1);
        for (int cx = -4; cx <= 4; ++cx) {
            for (int cz = -4; cz <= 4; ++cz) {
                int gz1;
                int gx1;
                double x1 = (entity.chunkCoordX + cx << 4) - intOffsetX;
                double z1 = (entity.chunkCoordZ + cz << 4) - intOffsetZ;
                double x2 = x1 + 16.0;
                double z2 = z1 + 16.0;
                double dy = 128.0;
                double y1 = Math.floor(entity.posY - dy / 2.0);
                double y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.worldObj.getHeight()) {
                    y2 = entity.worldObj.getHeight();
                    y1 = y2 - dy;
                }
                y1 -= (double)intOffsetY;
                y2 -= (double)intOffsetY;
                double dist = Math.pow(1.5, -(cx * cx + cz * cz));
                tess.setColorRGBA_F(0.9f, 0.0f, 0.0f, (float)dist);
                if (cx >= 0 && cz >= 0) {
                    tess.addVertex(x2, y1, z2);
                    tess.addVertex(x2, y2, z2);
                }
                if (cx >= 0 && cz <= 0) {
                    tess.addVertex(x2, y1, z1);
                    tess.addVertex(x2, y2, z1);
                }
                if (cx <= 0 && cz >= 0) {
                    tess.addVertex(x1, y1, z2);
                    tess.addVertex(x1, y2, z2);
                }
                if (cx <= 0 && cz <= 0) {
                    tess.addVertex(x1, y1, z1);
                    tess.addVertex(x1, y2, z1);
                }
                if (cx != 0 || cz != 0) continue;
                if (chunkOverlay == 2) {
                    dy = 32.0;
                    y1 = Math.floor(entity.posY - dy / 2.0);
                    y2 = y1 + dy;
                    if (y1 < 0.0) {
                        y1 = 0.0;
                        y2 = dy;
                    }
                    if (y1 > (double)entity.worldObj.getHeight()) {
                        y2 = entity.worldObj.getHeight();
                        y1 = y2 - dy;
                    }
                    y2 -= (double)intOffsetY;
                    tess.setColorRGBA_F(0.0f, 0.9f, 0.0f, 0.4f);
                    for (double y = (double)((int)(y1 -= (double)intOffsetY)); y <= y2; y += 1.0) {
                        tess.addVertex(x2, y, z1);
                        tess.addVertex(x2, y, z2);
                        tess.addVertex(x1, y, z1);
                        tess.addVertex(x1, y, z2);
                        tess.addVertex(x1, y, z2);
                        tess.addVertex(x2, y, z2);
                        tess.addVertex(x1, y, z1);
                        tess.addVertex(x2, y, z1);
                    }
                    for (double h = 1.0; h <= 15.0; h += 1.0) {
                        tess.addVertex(x1 + h, y1, z1);
                        tess.addVertex(x1 + h, y2, z1);
                        tess.addVertex(x1 + h, y1, z2);
                        tess.addVertex(x1 + h, y2, z2);
                        tess.addVertex(x1, y1, z1 + h);
                        tess.addVertex(x1, y2, z1 + h);
                        tess.addVertex(x2, y1, z1 + h);
                        tess.addVertex(x2, y2, z1 + h);
                    }
                    continue;
                }
                if (chunkOverlay != 3) continue;
                if (WorldOverlayRenderer.getOregenPatternName().equals("EQUAL_SPACING")) {
                    gx1 = (Math.floorDiv(entity.chunkCoordX, 3) * 3 << 4) - intOffsetX;
                    gz1 = (Math.floorDiv(entity.chunkCoordZ, 3) * 3 << 4) - intOffsetZ;
                } else {
                    gx1 = ((entity.chunkCoordX < 0 ? entity.chunkCoordX - 3 : entity.chunkCoordX) / 3 * 3 << 4) - intOffsetX;
                    gz1 = ((entity.chunkCoordZ < 0 ? entity.chunkCoordZ - 3 : entity.chunkCoordZ) / 3 * 3 << 4) - intOffsetZ;
                    if (entity.chunkCoordX < 0) {
                        gx1 += 16;
                    }
                    if (entity.chunkCoordZ < 0) {
                        gz1 += 16;
                    }
                }
                int gx2 = gx1 + 48;
                int gz2 = gz1 + 48;
                tess.setColorRGBA_F(0.0f, 0.9f, 0.0f, 0.4f);
                for (double y = (double)((int)y1); y <= y2; y += 1.0) {
                    tess.addVertex((double)gx2, y, (double)gz1);
                    tess.addVertex((double)gx2, y, (double)gz2);
                    tess.addVertex((double)gx1, y, (double)gz1);
                    tess.addVertex((double)gx1, y, (double)gz2);
                    tess.addVertex((double)gx1, y, (double)gz2);
                    tess.addVertex((double)gx2, y, (double)gz2);
                    tess.addVertex((double)gx1, y, (double)gz1);
                    tess.addVertex((double)gx2, y, (double)gz1);
                }
                for (double h = 4.0; h <= 44.0; h += 4.0) {
                    if (h % 16.0 == 0.0) continue;
                    tess.addVertex((double)gx1 + h, y1, (double)gz1);
                    tess.addVertex((double)gx1 + h, y2, (double)gz1);
                    tess.addVertex((double)gx1 + h, y1, (double)gz2);
                    tess.addVertex((double)gx1 + h, y2, (double)gz2);
                    tess.addVertex((double)gx1, y1, (double)gz1 + h);
                    tess.addVertex((double)gx1, y2, (double)gz1 + h);
                    tess.addVertex((double)gx2, y1, (double)gz1 + h);
                    tess.addVertex((double)gx2, y2, (double)gz1 + h);
                }
                tess.setColorRGBA_F(0.0f, 0.0f, 0.9f, 0.4f);
                gx2 = (gx1 += 23) + 1;
                gz2 = (gz1 += 23) + 1;
                tess.addVertex((double)gx1, y1, (double)gz1);
                tess.addVertex((double)gx1, y2, (double)gz1);
                tess.addVertex((double)gx2, y1, (double)gz1);
                tess.addVertex((double)gx2, y2, (double)gz1);
                tess.addVertex((double)gx1, y1, (double)gz2);
                tess.addVertex((double)gx1, y2, (double)gz2);
                tess.addVertex((double)gx2, y1, (double)gz2);
                tess.addVertex((double)gx2, y2, (double)gz2);
            }
        }
        tess.draw();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static String getOregenPatternName() {
        if (oregenPatternName == null) {
            try {
                ClassLoader loader = WorldOverlayRenderer.class.getClassLoader();
                Class gtWorldGenerator = ReflectionHelper.getClass((ClassLoader)loader, (String[])new String[]{"gregtech.common.GTWorldgenerator", "gregtech.common.GT_Worldgenerator"});
                oregenPatternName = ((Enum)gtWorldGenerator.getDeclaredField("oregenPattern").get(null)).name();
            }
            catch (Exception ignored) {
                oregenPatternName = "AXISSYMMETRICAL";
            }
        }
        return oregenPatternName;
    }

    public static void load() {
        KeyManager.trackers.add(new WorldOverlayRenderer());
    }

    static {
        dummyEntity = new EntityPig(null);
        aabb = AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }
}

