/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config.preset;

import codechicken.core.gui.GuiCCButton;
import codechicken.core.gui.GuiWidget;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PresetsList;
import codechicken.nei.config.GuiOptionPane;
import codechicken.nei.config.Option;
import codechicken.nei.config.preset.GuiPresetSettings;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiPresetList
extends GuiOptionPane {
    private final Option opt;
    protected static final int SLOT_HEIGHT = 24;
    protected static final int BUTTON_HEIGHT = 20;
    protected GuiCCButton createButton;
    protected GuiCCButton toggleButton;
    protected int sortingItemIndex = -1;

    public GuiPresetList(Option opt) {
        this.opt = opt;
        this.createButton = new GuiCCButton(0, 2, 0, 16, NEIClientUtils.translate("presets.new", new Object[0])).setActionCommand("create");
        this.toggleButton = new GuiCCButton(0, 2, 0, 16, NEIClientUtils.translate("presets.toggle", new Object[0])).setActionCommand("toggle");
    }

    @Override
    public void initGui() {
        super.initGui();
        this.createButton.width = GuiDraw.getStringWidth((String)this.createButton.text) + 15;
        this.createButton.x = this.width - this.createButton.width - 15;
        this.toggleButton.width = GuiDraw.getStringWidth((String)this.toggleButton.text) + 15;
        this.toggleButton.x = this.width - this.toggleButton.width - 15 - this.createButton.width - 10;
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        this.add((GuiWidget)this.createButton);
        this.add((GuiWidget)this.toggleButton);
    }

    @Override
    public void actionPerformed(String ident, Object ... params) {
        super.actionPerformed(ident, params);
        if (ident.equals("create")) {
            this.cretePreset();
        }
        if (ident.equals("toggle")) {
            this.togglePreset();
        }
    }

    protected void mouseMovedOrUp(int x, int y, int button) {
        int slot;
        super.mouseMovedOrUp(x, y, button);
        if (this.sortingItemIndex >= 0) {
            PresetsList.savePresets();
        } else if (button == 0 && (slot = this.getSlotMouseOver(x, y)) != -1) {
            Rectangle w = this.pane.windowBounds();
            int mx = x - w.x;
            if (mx <= 20) {
                PresetsList.Preset preset = PresetsList.presets.get(slot);
                preset.enabled = !preset.enabled;
                PresetsList.savePresets();
            } else if (mx >= 26 && mx <= w.width - 52) {
                this.openPreset(slot);
            } else if (mx >= w.width - 20) {
                PresetsList.presets.remove(slot);
                PresetsList.savePresets();
            }
        }
        this.sortingItemIndex = -1;
    }

    protected void mouseClickMove(int x, int y, int button, long time) {
        super.mouseClickMove(x, y, button, time);
        if (this.sortingItemIndex == -1) {
            Rectangle w = this.pane.windowBounds();
            int mx = x - w.x;
            this.sortingItemIndex = mx >= 26 && mx <= w.width - 52 ? this.getSlotMouseOver(x, y) : -2;
        } else if (this.sortingItemIndex >= 0) {
            Rectangle w = this.pane.windowBounds();
            if (y >= w.y && y <= w.y + w.height) {
                int my = y + this.pane.scrolledPixels() - w.y;
                int slot = my / 24;
                if (my % 24 < 20 && slot < PresetsList.presets.size() && slot != -1 && slot != this.sortingItemIndex) {
                    PresetsList.presets.add(slot, PresetsList.presets.remove(this.sortingItemIndex));
                    this.sortingItemIndex = slot;
                }
            }
        }
    }

    protected int getSlotMouseOver(int x, int y) {
        Rectangle w = this.pane.windowBounds();
        if (x >= w.x && x <= w.x + w.width && y >= w.y && y <= w.y + w.height) {
            int my = y + this.pane.scrolledPixels() - w.y;
            int slot = my / 24;
            if (my % 24 < 20 && slot < PresetsList.presets.size()) {
                return slot;
            }
        }
        return -1;
    }

    protected void cretePreset() {
        Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new GuiPresetSettings((GuiScreen)this, -1));
    }

    protected void togglePreset() {
        boolean enabled = PresetsList.presets.stream().noneMatch(g -> g.enabled);
        for (PresetsList.Preset preset : PresetsList.presets) {
            preset.enabled = enabled;
        }
        PresetsList.savePresets();
    }

    protected void openPreset(int slot) {
        Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new GuiPresetSettings((GuiScreen)this, slot));
    }

    @Override
    public int contentHeight() {
        return PresetsList.presets.size() * 24;
    }

    @Override
    public void drawContent(int mx, int my, float frame) {
        int scrolled = this.pane.scrolledPixels();
        Rectangle w = this.pane.windowBounds();
        int y = 0;
        for (int slot = 0; slot < PresetsList.presets.size(); ++slot) {
            if (y + 24 > scrolled && y < scrolled + w.height && this.sortingItemIndex != slot) {
                this.drawSlot(w, slot, w.x, w.y + y - scrolled, mx, my - y);
            }
            y += 24;
        }
        if (this.sortingItemIndex >= 0) {
            this.drawSlot(w, this.sortingItemIndex, w.x, w.y + my - scrolled - 10, mx, my - y);
        }
    }

    protected void drawSlot(Rectangle w, int slot, int x, int y, int mx, int my) {
        String modeName;
        Rectangle4i delete = new Rectangle4i(x + w.width - 20, y, 20, 20);
        Rectangle4i enabled = new Rectangle4i(x, y, 20, 20);
        Rectangle4i option = new Rectangle4i(x + 26, y, w.width - 52, 20);
        int enabledState = y + my >= w.y && y + my <= w.y + w.height && enabled.contains(x + mx, y + my) ? 2 : 1;
        int optionState = y + my >= w.y && y + my <= w.y + w.height && option.contains(x + mx, y + my) ? 2 : 1;
        int deleteState = y + my >= w.y && y + my <= w.y + w.height && delete.contains(x + mx, y + my) ? 2 : 1;
        PresetsList.Preset preset = PresetsList.presets.get(slot);
        String displayName = preset.name;
        switch (preset.mode) {
            case HIDE: {
                modeName = EnumChatFormatting.GOLD + NEIClientUtils.translate("presets.mode.hide.char", new Object[0]) + EnumChatFormatting.RESET;
                break;
            }
            case SUBSET: {
                modeName = EnumChatFormatting.DARK_PURPLE + NEIClientUtils.translate("presets.mode.subset.char", new Object[0]) + EnumChatFormatting.RESET;
                break;
            }
            case REMOVE: {
                modeName = EnumChatFormatting.RED + NEIClientUtils.translate("presets.mode.remove.char", new Object[0]) + EnumChatFormatting.RESET;
                break;
            }
            case GROUP: {
                modeName = EnumChatFormatting.AQUA + NEIClientUtils.translate("presets.mode.group.char", new Object[0]) + EnumChatFormatting.RESET;
                break;
            }
            default: {
                modeName = "?";
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LayoutManager.drawButtonBackground(enabled.x, enabled.y, enabled.w, enabled.h, true, preset.enabled ? 0 : enabledState);
        GuiDraw.drawString((String)"\u2714", (int)(enabled.x + 7), (int)(enabled.y + 6), (int)(enabledState == 2 ? -96 : -2039584));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LayoutManager.drawButtonBackground(option.x, option.y, option.w, option.h, true, optionState);
        GuiDraw.drawString((String)"\u22ee\u22ee", (int)(option.x + 4), (int)(option.y + 5), (int)(optionState == 2 ? -96 : -2039584));
        GuiDraw.drawString((String)NEIClientUtils.cropText(this.fontRendererObj, modeName + " " + displayName, option.w - 16), (int)(option.x + 6 + 4), (int)(option.y + 6), (int)(optionState == 2 ? -96 : -2039584));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LayoutManager.drawButtonBackground(delete.x, delete.y, delete.w, delete.h, true, deleteState);
        GuiDraw.drawString((String)"\u2715", (int)(delete.x + 7), (int)(delete.y + 6), (int)(deleteState == 2 ? -96 : -2039584));
    }

    @Override
    public GuiScreen getParentScreen() {
        return this.opt.slot.getGui();
    }

    @Override
    public String getTitle() {
        return this.opt.translateN(this.opt.name, new Object[0]);
    }
}

