/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.Widget;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.event.NEIRegisterHandlerInfosEvent;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import codechicken.nei.shadow.org.apache.commons.csv.CSVFormat;
import codechicken.nei.shadow.org.apache.commons.csv.CSVParser;
import codechicken.nei.shadow.org.apache.commons.csv.CSVRecord;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiRecipeTab
extends Widget {
    public static HandlerInfo DEFAULT_HANDLER_INFO = GuiRecipeTab.getDefaultHandlerInfo();
    public static HashMap<String, HandlerInfo> handlerMap = new HashMap();
    public static HashMap<String, HandlerInfo> handlerAdderFromIMC = new HashMap();
    public static Set<String> handlerRemoverFromIMC = new HashSet<String>();
    protected final IRecipeHandler handler;
    protected final String handlerName;
    protected final String handlerID;
    private boolean selected;

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract DrawableResource getSelectedTabImage();

    public abstract DrawableResource getUnselectedTabImage();

    protected abstract int getForegroundIconX();

    protected abstract int getForegroundIconY();

    public GuiRecipeTab(IRecipeHandler handler, int x, int y) {
        this.x = x;
        this.y = y;
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.handler = handler;
        this.handlerName = handler.getHandlerId();
        this.selected = false;
        this.handlerID = handler instanceof TemplateRecipeHandler ? handler.getOverlayIdentifier() : null;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        this.drawBackground(mouseX, mouseY);
        this.drawForeground(mouseX, mouseY);
    }

    public void drawBackground(int mouseX, int mouseY) {
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DrawableResource image = this.selected ? this.getSelectedTabImage() : this.getUnselectedTabImage();
        int iconX = this.x + (this.w - image.getWidth()) / 2;
        int iconY = this.y + (this.h - image.getHeight()) / 2;
        image.draw(iconX, iconY);
    }

    public void drawForeground(int mouseX, int mouseY) {
        ItemStack itemStack;
        int iconX = this.getForegroundIconX();
        int iconY = this.getForegroundIconY();
        FontRenderer fontRenderer = GuiDraw.fontRenderer;
        HandlerInfo handlerInfo = GuiRecipeTab.getHandlerInfo(this.handlerName, this.handlerID);
        DrawableResource icon = handlerInfo != null ? handlerInfo.getImage() : null;
        ItemStack itemStack2 = itemStack = handlerInfo != null ? handlerInfo.getItemStack() : null;
        if (icon != null) {
            icon.draw(iconX + 1, iconY + 1);
        } else if (itemStack != null) {
            boolean isEnabled = GL11.glIsEnabled((int)32826);
            GL11.glEnable((int)32826);
            GuiContainerManager.drawItems.zLevel += 100.0f;
            GuiContainerManager.drawItem(iconX, iconY, itemStack);
            GuiContainerManager.drawItems.zLevel -= 100.0f;
            if (!isEnabled) {
                GL11.glDisable((int)32826);
            }
        } else {
            String text = this.handler.getRecipeName();
            if (text != null && text.length() > 0) {
                if (text.length() > 2) {
                    text = text.substring(0, 2);
                }
            } else {
                text = "??";
            }
            int textCenterX = this.x + (int)((float)this.getWidth() / 2.0f);
            int textCenterY = this.y + (int)((float)this.getHeight() / 2.0f) - 3;
            int color = this.selected ? 0xFFFFA0 : 0xE0E0E0;
            fontRenderer.drawStringWithShadow(text, textCenterX - (int)((float)fontRenderer.getStringWidth(text) / 2.0f), textCenterY, color);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void addTooltips(List<String> tooltip) {
        boolean shiftHeld;
        tooltip.add(this.handler.getRecipeTabName().trim());
        String handlerMod = GuiRecipeTab.getHandlerMod(this.handlerName, this.handlerID);
        tooltip.add(EnumChatFormatting.BLUE + handlerMod);
        boolean bl = shiftHeld = Keyboard.getEventKeyState() && (Keyboard.getEventKey() == 42 || Keyboard.getEventKey() == 54);
        if (handlerMod.equals("Unknown") || shiftHeld) {
            tooltip.add("");
            tooltip.add("HandlerName: " + this.handlerName);
            tooltip.add("HandlerID: " + this.handlerID);
            tooltip.add("HandlerOrder: " + NEIClientConfig.getHandlerOrder(this.handler));
        }
    }

    public abstract boolean onButtonPress(boolean var1);

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public static HandlerInfo getHandlerInfo(IRecipeHandler handler) {
        String handlerID = handler instanceof TemplateRecipeHandler ? handler.getOverlayIdentifier() : null;
        HandlerInfo info = GuiRecipeTab.getHandlerInfo(handler.getHandlerId(), handlerID);
        if (info == null) {
            return DEFAULT_HANDLER_INFO;
        }
        return info;
    }

    public static HandlerInfo getHandlerInfo(String name, String name2) {
        HandlerInfo res = handlerMap.get(name);
        if (res == null) {
            res = handlerMap.get(name2);
        }
        return res;
    }

    public static String getHandlerMod(String name, String name2) {
        HandlerInfo info = GuiRecipeTab.getHandlerInfo(name, name2);
        if (info == null) {
            return "Unknown";
        }
        return info.getModName();
    }

    public static void loadHandlerInfo() {
        URL url;
        boolean fromJar = NEIClientConfig.loadHandlersFromJar();
        NEIClientConfig.logger.info("Loading handler info from " + (fromJar ? "JAR" : "Config"));
        handlerMap.clear();
        URL handlerUrl = GuiRecipeTab.class.getResource("/assets/nei/csv/handlers.csv");
        if (fromJar) {
            url = handlerUrl;
            if (url == null) {
                NEIClientConfig.logger.info("Invalid URL for handlers csv.");
                return;
            }
        } else {
            File handlerFile = NEIClientConfig.handlerFile;
            if (!handlerFile.exists()) {
                NEIClientConfig.logger.info("Config file doesn't exist, creating");
                try (FileOutputStream fileOutputStream = new FileOutputStream(handlerFile.getAbsoluteFile());){
                    assert (handlerUrl != null);
                    ReadableByteChannel readableByteChannel = Channels.newChannel(handlerUrl.openStream());
                    FileChannel fileChannel = fileOutputStream.getChannel();
                    fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
            try {
                url = NEIClientConfig.handlerFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                NEIClientConfig.logger.info("Invalid URL for handlers csv (via config).");
                e.printStackTrace();
                return;
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            CSVParser csvParser = CSVFormat.EXCEL.builder().setHeader(new String[0]).setSkipHeaderRecord(true).build().parse(reader);
            for (CSVRecord record : csvParser) {
                String yShift;
                String itemName;
                String handler = record.get("handler");
                String modName = record.get("modName");
                String modId = record.get("modId");
                boolean requiresMod = Boolean.parseBoolean(record.get("modRequired"));
                String excludedModId = record.get("excludedModId");
                if (requiresMod && !Loader.isModLoaded((String)modId) || excludedModId != null && Loader.isModLoaded((String)excludedModId)) continue;
                HandlerInfo info = new HandlerInfo(handler, modName, modId, requiresMod, excludedModId);
                String imageResource = record.get("imageResource");
                if (imageResource != null && !imageResource.equals("")) {
                    info.setImage(imageResource, Integer.parseInt(record.get("imageX")), Integer.parseInt(record.get("imageY")), Integer.parseInt(record.get("imageWidth")), Integer.parseInt(record.get("imageHeight")));
                }
                if (!info.hasImageOrItem() && (itemName = record.get("itemName")) != null && !itemName.equals("")) {
                    info.setItem(itemName, record.get("nbtInfo"));
                }
                if ((yShift = record.get("yShift")) != null && !yShift.equals("")) {
                    info.setYShift(Integer.parseInt(yShift));
                }
                try {
                    int imageHeight = GuiRecipeTab.intOrDefault(record.get("handlerHeight"), HandlerInfo.DEFAULT_HEIGHT);
                    int imageWidth = GuiRecipeTab.intOrDefault(record.get("handlerWidth"), HandlerInfo.DEFAULT_WIDTH);
                    int maxRecipesPerPage = GuiRecipeTab.intOrDefault(record.get("maxRecipesPerPage"), HandlerInfo.DEFAULT_MAX_PER_PAGE);
                    info.setHandlerDimensions(imageHeight, imageWidth, maxRecipesPerPage);
                }
                catch (NumberFormatException ignored) {
                    NEIClientConfig.logger.info("Error setting handler dimensions for " + handler);
                }
                info.setUseCustomScroll(record.isSet("useCustomScroll") ? Boolean.parseBoolean(record.get("useCustomScroll")) : false);
                handlerMap.put(handler, info);
                NEIClientConfig.logger.info("Loaded " + handler);
            }
        }
        catch (Exception e) {
            NEIClientConfig.logger.info("Error parsing CSV");
            e.printStackTrace();
        }
        handlerMap.keySet().removeAll(handlerRemoverFromIMC);
        handlerMap.putAll(handlerAdderFromIMC);
        if (!handlerAdderFromIMC.isEmpty()) {
            HashSet<String> handlerIds = new HashSet<String>(handlerMap.keySet());
            handlerAdderFromIMC.keySet().forEach(handlerName -> {
                if (!handlerIds.contains(handlerName)) {
                    NEIClientConfig.logger.warn("Could not find a registered handlerID that matches " + handlerName);
                    handlerIds.forEach(handler -> {
                        if (handler.equalsIgnoreCase((String)handlerName)) {
                            NEIClientConfig.logger.warn("  -- Did you mean: " + handler);
                        }
                    });
                }
            });
        }
        NEIClientConfig.logger.info("Sending {}", new Object[]{NEIRegisterHandlerInfosEvent.class.getSimpleName()});
        MinecraftForge.EVENT_BUS.post((Event)new NEIRegisterHandlerInfosEvent());
    }

    private static HandlerInfo getDefaultHandlerInfo() {
        HandlerInfo info = new HandlerInfo("Unknown", "Unknown", "Unknown", false, "");
        info.setHandlerDimensions(HandlerInfo.DEFAULT_HEIGHT, HandlerInfo.DEFAULT_WIDTH, HandlerInfo.DEFAULT_MAX_PER_PAGE);
        return info;
    }

    private static int intOrDefault(String str, int defaultValue) {
        if (str == null || str.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

