/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe.stackinfo;

import codechicken.nei.api.IStackStringifyHandler;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class DefaultStackStringifyHandler
implements IStackStringifyHandler {
    @Override
    public NBTTagCompound convertItemStackToNBT(ItemStack stack, boolean saveStackSize) {
        String strId = Item.itemRegistry.getNameForObject((Object)stack.getItem());
        if (strId == null) {
            return null;
        }
        NBTTagCompound nbTag = new NBTTagCompound();
        nbTag.setString("strId", strId);
        nbTag.setInteger("Count", saveStackSize ? stack.stackSize : 1);
        nbTag.setShort("Damage", (short)stack.getItemDamage());
        if (stack.hasTagCompound() && !stack.getTagCompound().hasNoTags()) {
            nbTag.setTag("tag", stack.getTagCompound().copy());
        }
        return nbTag;
    }

    @Override
    public ItemStack convertNBTToItemStack(NBTTagCompound nbtTag) {
        String strId = nbtTag.getString("strId");
        nbtTag = (NBTTagCompound)nbtTag.copy();
        nbtTag.setShort("id", (short)GameData.getItemRegistry().getId(strId));
        ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbtTag);
        if (stack != null) {
            stack.stackSize = nbtTag.getInteger("Count");
        }
        return stack;
    }

    @Override
    public FluidStack getFluid(ItemStack stack) {
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (fluidStack == null && stack.getItem() instanceof IFluidContainerItem) {
            fluidStack = ((IFluidContainerItem)stack.getItem()).getFluid(stack);
        }
        return fluidStack;
    }
}

