/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchField;
import codechicken.nei.SearchTextFormatter;
import codechicken.nei.TextField;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.util.TextHistory;
import net.minecraft.util.EnumChatFormatting;

public abstract class RecipeSearchField
extends TextField
implements ItemFilter.ItemFilterProvider,
IRecipeFilter.IRecipeFilterProvider {
    private static final TextHistory history = new TextHistory();

    public RecipeSearchField(String ident) {
        super(ident);
        this.field.setVisible(false);
    }

    @Override
    protected void initInternalTextField() {
        SearchField.GuiSearchField field = new SearchField.GuiSearchField();
        field.setMaxStringLength(256);
        field.setCursorPositionZero();
        field.setSkipRecipeTokens(true);
        ((SearchTextFormatter)field.getFormatter()).setContextToken("<>");
        this.field = field;
    }

    public boolean isVisible() {
        return this.field.getVisible();
    }

    public void setVisible(boolean visible) {
        this.field.setVisible(visible);
    }

    protected abstract boolean noResults();

    @Override
    public int getTextColour() {
        if (!this.text().isEmpty() && !this.noResults()) {
            return this.focused() ? -3394816 : -6737152;
        }
        return this.focused() ? -2039584 : -7303024;
    }

    @Override
    public void lastKeyTyped(int keyID, char keyChar) {
        if (this.focused() && NEIClientConfig.isKeyHashDown("gui.getprevioussearch")) {
            this.handleNavigateHistory(TextHistory.Direction.PREVIOUS);
        }
        if (this.focused() && NEIClientConfig.isKeyHashDown("gui.getnextsearch")) {
            this.handleNavigateHistory(TextHistory.Direction.NEXT);
        }
    }

    @Override
    public String filterText(String s) {
        return EnumChatFormatting.getTextWithoutFormattingCodes((String)s);
    }

    @Override
    public ItemFilter getFilter() {
        return ((SearchField.GuiSearchField)this.field).getFilter();
    }

    @Override
    public IRecipeFilter getRecipeFilter() {
        return ((SearchField.GuiSearchField)this.field).getRecipeFilter();
    }

    @Override
    public void setFocus(boolean focus) {
        boolean previousFocus = this.field.isFocused();
        if (previousFocus != focus) {
            history.add(this.text());
        }
        super.setFocus(focus);
    }

    private boolean handleNavigateHistory(TextHistory.Direction direction) {
        if (this.focused()) {
            return history.get(direction, this.text()).map(newText -> {
                this.setText((String)newText);
                return true;
            }).orElse(false);
        }
        return false;
    }
}

