/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;

public abstract class TextField
extends Widget {
    protected GuiTextField field;
    protected static final int maxSearchLength = 256;
    public boolean centered;
    public String identifier;
    private boolean previousKeyboardRepeatEnabled;

    protected void initInternalTextField() {
        this.field = new GuiTextField(Minecraft.getMinecraft().fontRenderer, 0, 0, 0, 0);
        this.field.setMaxStringLength(256);
        this.field.setCursorPositionZero();
    }

    public TextField(String ident) {
        this.identifier = ident;
        this.initInternalTextField();
    }

    public int getTextColour() {
        return this.focused() ? -2039584 : -7303024;
    }

    protected void setDimensionsAndColor() {
        this.field.xPosition = this.x + 2;
        this.field.yPosition = this.y + 2;
        this.field.width = this.w - 4;
        this.field.height = this.h - 4;
        this.field.setTextColor(this.getTextColour());
    }

    @Override
    public void draw(int mousex, int mousey) {
        try {
            this.setDimensionsAndColor();
            this.field.drawTextBox();
        }
        catch (NullPointerException npe) {
            GuiTextField oldField = this.field;
            this.initInternalTextField();
            this.setDimensionsAndColor();
            this.field.setText(oldField.getText());
            this.field.drawTextBox();
        }
    }

    @Override
    public void onGuiClick(int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            this.setFocus(false);
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        this.setFocus(true);
        if (button == 1) {
            this.setText("");
        } else {
            this.field.mouseClicked(mousex, mousey, button);
        }
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (!this.focused()) {
            return false;
        }
        String oldText = this.text();
        boolean handled = this.field.textboxKeyTyped(keyChar, keyID);
        if (!(handled || keyID != 28 && keyID != 156 && keyID != 1)) {
            this.setFocus(false);
            handled = true;
        }
        if (handled) {
            this.onTextChange(oldText);
        }
        return handled;
    }

    public abstract void onTextChange(String var1);

    @Override
    public void update() {
    }

    public void setText(String s) {
        String oldText = this.text();
        this.field.setText(s);
        this.field.setCursorPositionZero();
        this.onTextChange(oldText);
    }

    public String filterText(String s) {
        return s;
    }

    public void setFocus(boolean focus) {
        boolean previousFocus = this.field.isFocused();
        this.field.setFocused(focus);
        if (previousFocus != focus) {
            if (focus) {
                this.previousKeyboardRepeatEnabled = Keyboard.areRepeatEventsEnabled();
                Keyboard.enableRepeatEvents((boolean)true);
                this.gainFocus();
            } else {
                Keyboard.enableRepeatEvents((boolean)this.previousKeyboardRepeatEnabled);
                this.loseFocus();
            }
        }
    }

    public boolean focused() {
        return this.field.isFocused();
    }

    public String text() {
        return this.field.getText();
    }
}

