/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.core.gui.GuiScrollPane;
import java.awt.Dimension;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public abstract class OptionScrollPane
extends GuiScrollPane {
    public OptionScrollPane() {
        super(0, 0, 0, 0);
        this.setMargins(24, 4, 20, 4);
    }

    public void drawBackground(float frame) {
        Rectangle sbar = this.scrollbarBounds();
        OptionScrollPane.drawRect((int)sbar.x, (int)this.y, (int)(sbar.x + sbar.width), (int)(this.y + this.height), (int)-16777216);
    }

    public void drawOverlay(float frame) {
        OptionScrollPane.drawOverlay(this.y, this.height, this.parentScreen.width, this.zLevel);
    }

    public Dimension scrollbarDim() {
        Dimension dim = super.scrollbarDim();
        dim.width = 6;
        return dim;
    }

    public int scrollbarGuideAlignment() {
        return 0;
    }

    public void resize() {
        int width = Math.min(this.parentScreen.width - 80, 320);
        this.setSize((this.parentScreen.width - width) / 2, 20, width, this.parentScreen.height - 50);
    }

    public void mouseScrolled(int x, int y, int scroll) {
        this.scroll(-scroll);
    }

    public static void drawOverlay(int y, int height, int screenwidth, float zLevel) {
        OptionScrollPane.drawOverlayTex(0, 0, screenwidth, y, zLevel);
        OptionScrollPane.drawOverlayTex(0, y + height, screenwidth, screenwidth - y - height, zLevel);
        OptionScrollPane.drawOverlayGrad(0, screenwidth, y, y + 4, zLevel);
        OptionScrollPane.drawOverlayGrad(0, screenwidth, y + height, y + height - 4, zLevel);
    }

    public static void drawOverlayTex(int x, int y, int w, int h, float zLevel) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.getMinecraft().renderEngine.bindTexture(Gui.optionsBackground);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        t.addVertexWithUV((double)x, (double)(y + h), (double)zLevel, 0.0, (double)h / 16.0);
        t.addVertexWithUV((double)(x + w), (double)(y + h), (double)zLevel, (double)w / 16.0, (double)h / 16.0);
        t.addVertexWithUV((double)(x + w), (double)y, (double)zLevel, (double)w / 16.0, 0.0);
        t.draw();
    }

    public static void drawOverlayGrad(int x1, int x2, int y1, int y2, float zLevel) {
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.setColorRGBA_I(0, 255);
        t.addVertex((double)x2, (double)y1, (double)zLevel);
        t.addVertex((double)x1, (double)y1, (double)zLevel);
        t.setColorRGBA_I(0, 0);
        t.addVertex((double)x1, (double)y2, (double)zLevel);
        t.addVertex((double)x2, (double)y2, (double)zLevel);
        t.draw();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
    }
}

