/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.InventoryCraftingDummy;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeFireworks;

public class FireworkRecipeHandler
extends ShapelessRecipeHandler {
    private final InventoryCrafting inventoryCrafting = new InventoryCraftingDummy();
    private final RecipeFireworks recipeFireworks = new RecipeFireworks();
    public final ArrayList<CachedFireworkRecipe> mfireworks = new ArrayList();

    public FireworkRecipeHandler() {
        this.stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
        this.loadAllFireworks();
    }

    private void loadAllFireworks() {
        Item[] shapes = new Item[]{null, Items.fire_charge, Items.gold_nugget, Items.feather, Items.skull};
        Item[] effects = new Item[]{null, Items.diamond, Items.glowstone_dust};
        for (Item shape : shapes) {
            for (Item effect : effects) {
                this.genRecipe(Items.gunpowder, shape, effect, Items.dye, Items.dye, 0);
            }
        }
        this.genRecipe(Items.gunpowder, Items.paper, Items.firework_charge, 2);
        this.genRecipe(Items.gunpowder, Items.gunpowder, Items.paper, Items.firework_charge, 2);
        this.genRecipe(Items.gunpowder, Items.gunpowder, Items.gunpowder, Items.paper, Items.firework_charge, 2);
        for (int i = 0; i < 9; ++i) {
            this.inventoryCrafting.setInventorySlotContents(i, null);
        }
        this.inventoryCrafting.setInventorySlotContents(0, new ItemStack(Items.gunpowder));
        this.inventoryCrafting.setInventorySlotContents(1, new ItemStack(Items.dye));
        this.recipeFireworks.matches(this.inventoryCrafting, null);
        ItemStack charge = this.recipeFireworks.getCraftingResult(null);
        this.genRecipe(charge, Items.dye, Items.dye, 1);
    }

    private void genRecipe(Object ... params) {
        int i;
        int numIngreds = 0;
        for (i = 0; i < params.length - 2; ++i) {
            if (params[i] == null) continue;
            ++numIngreds;
        }
        for (i = 0; i < params.length - 1; ++i) {
            if (!(params[i] instanceof Item)) continue;
            params[i] = new ItemStack((Item)params[i], 1, Short.MAX_VALUE);
        }
        Object[] ingreds = new Object[numIngreds];
        int j = 0;
        for (int i2 = 0; i2 < params.length - 2; ++i2) {
            if (params[i2] == null) continue;
            ingreds[j++] = params[i2];
        }
        this.mfireworks.add(new CachedFireworkRecipe(ingreds, params[params.length - 2], (Integer)params[params.length - 1]));
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (CachedFireworkRecipe recipe : this.mfireworks) {
            if (recipe.result.item.getItem() != result.getItem()) continue;
            recipe.cycle();
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && this.getClass() == FireworkRecipeHandler.class) {
            this.arecipes.addAll(this.mfireworks);
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (CachedFireworkRecipe recipe : this.mfireworks) {
            if (!recipe.contains((Collection<PositionedStack>)recipe.ingredients, ingredient)) continue;
            recipe.cycle();
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void onUpdate() {
        if (!NEIClientUtils.shiftKey()) {
            ++this.cycleticks;
            if (this.cycleticks % 20 == 0) {
                for (TemplateRecipeHandler.CachedRecipe crecipe : this.arecipes) {
                    ((CachedFireworkRecipe)crecipe).cycle();
                }
            }
        }
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.firework", new Object[0]);
    }

    @Override
    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipe) {
        currenttip = super.handleTooltip(gui, currenttip, recipe);
        Point mousepos = GuiDraw.getMousePosition();
        Point relMouse = new Point(mousepos.x - gui.guiLeft, mousepos.y - gui.guiTop);
        Point recipepos = gui.getRecipePosition(recipe);
        if (currenttip.isEmpty() && GuiContainerManager.getStackMouseOver(gui) == null && new Rectangle(recipepos.x, recipepos.y, 166, 55).contains(relMouse)) {
            currenttip.add(NEIClientUtils.translate("recipe.firework.tooltip" + ((CachedFireworkRecipe)this.arecipes.get((int)recipe)).recipeType, new Object[0]));
        }
        return currenttip;
    }

    public class CachedFireworkRecipe
    extends ShapelessRecipeHandler.CachedShapelessRecipe {
        final LinkedList<Object> itemList;
        public final Object[] baseIngredients;
        public final Object extraIngred;
        public final int recipeType;

        public CachedFireworkRecipe(Object[] base, Object extra, int type) {
            super(new ItemStack(Items.fireworks));
            this.itemList = new LinkedList();
            this.baseIngredients = base;
            this.extraIngred = extra;
            this.recipeType = type;
            this.cycle();
        }

        public void cycle() {
            this.itemList.clear();
            this.itemList.addAll(Arrays.asList(this.baseIngredients));
            int extras = FireworkRecipeHandler.this.cycleticks / 40 % (10 - this.itemList.size());
            for (int i = 0; i < extras; ++i) {
                this.itemList.add(this.extraIngred);
            }
            this.setIngredients(this.itemList);
            List<PositionedStack> ingreds = this.getIngredients();
            for (int i = 0; i < 9; ++i) {
                FireworkRecipeHandler.this.inventoryCrafting.setInventorySlotContents(i, i < ingreds.size() ? ingreds.get((int)i).item : null);
            }
            if (!FireworkRecipeHandler.this.recipeFireworks.matches(FireworkRecipeHandler.this.inventoryCrafting, null)) {
                throw new RuntimeException("Invalid Recipe?");
            }
            this.setResult(FireworkRecipeHandler.this.recipeFireworks.getCraftingResult(null));
        }
    }
}

