/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.Button;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.GuiRecipeTabCreative;
import codechicken.nei.recipe.GuiRecipeTabJEI;
import codechicken.nei.recipe.IRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class GuiRecipeTabs {
    private final List<GuiRecipeTab> tabs = new ArrayList<GuiRecipeTab>();
    private final List<Button> buttons = new ArrayList<Button>();
    private final Rectangle area = new Rectangle();
    private List<? extends IRecipeHandler> currenthandlers;
    private int pageCount = 1;
    private int pageNumber = 0;
    private int categoriesPerPage = 1;
    private int numHandlers = 1;
    private int recipetype;
    private final Button prevTab = new Button("<"){

        @Override
        public boolean onButtonPress(boolean rightClick) {
            if (!rightClick) {
                NEIClientUtils.playClickSound();
                return GuiRecipeTabs.this.previousPage();
            }
            return false;
        }
    };
    private final Button nextTab = new Button(">"){

        @Override
        public boolean onButtonPress(boolean rightclick) {
            if (!rightclick) {
                NEIClientUtils.playClickSound();
                return GuiRecipeTabs.this.nextPage();
            }
            return false;
        }
    };

    public static int getTabWidth() {
        return NEIClientConfig.useCreativeTabStyle() ? 28 : 24;
    }

    public static int getTabHeight() {
        return NEIClientConfig.useCreativeTabStyle() ? 31 : 24;
    }

    public void update(GuiRecipe<?> guiRecipe) {
        int tabWidth = GuiRecipeTabs.getTabWidth();
        int tabHeight = GuiRecipeTabs.getTabHeight();
        this.recipetype = guiRecipe.recipetype;
        this.currenthandlers = guiRecipe.currenthandlers;
        this.numHandlers = this.currenthandlers.size();
        this.categoriesPerPage = (guiRecipe.xSize - 4) / tabWidth;
        this.pageNumber = this.recipetype / Math.max(this.categoriesPerPage, 1);
        this.pageCount = (int)Math.ceil((float)this.numHandlers / (float)this.categoriesPerPage);
        this.area.width = this.categoriesPerPage * tabWidth;
        this.area.height = tabHeight;
        this.area.x = guiRecipe.guiLeft + 4;
        this.area.y = guiRecipe.guiTop - tabHeight + 3;
        this.refreshPage();
        this.updateArrows(tabHeight);
    }

    public void refreshPage() {
        int startIndex = this.pageNumber * this.categoriesPerPage;
        int tabWidth = GuiRecipeTabs.getTabWidth();
        this.tabs.clear();
        for (int i = 0; i < this.categoriesPerPage && i + startIndex < this.numHandlers; ++i) {
            final int index = i + startIndex;
            IRecipeHandler handler = this.currenthandlers.get(index);
            int tabX = this.area.x + i * tabWidth;
            if (NEIClientConfig.useCreativeTabStyle()) {
                this.tabs.add(new GuiRecipeTabCreative(handler, tabX, this.area.y){

                    @Override
                    public boolean onButtonPress(boolean rightclick) {
                        GuiRecipeTabs.this.setRecipePage(index);
                        return true;
                    }
                });
                continue;
            }
            this.tabs.add(new GuiRecipeTabJEI(handler, tabX, this.area.y){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    GuiRecipeTabs.this.setRecipePage(index);
                    return true;
                }
            });
        }
    }

    private void updateArrows(int tabHeight) {
        this.buttons.clear();
        if (this.numHandlers > this.categoriesPerPage) {
            this.nextTab.w = 8;
            this.prevTab.w = 8;
            this.prevTab.h = this.nextTab.h = tabHeight - 4;
            this.prevTab.y = this.nextTab.y = this.area.y + 2;
            this.prevTab.x = this.area.x - this.prevTab.w + 1;
            this.nextTab.x = this.area.x + this.area.width - 1;
            this.buttons.add(this.prevTab);
            this.buttons.add(this.nextTab);
        }
    }

    protected void setRecipePage(int recipetype) {
    }

    public boolean nextPage() {
        this.pageNumber = (this.pageNumber + 1) % this.pageCount;
        this.refreshPage();
        return true;
    }

    public boolean previousPage() {
        this.pageNumber = (this.pageCount + this.pageNumber - 1) % this.pageCount;
        this.refreshPage();
        return true;
    }

    public void draw(int mouseX, int mouseY) {
        int indexShift = this.pageNumber * this.categoriesPerPage;
        for (int index = 0; index < this.tabs.size(); ++index) {
            GuiRecipeTab tab = this.tabs.get(index);
            tab.setSelected(indexShift + index == this.recipetype);
            tab.draw(mouseX, mouseY);
        }
        for (Button button : this.buttons) {
            button.draw(mouseX, mouseY);
        }
    }

    public void handleTooltip(int mousex, int mousey, List<String> tooltips) {
        if (!NEIClientConfig.areJEIStyleTabsVisible()) {
            return;
        }
        for (GuiRecipeTab tab : this.tabs) {
            if (!tab.contains(mousex, mousey)) continue;
            tab.addTooltips(tooltips);
        }
        for (Button button : this.buttons) {
            if (!button.contains(mousex, mousey)) continue;
            button.addTooltips(tooltips);
        }
    }

    protected boolean mouseClicked(int x, int y, int mouseButton) {
        if (!NEIClientConfig.areJEIStyleTabsVisible()) {
            return false;
        }
        for (Button button : this.buttons) {
            if (!button.contains(x, y)) continue;
            return button.onButtonPress(mouseButton == 1);
        }
        for (GuiRecipeTab tab : this.tabs) {
            if (!tab.contains(x, y)) continue;
            return tab.onButtonPress(mouseButton == 1);
        }
        return false;
    }

    protected boolean mouseScrolled(int scroll) {
        if (NEIClientConfig.areJEIStyleTabsVisible() && this.area.contains(GuiDraw.getMousePosition())) {
            this.setRecipePage(this.recipetype - scroll);
            return true;
        }
        return false;
    }
}

