/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ClientHandler;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.recipe.TemplateRecipeHandler;
import codechicken.nei.util.ItemStackFilterParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class InformationHandler
extends TemplateRecipeHandler {
    private static final List<InformationPage> ITEM_INFO = new ArrayList<InformationPage>();

    public static void addInformationPage(String filter, String description) {
        if (filter.isEmpty() || description.isEmpty()) {
            return;
        }
        ITEM_INFO.add(new InformationPage(filter, description));
    }

    public static void populateStacks(ItemStack stack) {
        for (InformationPage page : ITEM_INFO) {
            page.addItem(stack);
        }
    }

    @Override
    public void drawExtras(int recipe) {
        CachedInfoPage page = (CachedInfoPage)this.arecipes.get(recipe);
        this.drawWrappedText(page.getLines(), 4, 24);
    }

    private void drawWrappedText(List<String> lines, int x, int y) {
        FontRenderer font = Minecraft.getMinecraft().fontRenderer;
        for (String line : lines) {
            font.drawString(line, x, y, 0);
            y += 10;
        }
    }

    public static void clearCache() {
        for (InformationPage page : ITEM_INFO) {
            page.items.clear();
        }
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.information", new Object[0]);
    }

    @Override
    public String getOverlayIdentifier() {
        return "information";
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (InformationPage page : ITEM_INFO) {
            if (!page.filter.matches(result)) continue;
            this.arecipes.add(new CachedInfoPage(page));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        this.loadCraftingRecipes(ingredient);
    }

    @Override
    public String getGuiTexture() {
        return "nei:textures/gui/recipebg.png";
    }

    @Override
    public int getRecipeHeight(int recipe) {
        CachedInfoPage page = (CachedInfoPage)this.arecipes.get(recipe);
        return 24 + page.getLines().size() * 10;
    }

    public static void load() {
        ClientHandler.loadSettingsFile("informationpages.cfg", lines -> InformationHandler.parseFile(lines.collect(Collectors.toCollection(ArrayList::new))));
    }

    private static void parseFile(List<String> lines) {
        for (String rawLine : lines) {
            String line = rawLine.trim();
            int sepIndex = line.indexOf(61);
            if (sepIndex == -1) {
                NEIClientConfig.logger.warn("[NEI Info] Invalid line (no '=') in config: {}", new Object[]{line});
                continue;
            }
            String filter = line.substring(0, sepIndex).trim();
            String description = line.substring(sepIndex + 1).trim();
            InformationHandler.addInformationPage(filter, description);
        }
    }

    private static class InformationPage {
        final List<ItemStack> items = new ArrayList<ItemStack>();
        final String info;
        final ItemFilter filter;

        public InformationPage(String filter, String info) {
            this.filter = ItemStackFilterParser.parse(filter.trim());
            this.info = info;
        }

        public void addItem(ItemStack stack) {
            if (this.filter.matches(stack)) {
                this.items.add(stack);
            }
        }
    }

    private class CachedInfoPage
    extends TemplateRecipeHandler.CachedRecipe {
        private final PositionedStack stack;
        private final List<String> lines;

        public CachedInfoPage(InformationPage page) {
            super(InformationHandler.this);
            FontRenderer font = Minecraft.getMinecraft().fontRenderer;
            String info = StatCollector.translateToLocal((String)page.info).replace("\\n", "\n");
            this.lines = font.listFormattedStringToWidth(info, 156);
            this.stack = new PositionedStack(page.items, 75, 2);
        }

        @Override
        public PositionedStack getResult() {
            return null;
        }

        @Override
        public List<PositionedStack> getIngredients() {
            return Collections.singletonList(this.stack);
        }

        public List<String> getLines() {
            return this.lines;
        }
    }
}

