/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.search;

import codechicken.nei.ItemStackMap;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.api.ItemFilter;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class TooltipFilter
implements ItemFilter {
    private static final ItemStackMap<String> itemSearchNames = new ItemStackMap();
    private final Pattern pattern;

    public TooltipFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean matches(ItemStack itemStack) {
        return this.pattern.matcher(TooltipFilter.getSearchTooltip(itemStack)).find();
    }

    public static void clearCache() {
        itemSearchNames.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putItem(ItemStack stack) {
        String tooltip = TooltipFilter.getTooltip(stack.copy());
        ItemStackMap<String> itemStackMap = itemSearchNames;
        synchronized (itemStackMap) {
            itemSearchNames.put(stack, tooltip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSearchTooltip(ItemStack stack) {
        String tooltip = itemSearchNames.get(stack);
        if (tooltip == null) {
            tooltip = TooltipFilter.getTooltip(stack.copy());
            ItemStackMap<String> itemStackMap = itemSearchNames;
            synchronized (itemStackMap) {
                itemSearchNames.put(stack, tooltip);
            }
        }
        return tooltip;
    }

    private static String getTooltip(ItemStack itemstack) {
        try {
            List namelist = itemstack.getTooltip((EntityPlayer)NEIClientUtils.mc().thePlayer, false);
            if (namelist.size() > 1) {
                return EnumChatFormatting.getTextWithoutFormattingCodes((String)String.join((CharSequence)"\n", namelist.subList(1, namelist.size())));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }
}

