/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.util;

import codechicken.nei.ClientHandler;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SubsetWidget;
import codechicken.nei.api.API;
import codechicken.nei.recipe.StackInfo;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringTranslate;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemUntranslator {
    private static final String CONFIG_FILE = "untranslator.cfg";
    private static final ItemUntranslator instance = new ItemUntranslator();
    private final Map<String, String> secondNames = new HashMap<String, String>();
    private final Map<String, String> processedNames = new HashMap<String, String>();

    private ItemUntranslator() {
    }

    public static ItemUntranslator getInstance() {
        return instance;
    }

    public void generateUntranslatedNames() {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("language", FMLCommonHandler.instance().getCurrentLanguage());
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            items.put(fluid.getUnlocalizedName().toLowerCase(), this.stripFormatting(StatCollector.translateToLocal((String)fluid.getUnlocalizedName())));
        }
        for (CreativeTabs tab : CreativeTabs.creativeTabArray) {
            ArrayList tabItems = new ArrayList();
            tab.displayAllReleventItems(tabItems);
            for (ItemStack stack : tabItems) {
                this.collectDisplayNameForStack(stack, items);
            }
        }
        for (ItemStack itemStack : ItemList.items) {
            this.collectDisplayNameForStack(itemStack, items);
        }
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (data.filledContainer == null) continue;
            this.collectDisplayNameForStack(data.filledContainer, items);
        }
        for (Map.Entry entry : LanguageRegistryPatch.languageListCache.entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase();
            if (!key.endsWith(".name") || items.containsKey(key) || ((String)entry.getValue()).contains("%")) continue;
            items.put(key, (String)entry.getValue());
        }
        this.saveMappings(items);
    }

    private void collectDisplayNameForStack(ItemStack stack, Map<String, String> items) {
        String displayName = this.stripFormatting(stack.getDisplayName());
        String guidKey = this.determineGUIDForGeneration(stack, displayName, items);
        if (!items.containsKey(guidKey)) {
            items.put(guidKey, displayName);
        }
    }

    private String determineGUIDForGeneration(ItemStack stack, String displayName, Map<String, String> items) {
        String unlocalizedName = stack.getUnlocalizedName().toLowerCase();
        if (displayName.equals(this.stripFormatting(StatCollector.translateToLocal((String)unlocalizedName)))) {
            return unlocalizedName;
        }
        if (!unlocalizedName.endsWith(".name") && displayName.equals(this.stripFormatting(StatCollector.translateToLocal((String)(unlocalizedName + ".name"))))) {
            return unlocalizedName + ".name";
        }
        FluidStack fluid = StackInfo.getFluid(stack);
        if (fluid != null) {
            String fluidUnlocalizedName = fluid.getUnlocalizedName().toLowerCase();
            if (displayName.equals(items.get(fluidUnlocalizedName))) {
                return fluidUnlocalizedName;
            }
            if (!fluidUnlocalizedName.startsWith("fluid.") && displayName.equals(items.get("fluid." + fluidUnlocalizedName))) {
                return "fluid." + fluidUnlocalizedName;
            }
            return (Item.itemRegistry.getNameForObject((Object)stack.getItem()) + ":" + stack.getItemDamage() + "@" + fluid.getUnlocalizedName()).toLowerCase();
        }
        if (stack.hasTagCompound()) {
            try {
                ItemStack stackCopy = new ItemStack(stack.getItem(), 1, stack.getItemDamage());
                if (displayName.equals(this.stripFormatting(stackCopy.getDisplayName()))) {
                    return (Item.itemRegistry.getNameForObject((Object)stack.getItem()) + ":" + stack.getItemDamage()).toLowerCase();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StackInfo.getItemStackGUID(stack);
    }

    private String stripFormatting(String name) {
        return EnumChatFormatting.getTextWithoutFormattingCodes((String)name).trim();
    }

    public synchronized String getItemStackDisplayName(ItemStack stack) {
        if (stack == null || this.secondNames.isEmpty()) {
            return "";
        }
        String guidKey = StackInfo.getItemStackGUID(stack);
        return this.processedNames.computeIfAbsent(guidKey, stackKey -> {
            String displayName = this.secondNames.get(stackKey);
            if (displayName == null) {
                String guid = this.findBestGUIDForLookup(stack);
                displayName = this.secondNames.computeIfAbsent(guid == null ? stackKey : guid, g -> this.getFallbackDisplayName(stack));
            }
            return displayName.equals(this.stripFormatting(stack.getDisplayName())) ? "" : displayName;
        });
    }

    public String findBestGUIDForLookup(ItemStack stack) {
        String unlocalizedName;
        String guidKey = (Item.itemRegistry.getNameForObject((Object)stack.getItem()) + ":" + stack.getItemDamage()).toLowerCase();
        if (this.secondNames.containsKey(guidKey)) {
            return guidKey;
        }
        FluidStack fluid = StackInfo.getFluid(stack);
        if (fluid != null) {
            guidKey = (Item.itemRegistry.getNameForObject((Object)stack.getItem()) + ":" + stack.getItemDamage() + "@" + fluid.getUnlocalizedName()).toLowerCase();
            if (this.secondNames.containsKey(guidKey)) {
                return guidKey;
            }
            String fluidUnlocalizedName = fluid.getUnlocalizedName().toLowerCase();
            if (!fluidUnlocalizedName.startsWith("fluid.") && this.secondNames.containsKey("fluid." + fluidUnlocalizedName)) {
                return "fluid." + fluidUnlocalizedName;
            }
            if (this.secondNames.containsKey(fluidUnlocalizedName)) {
                return fluidUnlocalizedName;
            }
        }
        if (!(unlocalizedName = stack.getUnlocalizedName().toLowerCase()).endsWith(".name") && this.secondNames.containsKey(unlocalizedName + ".name")) {
            return unlocalizedName + ".name";
        }
        if (this.secondNames.containsKey(unlocalizedName)) {
            return unlocalizedName;
        }
        return null;
    }

    private String getFallbackDisplayName(ItemStack stack) {
        FluidStack fluid;
        String unlocalizedName = stack.getUnlocalizedName();
        String secondLanguage = this.secondNames.get("language");
        String name = LanguageRegistry.instance().getStringLocalization(unlocalizedName, secondLanguage);
        if (name == null && !unlocalizedName.endsWith(".name")) {
            name = LanguageRegistry.instance().getStringLocalization(unlocalizedName + ".name", secondLanguage);
        }
        if (name == null || name.contains("%")) {
            try (LanguageRegistryPatch lrPatch = new LanguageRegistryPatch(secondLanguage);){
                name = stack.getDisplayName();
            }
        }
        if ((fluid = StackInfo.getFluid(stack)) != null) {
            String unlocalizedFluidName = fluid.getUnlocalizedName().toLowerCase();
            String fluidName = this.secondNames.get(unlocalizedFluidName);
            if (fluidName == null && !unlocalizedFluidName.startsWith("fluid.")) {
                fluidName = this.secondNames.get("fluid." + unlocalizedFluidName);
            }
            if (fluidName != null && name != null && !name.isEmpty()) {
                return name.replace(fluid.getLocalizedName(), fluidName);
            }
            name = fluidName;
        }
        return name == null ? "" : name;
    }

    protected void saveMappings(Map<String, String> items) {
        try (BufferedWriter writer = Files.newBufferedWriter(new File(NEIClientConfig.configDir, CONFIG_FILE).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (Map.Entry<String, String> entry : items.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                writer.write(entry.getKey() + "=" + entry.getValue());
                writer.newLine();
            }
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error saving untranslator", (Throwable)e);
        }
        NEIClientConfig.logger.info("Untranslator saved");
    }

    public void unload() {
        this.secondNames.clear();
        LanguageRegistryPatch.secondLanguageListCache = null;
        this.processedNames.clear();
    }

    public void load() {
        this.unload();
        this.secondNames.clear();
        if (ClientHandler.loadSettingsFile(CONFIG_FILE, null, this::parseStream) || ClientHandler.loadSettingsResource(CONFIG_FILE, this::parseStream)) {
            NEIClientConfig.logger.info("Untranslator loaded");
        }
        if (!this.secondNames.containsKey("language") || FMLCommonHandler.instance().getCurrentLanguage().equals(this.secondNames.get("language"))) {
            this.secondNames.clear();
        }
        SubsetWidget.updateHiddenItems();
    }

    private void parseStream(Stream<String> lines) {
        lines.forEach(line -> {
            int sepIndex = line.indexOf(61);
            if (sepIndex != -1) {
                this.secondNames.put(line.substring(0, sepIndex).trim(), line.substring(sepIndex + 1).trim());
            }
        });
    }

    static {
        API.addSubset("Untranslated", item -> instance.getItemStackDisplayName(item).isEmpty());
    }

    private class LanguageRegistryPatch
    implements AutoCloseable {
        private String secondLanguage = "en_US";
        private String language = FMLCommonHandler.instance().getCurrentLanguage();
        private static Map<String, Properties> modLanguageDataSymlink;
        private Properties languageDataCache;
        private static Map<String, String> secondLanguageListCache;
        private static Map<String, String> languageListCache;
        private static Field languageListField;
        private static Field fieldStringTranslateInstance;

        private LanguageRegistryPatch(String secondLanguage) {
            this.secondLanguage = secondLanguage;
            this.patchLanguageRegistry();
            this.patchStringTranslate();
        }

        @Override
        public void close() {
            this.restoreStringTranslate();
            this.restoreLanguageRegistry();
        }

        private void patchLanguageRegistry() {
            this.languageDataCache = modLanguageDataSymlink.get(this.language);
            modLanguageDataSymlink.put(this.language, modLanguageDataSymlink.get(this.secondLanguage));
        }

        private void patchStringTranslate() {
            if (languageListField != null) {
                if (secondLanguageListCache == null) {
                    secondLanguageListCache = new HashMap<String, String>(languageListCache);
                    modLanguageDataSymlink.get(this.secondLanguage).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> secondLanguageListCache.put((String)k, (String)v)));
                }
                try {
                    languageListField.set(fieldStringTranslateInstance.get(null), secondLanguageListCache);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to access StringTranslate language list", e);
                }
            }
        }

        private void restoreLanguageRegistry() {
            String language = FMLCommonHandler.instance().getCurrentLanguage();
            modLanguageDataSymlink.put(language, this.languageDataCache);
            this.languageDataCache = null;
        }

        private void restoreStringTranslate() {
            if (languageListField != null && languageListCache != null) {
                try {
                    languageListField.set(fieldStringTranslateInstance.get(null), languageListCache);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to restore StringTranslate language list", e);
                }
            }
        }

        static {
            try {
                Field modLanguageDataField = ReflectionHelper.findField(LanguageRegistry.class, (String[])new String[]{"modLanguageData"});
                languageListField = ReflectionHelper.findField(StringTranslate.class, (String[])new String[]{"languageList", "field_74816_c"});
                fieldStringTranslateInstance = ReflectionHelper.findField(StringTranslate.class, (String[])new String[]{"instance", "field_74817_a"});
                modLanguageDataSymlink = (Map)modLanguageDataField.get(LanguageRegistry.instance());
                languageListCache = (Map)languageListField.get(fieldStringTranslateInstance.get(null));
            }
            catch (Throwable e) {
                languageListField = null;
                fieldStringTranslateInstance = null;
            }
        }
    }
}

