/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;

public class AutoFocusWidget
implements IContainerInputHandler {
    public static AutoFocusWidget instance = new AutoFocusWidget();
    public static List<String> enableAutoFocusPrefixes = new ArrayList<String>();
    protected boolean autofocus = false;
    protected Point mouse;

    public AutoFocusWidget() {
        GuiContainerManager.addInputHandler(this);
    }

    public void load(GuiContainer gui) {
        this.autofocus = LayoutManager.searchField.isVisible() && NEIClientConfig.searchWidgetAutofocus() != 0 && this.isAllowedGuiAutoSearchFocus(gui);
        this.mouse = GuiDraw.getMousePosition();
    }

    @Override
    public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
        if (this.autofocus) {
            this.autofocus = false;
            if (!this.mouse.equals(GuiDraw.getMousePosition())) {
                return false;
            }
            if (NEIClientConfig.searchWidgetAutofocus() == 2 && GameSettings.isKeyDown((KeyBinding)Minecraft.getMinecraft().gameSettings.keyBindInventory)) {
                return false;
            }
            if (keyCode == 28 || keyCode == 156 || keyCode == 1) {
                return false;
            }
            LayoutManager.searchField.setFocus(true);
            LayoutManager.searchField.handleKeyPress(keyCode, keyChar);
            return true;
        }
        return false;
    }

    @Override
    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        return false;
    }

    @Override
    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        this.autofocus = false;
        return false;
    }

    @Override
    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        this.autofocus = false;
        return false;
    }

    @Override
    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    @Override
    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        this.autofocus = false;
    }

    @Override
    public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        this.autofocus = false;
    }

    @Override
    public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        this.autofocus = false;
    }

    @Override
    public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        this.autofocus = false;
    }

    protected boolean isAllowedGuiAutoSearchFocus(GuiContainer gui) {
        if (gui instanceof INEIAutoFocusSearchEnable) {
            return true;
        }
        String guiClassName = gui.getClass().getName();
        for (String prefix : enableAutoFocusPrefixes) {
            if (!guiClassName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static interface INEIAutoFocusSearchEnable {
    }
}

