/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class FormattedTextField
extends GuiTextField {
    protected FontRenderer fontRenderer;
    protected String rawText = "";
    protected String formattedText = "";
    protected String placeholder = "";
    protected boolean editable = true;
    protected int editableColor = 0xE0E0E0;
    protected int notEditableColor = 0x707070;
    protected TextFormatter formatter = TextFormatter.DEFAULT;
    protected int lineScrollOffset = 0;
    protected int frame = 0;

    public FormattedTextField(FontRenderer fontRenderer, int xPosition, int yPosition, int width, int height) {
        super(fontRenderer, xPosition, yPosition, width, height);
        this.fontRenderer = fontRenderer;
    }

    public void setFormatter(TextFormatter formatter) {
        this.formatter = formatter;
    }

    public TextFormatter getFormatter() {
        return this.formatter;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void updateCursorCounter() {
        super.updateCursorCounter();
        ++this.frame;
    }

    public void setFocused(boolean focus) {
        if (focus && !this.isFocused()) {
            this.frame = 0;
        }
        super.setFocused(focus);
    }

    public void setSelectionPos(int p_146199_1_) {
        String text = this.getText();
        int j = text.length();
        super.setSelectionPos(p_146199_1_);
        p_146199_1_ = Math.max(0, Math.min(p_146199_1_, j));
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > j) {
                this.lineScrollOffset = j;
            }
            int k = this.getWidth();
            String s = this.fontRenderer.trimStringToWidth(text.substring(this.lineScrollOffset), k);
            int l = s.length() + this.lineScrollOffset;
            if (p_146199_1_ == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.trimStringToWidth(text, k, true).length();
            }
            if (p_146199_1_ > l) {
                this.lineScrollOffset += p_146199_1_ - l;
            } else if (p_146199_1_ <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - p_146199_1_;
            }
            this.lineScrollOffset = Math.max(0, Math.min(this.lineScrollOffset, j));
        }
    }

    public void setTextColor(int p_146193_1_) {
        super.setTextColor(p_146193_1_);
        this.editableColor = p_146193_1_;
    }

    public void setDisabledTextColour(int p_146204_1_) {
        super.setDisabledTextColour(p_146204_1_);
        this.notEditableColor = p_146204_1_;
    }

    public void setEnabled(boolean p_146184_1_) {
        super.setEnabled(p_146184_1_);
        this.editable = p_146184_1_;
    }

    protected boolean beforeWrite(String text) {
        return true;
    }

    public void writeText(String textPart) {
        String newText = "";
        String substr = ChatAllowedCharacters.filerAllowedCharacters((String)textPart);
        int cursorPosition = this.getCursorPosition();
        int maxStringLength = this.getMaxStringLength();
        String text = this.getText();
        if (text.isEmpty()) {
            newText = substr.substring(0, Math.min(maxStringLength, substr.length()));
            cursorPosition = newText.length();
        } else {
            int selectionEnd = this.getSelectionEnd();
            String textStart = text.substring(0, Math.min(cursorPosition, selectionEnd));
            String textEnd = text.substring(Math.max(cursorPosition, selectionEnd));
            newText = textStart + substr + textEnd;
            if (newText.length() > maxStringLength) {
                newText = newText.substring(0, maxStringLength);
            }
            cursorPosition = Math.min(textStart.length() + substr.length(), newText.length());
        }
        if (this.beforeWrite(newText)) {
            this.setText(newText);
            this.setCursorPosition(cursorPosition);
        }
    }

    public int getNthWordFromPos(int p_146183_1_, int p_146183_2_) {
        return this.func_146197_a(p_146183_1_, p_146183_2_, true);
    }

    public void drawTextBox() {
        if (!this.getVisible()) {
            return;
        }
        if (this.getEnableBackgroundDrawing()) {
            FormattedTextField.drawRect((int)(this.xPosition - 1), (int)(this.yPosition - 1), (int)(this.xPosition + this.width + 1), (int)(this.yPosition + this.height + 1), (int)-6250336);
            FormattedTextField.drawRect((int)this.xPosition, (int)this.yPosition, (int)(this.xPosition + this.width), (int)(this.yPosition + this.height), (int)-16777216);
        }
        if (!this.rawText.equals(this.getText())) {
            this.rawText = this.getText();
            this.formattedText = this.formatter.format(this.rawText);
            if (!EnumChatFormatting.getTextWithoutFormattingCodes((String)this.formattedText).toLowerCase().equals(this.rawText.toLowerCase())) {
                this.formattedText = this.rawText;
            }
        }
        if (!this.isFocused() && this.formattedText.isEmpty()) {
            int x = this.getEnableBackgroundDrawing() ? this.xPosition + 4 : this.xPosition;
            int y = this.getEnableBackgroundDrawing() ? this.yPosition + (this.height - 8) / 2 : this.yPosition;
            this.fontRenderer.drawStringWithShadow(this.fontRenderer.trimStringToWidth(this.placeholder, this.getWidth()), x, y, this.notEditableColor);
            return;
        }
        int firstCharacterIndex = this.getFormattedTextShift(this.lineScrollOffset);
        String rawTextClipped = this.fontRenderer.trimStringToWidth(this.rawText.substring(this.lineScrollOffset), this.getWidth());
        String textClipped = this.formattedText.substring(firstCharacterIndex, this.getFormattedTextShift(this.lineScrollOffset + rawTextClipped.length()));
        int cursorPosition = this.getFormattedTextShift(this.getCursorPosition());
        int selectionEnd = this.getFormattedTextShift(this.getSelectionEnd());
        int color = this.editable ? this.editableColor : this.notEditableColor;
        int cursorA = cursorPosition - firstCharacterIndex;
        int cursorB = selectionEnd - firstCharacterIndex;
        boolean flag = cursorA >= 0 && cursorA <= textClipped.length();
        boolean flag1 = this.isFocused() && this.frame / 6 % 2 == 0 && flag;
        boolean flag2 = this.getCursorPosition() < this.rawText.length() || this.rawText.length() >= this.getMaxStringLength();
        int x = this.getEnableBackgroundDrawing() ? this.xPosition + 4 : this.xPosition;
        int y = this.getEnableBackgroundDrawing() ? this.yPosition + (this.height - 8) / 2 : this.yPosition;
        int x2 = x;
        if (cursorB > textClipped.length()) {
            cursorB = textClipped.length();
        }
        if (textClipped.length() > 0) {
            String s1 = flag ? textClipped.substring(0, cursorA) : textClipped;
            String colorA = this.getPreviousColor(firstCharacterIndex);
            x2 = this.fontRenderer.drawStringWithShadow(colorA + s1, x, y, color);
        }
        int k1 = x2;
        if (!flag) {
            k1 = cursorA > 0 ? x + this.width : x;
        } else if (flag2) {
            k1 = x2 - 1;
            --x2;
        }
        if (textClipped.length() > 0 && flag && cursorA < textClipped.length()) {
            String colorB = this.getPreviousColor(firstCharacterIndex + cursorA);
            this.fontRenderer.drawStringWithShadow(colorB + textClipped.substring(cursorA), x2, y, color);
        }
        if (flag1) {
            if (flag2) {
                Gui.drawRect((int)k1, (int)(y - 1), (int)(k1 + 1), (int)(y + 1 + this.fontRenderer.FONT_HEIGHT), (int)-3092272);
            } else {
                this.fontRenderer.drawStringWithShadow("_", k1, y, color);
            }
        }
        if (cursorB != cursorA) {
            int l1 = x + this.fontRenderer.getStringWidth(textClipped.substring(0, cursorB));
            this.drawCursorVertical(k1, y - 1, l1 - 1, y + 1 + this.fontRenderer.FONT_HEIGHT);
        }
    }

    private void drawCursorVertical(int x1, int y1, int x2, int y2) {
        int i1;
        if (x1 < x2) {
            i1 = x1;
            x1 = x2;
            x2 = i1;
        }
        if (y1 < y2) {
            i1 = y1;
            y1 = y2;
            y2 = i1;
        }
        if (x2 > this.xPosition + this.width) {
            x2 = this.xPosition + this.width;
        }
        if (x1 > this.xPosition + this.width) {
            x1 = this.xPosition + this.width;
        }
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.startDrawingQuads();
        tessellator.addVertex((double)x1, (double)y2, 0.0);
        tessellator.addVertex((double)x2, (double)y2, 0.0);
        tessellator.addVertex((double)x2, (double)y1, 0.0);
        tessellator.addVertex((double)x1, (double)y1, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }

    private int getFormattedTextShift(int position) {
        int shift = 0;
        for (int i = 0; i < position; ++i) {
            while (this.formattedText.length() > i + shift && this.formattedText.charAt(i + shift) == '\u00a7') {
                shift += 2;
            }
        }
        return position + shift;
    }

    private String getPreviousColor(int position) {
        while (position >= 0) {
            if (this.formattedText.charAt(position) == '\u00a7') {
                return this.formattedText.substring(position, position + 2);
            }
            --position;
        }
        return "";
    }

    public static interface TextFormatter {
        public static final TextFormatter DEFAULT = text -> text;

        public String format(String var1);
    }
}

