/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.Button;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.GuiRecipeTabCreative;
import codechicken.nei.recipe.GuiRecipeTabJEI;
import codechicken.nei.recipe.IRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class GuiRecipeTabs {
    private final GuiRecipe<?> guiRecipe;
    private final List<GuiRecipeTab> tabs = new ArrayList<GuiRecipeTab>();
    private final List<Button> buttons = new ArrayList<Button>();
    private final Rectangle area = new Rectangle();
    private int pageCount = 1;
    private int pageNumber = 0;
    private int categoriesPerPage = 1;
    private int numHandlers = 1;
    private int tabWidth;
    private int tabHeight;

    public GuiRecipeTabs(GuiRecipe<?> guiRecipe) {
        this.guiRecipe = guiRecipe;
    }

    public void initLayout() {
        if (NEIClientConfig.useCreativeTabStyle()) {
            this.tabWidth = 28;
            this.tabHeight = 31;
        } else {
            this.tabWidth = 24;
            this.tabHeight = 24;
        }
        int totalWidth = 0;
        this.categoriesPerPage = 0;
        this.numHandlers = this.guiRecipe.currenthandlers.size();
        for (int i = 0; i < this.numHandlers && totalWidth + this.tabWidth < this.guiRecipe.xSize - 4; ++i) {
            totalWidth += this.tabWidth;
            ++this.categoriesPerPage;
        }
        this.area.width = totalWidth;
        this.area.height = this.tabHeight;
        this.area.x = this.guiRecipe.guiLeft + 4;
        this.area.y = this.guiRecipe.guiTop - this.tabHeight + 3;
        this.pageCount = (int)Math.ceil((float)this.numHandlers / (float)this.categoriesPerPage);
        this.calcPageNumber();
        Rectangle navigationArea = new Rectangle(this.area);
        navigationArea.height = 20;
        navigationArea.translate(0, -(2 + navigationArea.height));
    }

    public void calcPageNumber() {
        this.pageNumber = this.guiRecipe.recipetype / Math.max(this.categoriesPerPage, 1);
    }

    public void refreshPage() {
        int index;
        this.tabs.clear();
        this.buttons.clear();
        int startIndex = this.pageNumber * this.categoriesPerPage;
        for (int i = 0; i < this.categoriesPerPage && (index = i + startIndex) < this.numHandlers; ++i) {
            IRecipeHandler handler = (IRecipeHandler)this.guiRecipe.currenthandlers.get(index);
            int tabX = this.area.x + i * this.tabWidth;
            if (NEIClientConfig.useCreativeTabStyle()) {
                this.tabs.add(new GuiRecipeTabCreative(this.guiRecipe, handler, tabX, this.area.y));
                continue;
            }
            this.tabs.add(new GuiRecipeTabJEI(this.guiRecipe, handler, tabX, this.area.y));
        }
        if (this.numHandlers > this.categoriesPerPage) {
            Button prevTab = new Button("prevTab"){

                @Override
                public boolean onButtonPress(boolean rightClick) {
                    if (!rightClick) {
                        NEIClientUtils.playClickSound();
                        return GuiRecipeTabs.this.previousPage();
                    }
                    return false;
                }

                @Override
                public String getRenderLabel() {
                    return "<";
                }
            };
            prevTab.w = 8;
            prevTab.h = this.tabHeight - 4;
            prevTab.x = this.area.x - prevTab.w + 1;
            prevTab.y = this.area.y + 2;
            this.buttons.add(prevTab);
            Button nextTab = new Button("nextTab"){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (!rightclick) {
                        NEIClientUtils.playClickSound();
                        return GuiRecipeTabs.this.nextPage();
                    }
                    return false;
                }

                @Override
                public String getRenderLabel() {
                    return ">";
                }
            };
            nextTab.w = prevTab.w;
            nextTab.h = prevTab.h;
            nextTab.x = this.area.x + this.area.width - 1;
            nextTab.y = prevTab.y;
            this.buttons.add(nextTab);
        }
    }

    public boolean nextPage() {
        this.pageNumber = this.hasNext() ? ++this.pageNumber : 0;
        this.refreshPage();
        return true;
    }

    public boolean hasNext() {
        return this.pageNumber + 1 < this.pageCount;
    }

    public boolean previousPage() {
        this.pageNumber = this.hasPrevious() ? --this.pageNumber : this.pageCount - 1;
        this.refreshPage();
        return true;
    }

    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    public void draw(int mouseX, int mouseY) {
        IRecipeHandler current = (IRecipeHandler)this.guiRecipe.currenthandlers.get(this.guiRecipe.recipetype);
        for (GuiRecipeTab tab : this.tabs) {
            tab.setSelected(current);
            tab.draw(mouseX, mouseY);
        }
        for (Button button : this.buttons) {
            button.draw(mouseX, mouseY);
        }
    }

    public void handleTooltip(int mousex, int mousey, List<String> tooltips) {
        if (!NEIClientConfig.areJEIStyleTabsVisible()) {
            return;
        }
        for (GuiRecipeTab tab : this.tabs) {
            if (!tab.contains(mousex, mousey)) continue;
            tab.addTooltips(tooltips);
        }
        for (Button button : this.buttons) {
            if (!button.contains(mousex, mousey)) continue;
            button.addTooltips(tooltips);
        }
    }

    protected boolean mouseClicked(int x, int y, int mouseButton) {
        if (!NEIClientConfig.areJEIStyleTabsVisible()) {
            return false;
        }
        for (Button button : this.buttons) {
            if (!button.contains(x, y)) continue;
            return button.onButtonPress(mouseButton == 1);
        }
        for (GuiRecipeTab tab : this.tabs) {
            if (!tab.contains(x, y)) continue;
            return tab.onButtonPress(mouseButton == 1);
        }
        return false;
    }

    protected boolean mouseScrolled(int i) {
        Point mousePosition = GuiDraw.getMousePosition();
        if (NEIClientConfig.areJEIStyleTabsVisible() && this.area.contains(mousePosition)) {
            if (i < 0) {
                this.guiRecipe.nextType();
            } else {
                this.guiRecipe.prevType();
            }
            return true;
        }
        return false;
    }
}

