/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.commands;

import codechicken.core.CommonUtils;
import codechicken.nei.ClientHandler;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerQuery;
import codechicken.nei.util.NBTJson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.io.IOUtils;

public class CommandRecipeId
extends CommandBase {
    public String getCommandName() {
        return "recipeid";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "/recipeid dump <filename> OR /recipeid diff <prev-filename> <curr-filename> [subset name]";
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    public void processCommand(ICommandSender sender, String[] args) {
        String command;
        String string = command = args.length == 0 ? null : args[0];
        if ("dump".equals(command)) {
            this.processDumpCommand(sender, args);
        } else if ("diff".equals(command)) {
            this.processDiffCommand(sender, args);
        } else {
            CommandRecipeId.sendChatErrorMessage(sender, this.getCommandUsage(sender), new Object[0]);
        }
    }

    protected void processDiffCommand(ICommandSender sender, String[] args) {
        if (args.length > 4) {
            CommandRecipeId.sendChatErrorMessage(sender, "nei.chat.recipeid.many_params", this.getCommandUsage(sender));
            return;
        }
        if (args.length < 3) {
            CommandRecipeId.sendChatErrorMessage(sender, this.getCommandUsage(sender), new Object[0]);
            return;
        }
        File prevFilename = CommandRecipeId.getFile(args[1]);
        File currFilename = CommandRecipeId.getFile(args[2]);
        File diffFilename = CommandRecipeId.getFile(args.length > 3 ? args[3] : "changelog");
        if (!prevFilename.exists()) {
            CommandRecipeId.sendChatErrorMessage(sender, "nei.chat.recipeid.not_found", prevFilename.getName());
            return;
        }
        if (!currFilename.exists()) {
            CommandRecipeId.sendChatErrorMessage(sender, "nei.chat.recipeid.not_found", currFilename.getName());
            return;
        }
        new ProcessDiffThread(sender, prevFilename, currFilename, diffFilename).start();
    }

    protected void processDumpCommand(ICommandSender sender, String[] args) {
        String currFilename;
        if (args.length > 2) {
            CommandRecipeId.sendChatErrorMessage(sender, "nei.chat.recipeid.many_params", this.getCommandUsage(sender));
            return;
        }
        File dir = new File(CommonUtils.getMinecraftDir(), "recipeid");
        String string = currFilename = args.length == 2 ? args[1] : "recipeId";
        if (!dir.exists()) {
            dir.mkdirs();
        }
        new ProcessDumpThread(sender, CommandRecipeId.getFile(currFilename)).start();
    }

    private static File getFile(String filename) {
        return new File(CommonUtils.getMinecraftDir(), "recipeid/" + filename + ".json");
    }

    private static void sendChatInfoMessage(ICommandSender sender, String translationKey, Object ... args) {
        sender.addChatMessage(new ChatComponentTranslation(translationKey, args).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.AQUA)));
    }

    private static void sendChatErrorMessage(ICommandSender sender, String translationKey, Object ... args) {
        sender.addChatMessage(new ChatComponentTranslation(translationKey, args).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.RED)));
    }

    protected static class ProcessDiffThread
    extends Thread {
        protected final ICommandSender sender;
        protected final File prevFile;
        protected final File currFile;
        protected final File diffFile;

        public ProcessDiffThread(ICommandSender sender, File prevFile, File currFile, File diffFile) {
            this.sender = sender;
            this.prevFile = prevFile;
            this.currFile = currFile;
            this.diffFile = diffFile;
        }

        @Override
        public void run() {
            CommandRecipeId.sendChatInfoMessage(this.sender, "nei.chat.recipeid.diff.start", new Object[0]);
            Set<String> prevRecipes = this.loadFileContent(this.prevFile);
            Set<String> currRecipes = this.loadFileContent(this.currFile);
            Set notAllowedRecipes = prevRecipes.stream().filter(recipe -> !currRecipes.contains(recipe)).collect(Collectors.toCollection(TreeSet::new));
            ArrayList<String> subsetsList = new ArrayList<String>();
            this.generateSubsets(notAllowedRecipes).forEach((handlerName, recipes) -> {
                subsetsList.add("; " + handlerName);
                subsetsList.addAll((Collection<String>)recipes);
            });
            this.saveFile(this.diffFile, subsetsList);
            this.saveFile(CommandRecipeId.getFile("not-allowed-recipes"), new ArrayList<String>(notAllowedRecipes));
            CommandRecipeId.sendChatInfoMessage(this.sender, "nei.chat.recipeid.diff.finish", new Object[0]);
        }

        private Set<String> loadFileContent(File file) {
            HashSet<String> hashSet;
            FileReader reader = new FileReader(file);
            try {
                hashSet = new HashSet<String>(IOUtils.readLines((Reader)reader));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    NEIClientConfig.logger.error("Failed to load '{}' file {}", new Object[]{file.getName(), file, e});
                    return new HashSet<String>();
                }
            }
            reader.close();
            return hashSet;
        }

        private Map<String, Set<String>> generateSubsets(Set<String> notAllowedRecipes) {
            JsonParser parser = new JsonParser();
            TreeMap<String, Set<String>> subsetsBuilder = new TreeMap<String, Set<String>>();
            for (String recipeStr : notAllowedRecipes) {
                try {
                    NBTTagCompound nbtRecipe = (NBTTagCompound)NBTJson.toNbt(parser.parse(recipeStr));
                    if (nbtRecipe.hasKey("result")) {
                        NBTTagCompound nbtStack = nbtRecipe.getCompoundTag("result");
                        nbtStack.removeTag("Count");
                        subsetsBuilder.computeIfAbsent(nbtRecipe.getString("handlerName"), rn -> new TreeSet()).add(NBTJson.toJson(nbtStack));
                        continue;
                    }
                    NEIClientConfig.logger.error("Found Broken RecipeId {}", new Object[]{recipeStr});
                }
                catch (Exception ex) {
                    NEIClientConfig.logger.error("Found Broken RecipeId {}", new Object[]{recipeStr, ex});
                }
            }
            return subsetsBuilder;
        }

        private void saveFile(File file, List<String> content) {
            try (FileOutputStream output = new FileOutputStream(file);){
                IOUtils.writeLines(content, (String)"\n", (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Failed to save recipeid diff list to file {}", new Object[]{file, e});
            }
        }
    }

    protected static class ProcessDumpThread
    extends Thread {
        private ArrayList<ICraftingHandler> craftinghandlers = new ArrayList();
        private ArrayList<ICraftingHandler> serialCraftingHandlers = new ArrayList();
        protected final ICommandSender sender;
        protected final File currFile;

        public ProcessDumpThread(ICommandSender sender, File currFile) {
            this.sender = sender;
            this.currFile = currFile;
            ClientHandler.loadSettingsFile("recipeidblacklist.cfg", lines -> {
                Set names = lines.collect(Collectors.toSet());
                this.craftinghandlers = GuiCraftingRecipe.craftinghandlers.stream().filter(h -> !names.contains(GuiRecipeTab.getHandlerInfo(h).getHandlerName())).collect(Collectors.toCollection(ArrayList::new));
                this.serialCraftingHandlers = GuiCraftingRecipe.serialCraftingHandlers.stream().filter(h -> !names.contains(GuiRecipeTab.getHandlerInfo(h).getHandlerName())).collect(Collectors.toCollection(ArrayList::new));
            });
        }

        @Override
        public void run() {
            NEIClientConfig.logger.info("Start processing recipe handlers!");
            CommandRecipeId.sendChatInfoMessage(this.sender, "nei.chat.recipeid.dump.start", new Object[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.currFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                int total = ItemList.items.size();
                int count = 0;
                for (ItemStack stack : ItemList.items) {
                    if (count % 1000 == 0) {
                        NEIClientConfig.logger.info("({}/{}). Processing {} crafting recipes...", new Object[]{count, total, stack.getDisplayName()});
                    }
                    ++count;
                    for (ICraftingHandler handler : this.getCraftingHandlers(stack)) {
                        int num = handler.numRecipes();
                        for (int index = 0; index < num; ++index) {
                            try {
                                Recipe recipe = Recipe.of(handler, index);
                                if (recipe.getIngredients().isEmpty() || recipe.getResults().isEmpty()) continue;
                                writer.write(NBTJson.toJson((JsonElement)recipe.getRecipeId().toJsonObject()));
                                writer.newLine();
                                continue;
                            }
                            catch (Exception ex) {
                                NEIClientConfig.logger.error("Found Broken RecipeId {}:{}", new Object[]{GuiRecipeTab.getHandlerInfo(handler).getHandlerName(), stack, ex});
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                NEIClientConfig.logger.error("Error dumping RecipeId", (Throwable)e);
            }
            NEIClientConfig.logger.info("Finished processing recipe handlers!");
            CommandRecipeId.sendChatInfoMessage(this.sender, "nei.chat.recipeid.dump.finish", new Object[0]);
        }

        private ArrayList<ICraftingHandler> getCraftingHandlers(Object ... results) {
            return new RecipeHandlerQuery<ICraftingHandler>(h -> h.getRecipeHandler("item", results), this.craftinghandlers, this.serialCraftingHandlers, "Error while looking up crafting recipe", "outputId: item", "results: " + Arrays.toString(results)).runWithProfiling(NEIClientUtils.translate("recipe.concurrent.crafting", new Object[0]));
        }
    }
}

