/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.guihook.GuiContainerManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class FastTransferManager {
    public LinkedList<LinkedList<Integer>> slotZones = new LinkedList();
    public HashMap<Integer, Integer> slotZoneMap = new HashMap();

    private void generateSlotMap(Container container, ItemStack stack) {
        stack = stack.copy();
        stack.stackSize = 1;
        for (int slotNo = 0; slotNo < container.inventorySlots.size(); ++slotNo) {
            if (this.slotZoneMap.containsKey(slotNo) || !container.getSlot(slotNo).isItemValid(stack)) continue;
            HashSet<Integer> connectedSlots = new HashSet<Integer>();
            this.findConnectedSlots(container, slotNo, connectedSlots);
            LinkedList<Integer> zoneSlots = new LinkedList<Integer>(connectedSlots);
            zoneSlots.sort(new SlotPositionComparator(container));
            this.slotZones.add(zoneSlots);
            Iterator iterator = zoneSlots.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.slotZoneMap.put(i, this.slotZones.size() - 1);
            }
        }
    }

    private void findConnectedSlots(Container container, int slotNo, HashSet<Integer> connectedSlots) {
        connectedSlots.add(slotNo);
        Slot slot = container.getSlot(slotNo);
        int threshold = 18;
        for (int i = 0; i < container.inventorySlots.size(); ++i) {
            if (connectedSlots.contains(i)) continue;
            Slot slot1 = container.getSlot(i);
            if (Math.abs(slot.xDisplayPosition - slot1.xDisplayPosition) > 18 || Math.abs(slot.yDisplayPosition - slot1.yDisplayPosition) > 18) continue;
            this.findConnectedSlots(container, i, connectedSlots);
        }
    }

    public static int findSlotWithItem(Container container, ItemStack teststack) {
        for (int slotNo = 0; slotNo < container.inventorySlots.size(); ++slotNo) {
            ItemStack stack = container.getSlot(slotNo).getStack();
            if (!NEIServerUtils.areStacksSameType(stack, teststack)) continue;
            return slotNo;
        }
        return -1;
    }

    public static void clearSlots(Container container) {
        for (int slotNo = 0; slotNo < container.inventorySlots.size(); ++slotNo) {
            ((Slot)container.inventorySlots.get(slotNo)).putStack(null);
        }
    }

    public void performMassTransfer(GuiContainer window, int fromSlot, int toSlot, ItemStack heldStack) {
        this.generateSlotMap(window.inventorySlots, heldStack);
        Integer fromZone = this.slotZoneMap.get(fromSlot);
        Integer toZone = this.slotZoneMap.get(toSlot);
        if (fromZone == null || toZone == null || fromZone.equals(toZone)) {
            return;
        }
        if (NEIClientUtils.getHeldItem() != null && !NEIServerUtils.areStacksSameType(heldStack, NEIClientUtils.getHeldItem())) {
            return;
        }
        if (!this.fillZoneWithHeldItem(window, toZone)) {
            return;
        }
        Iterator iterator = this.slotZones.get(fromZone).iterator();
        while (iterator.hasNext()) {
            int transferFrom = (Integer)iterator.next();
            ItemStack transferStack = window.inventorySlots.getSlot(transferFrom).getStack();
            if (!NEIServerUtils.areStacksSameType(heldStack, transferStack)) continue;
            FastTransferManager.clickSlot(window, transferFrom);
            if (this.fillZoneWithHeldItem(window, toZone)) continue;
            FastTransferManager.clickSlot(window, transferFrom);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findShiftClickDestinationSlot(Container container, int fromSlot) {
        LinkedList<ItemStack> save = this.saveContainer(container);
        Slot slot = container.getSlot(fromSlot);
        ItemStack stack = slot.getStack();
        if (stack == null) {
            return -1;
        }
        stack.stackSize = 1;
        slot.putStack(stack.copy());
        LinkedList<ItemStack> compareBefore = this.saveContainer(container);
        container.slotClick(fromSlot, 0, 1, (EntityPlayer)NEIClientUtils.mc().thePlayer);
        LinkedList<ItemStack> compareAfter = this.saveContainer(container);
        try {
            for (int i = 0; i < compareBefore.size(); ++i) {
                ItemStack after;
                ItemStack before;
                if (i == fromSlot || NEIServerUtils.areStacksIdentical(before = compareBefore.get(i), after = compareAfter.get(i)) || after == null || !(before == null ? NEIServerUtils.areStacksSameType(stack, after) : NEIServerUtils.areStacksSameType(stack, after) && after.stackSize - before.stackSize > 0)) continue;
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.restoreContainer(container, save);
        }
    }

    public LinkedList<ItemStack> saveContainer(Container container) {
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        for (int i = 0; i < container.inventorySlots.size(); ++i) {
            stacks.add(NEIServerUtils.copyStack(container.getSlot(i).getStack()));
        }
        return stacks;
    }

    public void restoreContainer(Container container, LinkedList<ItemStack> items) {
        for (int i = 0; i < container.inventorySlots.size(); ++i) {
            container.getSlot(i).putStack(items.get(i));
        }
        container.slotClick(-999, 0, 0, (EntityPlayer)NEIClientUtils.mc().thePlayer);
    }

    public void transferItem(GuiContainer window, int fromSlot) {
        int toSlot = this.findShiftClickDestinationSlot(window.inventorySlots, fromSlot);
        if (toSlot == -1) {
            return;
        }
        Slot from = window.inventorySlots.getSlot(fromSlot);
        if (from.isItemValid(from.getStack())) {
            this.moveOneItem(window, fromSlot, toSlot);
        } else {
            this.moveOutputSet(window, fromSlot, toSlot);
        }
    }

    public void transferItems(GuiContainer window, int fromSlot, int itemCount) {
        for (int i = 0; i < itemCount; ++i) {
            this.transferItem(window, fromSlot);
        }
    }

    public void moveOutputSet(GuiContainer window, int fromSlot, int toSlot) {
        if (NEIClientUtils.getHeldItem() != null) {
            return;
        }
        FastTransferManager.clickSlot(window, fromSlot);
        if (NEIClientUtils.getHeldItem() == null) {
            return;
        }
        FastTransferManager.clickSlot(window, toSlot);
    }

    public void moveOneItem(GuiContainer window, int fromSlot, int toSlot) {
        FastTransferManager.clickSlot(window, fromSlot);
        FastTransferManager.clickSlot(window, toSlot, 1);
        FastTransferManager.clickSlot(window, fromSlot);
    }

    public void retrieveItem(GuiContainer window, int toSlot) {
        Integer integer;
        Slot slot = window.inventorySlots.getSlot(toSlot);
        ItemStack slotStack = slot.getStack();
        if (slotStack == null || slotStack.stackSize == slot.getSlotStackLimit() || slotStack.stackSize == slotStack.getMaxStackSize()) {
            return;
        }
        this.generateSlotMap(window.inventorySlots, slotStack);
        Integer destZone = this.slotZoneMap.get(toSlot);
        if (destZone == null) {
            return;
        }
        int firstZoneSlot = this.findShiftClickDestinationSlot(window.inventorySlots, toSlot);
        int firstZone = -1;
        if (firstZoneSlot != -1 && (integer = this.slotZoneMap.get(firstZoneSlot)) != null && this.retrieveItemFromZone(window, firstZone = integer.intValue(), toSlot)) {
            return;
        }
        for (int zone = 0; zone < this.slotZones.size(); ++zone) {
            if (zone == destZone || zone == firstZone || !this.retrieveItemFromZone(window, zone, toSlot)) continue;
            return;
        }
        this.retrieveItemFromZone(window, destZone, toSlot);
    }

    private boolean retrieveItemFromZone(GuiContainer window, int zone, int toSlot) {
        Slot slot;
        ItemStack stack1;
        int i;
        ItemStack stack = window.inventorySlots.getSlot(toSlot).getStack();
        Iterator iterator = this.slotZones.get(zone).iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i == toSlot || !NEIServerUtils.areStacksSameType(stack, stack1 = (slot = window.inventorySlots.getSlot(i)).getStack()) || stack1.stackSize == slot.getSlotStackLimit() || stack1.stackSize == stack1.getMaxStackSize()) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        iterator = this.slotZones.get(zone).iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i == toSlot || !NEIServerUtils.areStacksSameType(stack, stack1 = (slot = window.inventorySlots.getSlot(i)).getStack())) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        return false;
    }

    public static void clickSlot(GuiContainer window, int slotIndex) {
        FastTransferManager.clickSlot(window, slotIndex, 0);
    }

    public static void clickSlot(GuiContainer window, int slotIndex, int button) {
        FastTransferManager.clickSlot(window, slotIndex, button, 0);
    }

    public static void clickSlot(GuiContainer window, int slotIndex, int button, int modifier) {
        GuiContainerManager.getManager(window).handleSlotClick(slotIndex, button, modifier);
    }

    public static int dropHeldItem(GuiContainer window) {
        EntityClientPlayerMP player = window.mc.thePlayer;
        ItemStack held = player.inventory.getItemStack();
        if (held == null) {
            return -1;
        }
        for (int i = 0; held != null && i < window.inventorySlots.inventorySlots.size(); ++i) {
            Slot slot = (Slot)window.inventorySlots.inventorySlots.get(i);
            if (!(slot.inventory instanceof InventoryPlayer) || slot.getHasStack() || !slot.isItemValid(held)) continue;
            FastTransferManager.clickSlot(window, i, 0, 0);
            if (player.inventory.getItemStack() != null) continue;
            return i;
        }
        return -1;
    }

    private boolean fillZoneWithHeldItem(GuiContainer window, int zoneIndex) {
        ItemStack inToSlot;
        ItemStack held;
        int transferTo;
        Iterator iterator = this.slotZones.get(zoneIndex).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.inventorySlots.getSlot(transferTo).getStack();
            if (!NEIServerUtils.areStacksSameType(inToSlot, held)) continue;
            FastTransferManager.clickSlot(window, transferTo);
        }
        iterator = this.slotZones.get(zoneIndex).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.inventorySlots.getSlot(transferTo).getStack();
            if (inToSlot != null) continue;
            FastTransferManager.clickSlot(window, transferTo);
        }
        return NEIClientUtils.getHeldItem() == null;
    }

    public void throwAll(GuiContainer window, int pickedUpFromSlot) {
        ItemStack held = NEIClientUtils.getHeldItem();
        if (held == null) {
            return;
        }
        FastTransferManager.clickSlot(window, -999);
        this.generateSlotMap(window.inventorySlots, held);
        Integer zone = this.slotZoneMap.get(pickedUpFromSlot);
        if (zone == null) {
            return;
        }
        Iterator iterator = this.slotZones.get(zone).iterator();
        while (iterator.hasNext()) {
            int slotIndex = (Integer)iterator.next();
            Slot slot = window.inventorySlots.getSlot(slotIndex);
            if (!NEIServerUtils.areStacksSameType(held, slot.getStack())) continue;
            FastTransferManager.clickSlot(window, slotIndex);
            FastTransferManager.clickSlot(window, -999);
        }
    }

    public static class SlotPositionComparator
    implements Comparator<Integer> {
        final Container container;

        public SlotPositionComparator(Container c) {
            this.container = c;
        }

        @Override
        public int compare(Integer arg0, Integer arg1) {
            Slot slot1 = this.container.getSlot(arg0.intValue());
            Slot slot2 = this.container.getSlot(arg1.intValue());
            if (slot2.yDisplayPosition != slot1.yDisplayPosition) {
                return slot1.yDisplayPosition - slot2.yDisplayPosition;
            }
            return slot1.xDisplayPosition - slot2.xDisplayPosition;
        }
    }
}

