/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.ClientHandler;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEISPH;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import codechicken.nei.util.NBTHelper;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipException;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import org.apache.logging.log4j.Level;

public class NEIServerUtils {
    public static boolean isRaining(World world) {
        return world.getWorldInfo().isRaining();
    }

    public static void toggleRaining(World world, boolean notify) {
        boolean raining;
        boolean bl = raining = !world.isRaining();
        if (!raining) {
            ((WorldServer)world).provider.resetRainAndThunder();
        } else {
            world.getWorldInfo().setRaining(!NEIServerUtils.isRaining(world));
        }
        if (notify) {
            ServerUtils.sendChatToAll((IChatComponent)new ChatComponentTranslation("nei.chat.rain." + (raining ? "on" : "off"), new Object[0]));
        }
    }

    public static void healPlayer(EntityPlayer player) {
        player.heal(20.0f);
        player.getFoodStats().addStats(20, 1.0f);
        player.extinguish();
    }

    public static void sendChatItemLink(EntityPlayerMP sender, ItemStack stackover) {
        ServerUtils.sendChatToAll((IChatComponent)new ChatComponentTranslation("nei.chat.item_link.text", new Object[]{sender.getDisplayName(), stackover.func_151000_E().setChatStyle(stackover.func_151000_E().getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/nei_bookmark " + stackover.writeToNBT(new NBTTagCompound()))))}));
    }

    public static long getTime(World world) {
        return world.getWorldInfo().getWorldTime();
    }

    public static void setTime(long l, World world) {
        world.getWorldInfo().setWorldTime(l);
    }

    public static void setSlotContents(EntityPlayer player, int slot, ItemStack item, boolean containerInv) {
        if (slot == -999) {
            player.inventory.setItemStack(item);
        } else if (containerInv) {
            player.openContainer.putStackInSlot(slot, item);
        } else {
            player.inventory.setInventorySlotContents(slot, item);
        }
    }

    public static ItemStack getSlotContents(EntityPlayer player, int slot, boolean containerInv) {
        if (slot == -999) {
            return player.inventory.getItemStack();
        }
        if (containerInv) {
            return player.openContainer.getSlot(slot).getStack();
        }
        return player.inventory.getStackInSlot(slot);
    }

    public static void deleteAllItems(EntityPlayerMP player) {
        for (Slot slot : player.openContainer.inventorySlots) {
            slot.putStack(null);
        }
        player.sendContainerAndContentsToPlayer(player.openContainer, player.openContainer.getInventory());
    }

    public static void setHourForward(World world, int hour, boolean notify) {
        long day = NEIServerUtils.getTime(world) / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        NEIServerUtils.setTime(newTime, world);
        if (notify) {
            ServerUtils.sendChatToAll((IChatComponent)new ChatComponentTranslation("nei.chat.time", new Object[]{NEIServerUtils.getTime(world) / 24000L, hour}));
        }
    }

    public static void advanceDisabledTimes(World world) {
        int hour;
        int dim = CommonUtils.getDimension((World)world);
        int newhour = hour = (int)(NEIServerUtils.getTime(world) % 24000L) / 1000;
        while (NEIServerConfig.isActionDisabled(dim, NEIActions.timeZones[newhour / 6])) {
            newhour = (newhour / 6 + 1) % 4 * 6;
        }
        if (newhour != hour) {
            NEIServerUtils.setHourForward(world, newhour, false);
        }
    }

    public static boolean canItemFitInInventory(EntityPlayer player, ItemStack itemstack) {
        return InventoryUtils.insertItem((InventoryRange)new InventoryRange((IInventory)player.inventory, 0, 36), (ItemStack)itemstack, (boolean)true) == 0;
    }

    public static void sendNotice(ICommandSender sender, IChatComponent msg, String permission) {
        ChatComponentTranslation notice = new ChatComponentTranslation("chat.type.admin", new Object[]{sender.getCommandSenderName(), msg.createCopy()});
        notice.getChatStyle().setColor(EnumChatFormatting.GRAY).setItalic(Boolean.valueOf(true));
        if (NEIServerConfig.canPlayerPerformAction("CONSOLE", permission)) {
            MinecraftServer.getServer().addChatMessage((IChatComponent)notice);
        }
        for (EntityPlayer p : ServerUtils.getPlayers()) {
            if (p == sender) {
                p.addChatComponentMessage(msg);
                continue;
            }
            if (!NEIServerConfig.canPlayerPerformAction(p.getCommandSenderName(), permission)) continue;
            p.addChatComponentMessage((IChatComponent)notice);
        }
    }

    public static boolean areStacksSameType(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.getItem() == stack2.getItem() && (!stack2.getHasSubtypes() || stack2.getItemDamage() == stack1.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)stack2, (ItemStack)stack1);
    }

    public static boolean areStacksSameTypeWithNBT(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.getItem() == stack2.getItem() && (!stack2.getHasSubtypes() || stack2.getItemDamage() == stack1.getItemDamage()) && NBTHelper.matchTag((NBTBase)stack1.getTagCompound(), (NBTBase)stack2.getTagCompound());
    }

    public static boolean areStacksSameTypeCrafting(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.getItem() == stack2.getItem() && (stack1.getItemDamage() == stack2.getItemDamage() || stack1.getItemDamage() == Short.MAX_VALUE || stack2.getItemDamage() == Short.MAX_VALUE || stack1.getItem().isDamageable());
    }

    public static boolean areStacksSameTypeCraftingWithNBT(ItemStack stack1, ItemStack stack2) {
        if (NEIServerUtils.areStacksSameTypeCrafting(stack2, stack1)) {
            if (NBTHelper.matchTag((NBTBase)stack1.getTagCompound(), (NBTBase)stack2.getTagCompound())) {
                return true;
            }
            if (NEIServerUtils.isItemTool(stack1) && (stack1.stackTagCompound == null || stack1.stackTagCompound.hasKey("GT.ToolStats")) && (stack2.stackTagCompound == null || stack2.stackTagCompound.hasKey("GT.ToolStats"))) {
                return true;
            }
            return stack1.getMaxStackSize() == 1 && stack2.getMaxStackSize() == 1 && stack1.stackTagCompound == null ^ stack2.stackTagCompound == null;
        }
        return false;
    }

    public static boolean isItemTool(ItemStack stack) {
        return GTMetaBaseItemHolder.gtMetaBaseItem != null && GTMetaBaseItemHolder.gtMetaBaseItem.isInstance(stack.getItem());
    }

    public static int compareStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1 == null || stack2 == null) {
            return stack1 == null ? -1 : 1;
        }
        if (stack1.getItem() != stack2.getItem()) {
            return Item.getIdFromItem((Item)stack1.getItem()) - Item.getIdFromItem((Item)stack2.getItem());
        }
        if (stack1.stackSize != stack2.stackSize) {
            return stack1.stackSize - stack2.stackSize;
        }
        return stack1.getItemDamage() - stack2.getItemDamage();
    }

    public static boolean areStacksIdentical(ItemStack stack1, ItemStack stack2) {
        return NEIServerUtils.compareStacks(stack1, stack2) == 0;
    }

    public static IChatComponent setColour(IChatComponent msg, EnumChatFormatting colour) {
        msg.getChatStyle().setColor(colour);
        return msg;
    }

    public static void givePlayerItem(EntityPlayerMP player, ItemStack stack, boolean infinite, boolean doGive) {
        if (stack.getItem() == null) {
            player.addChatComponentMessage(NEIServerUtils.setColour((IChatComponent)new ChatComponentTranslation("nei.chat.give.noitem", new Object[0]), EnumChatFormatting.WHITE));
            return;
        }
        int given = stack.stackSize;
        if (doGive) {
            if (infinite) {
                player.inventory.addItemStackToInventory(stack);
            } else {
                given -= InventoryUtils.insertItem((IInventory)player.inventory, (ItemStack)stack, (boolean)false);
            }
        }
        NEIServerUtils.sendNotice((ICommandSender)player, (IChatComponent)new ChatComponentTranslation("commands.give.success", new Object[]{stack.func_151000_E(), infinite ? "\u221e" : Integer.toString(given), player.getCommandSenderName()}), "notify-item");
        player.openContainer.detectAndSendChanges();
    }

    public static ItemStack copyStack(ItemStack itemstack, int i) {
        if (itemstack == null) {
            return null;
        }
        itemstack.stackSize += i;
        return itemstack.splitStack(i);
    }

    public static ItemStack copyStack(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        return NEIServerUtils.copyStack(itemstack, itemstack.stackSize);
    }

    public static void toggleMagnetMode(EntityPlayerMP player) {
        PlayerSave playerSave;
        playerSave.enableAction("magnet", !(playerSave = NEIServerConfig.forPlayer(player.getCommandSenderName())).isActionEnabled("magnet"));
    }

    public static int getCreativeMode(EntityPlayerMP player) {
        if (NEIServerConfig.forPlayer(player.getCommandSenderName()).isActionEnabled("creative+")) {
            return 2;
        }
        if (player.theItemInWorldManager.isCreative()) {
            return 1;
        }
        if (player.theItemInWorldManager.getGameType().isAdventure()) {
            return 3;
        }
        return 0;
    }

    public static WorldSettings.GameType getGameType(int mode) {
        switch (mode) {
            case 0: {
                return WorldSettings.GameType.SURVIVAL;
            }
            case 1: 
            case 2: {
                return WorldSettings.GameType.CREATIVE;
            }
            case 3: {
                return WorldSettings.GameType.ADVENTURE;
            }
        }
        return null;
    }

    public static void setGamemode(EntityPlayerMP player, int mode) {
        if (mode < 0 || mode >= NEIActions.gameModes.length || NEIActions.nameActionMap.containsKey(NEIActions.gameModes[mode]) && !NEIServerConfig.canPlayerPerformAction(player.getCommandSenderName(), NEIActions.gameModes[mode])) {
            return;
        }
        NEIServerConfig.forPlayer(player.getCommandSenderName()).enableAction("creative+", mode == 2);
        if (mode == 2 && !(player.openContainer instanceof ContainerCreativeInv)) {
            NEISPH.processCreativeInv(player, true);
        }
        player.theItemInWorldManager.setGameType(NEIServerUtils.getGameType(mode));
        new PacketCustom((Object)"NEI", 14).writeByte(mode).sendToPlayer((EntityPlayer)player);
        player.addChatMessage((IChatComponent)new ChatComponentTranslation("nei.chat.gamemode." + mode, new Object[0]));
    }

    public static void cycleCreativeInv(EntityPlayerMP player, int steps) {
        int row;
        int row2;
        InventoryPlayer inventory = player.inventory;
        ItemStack[][] slots = new ItemStack[10][9];
        PlayerSave playerSave = NEIServerConfig.forPlayer(player.getCommandSenderName());
        System.arraycopy(inventory.mainInventory, 0, slots[9], 0, 9);
        for (row2 = 0; row2 < 3; ++row2) {
            System.arraycopy(inventory.mainInventory, (row2 + 1) * 9, slots[row2 + 6], 0, 9);
        }
        for (row2 = 0; row2 < 6; ++row2) {
            System.arraycopy(playerSave.creativeInv, row2 * 9, slots[row2], 0, 9);
        }
        ItemStack[][] newslots = new ItemStack[10][];
        for (row = 0; row < 10; ++row) {
            newslots[(row + steps + 10) % 10] = slots[row];
        }
        System.arraycopy(newslots[9], 0, inventory.mainInventory, 0, 9);
        for (row = 0; row < 3; ++row) {
            System.arraycopy(newslots[row + 6], 0, inventory.mainInventory, (row + 1) * 9, 9);
        }
        for (row = 0; row < 6; ++row) {
            System.arraycopy(newslots[row], 0, playerSave.creativeInv, row * 9, 9);
        }
        playerSave.setDirty();
    }

    public static List<int[]> getEnchantments(ItemStack itemstack) {
        NBTTagList nbttaglist;
        ArrayList<int[]> arraylist = new ArrayList<int[]>();
        if (itemstack != null && (nbttaglist = itemstack.getEnchantmentTagList()) != null) {
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound tag = nbttaglist.getCompoundTagAt(i);
                arraylist.add(new int[]{tag.getShort("id"), tag.getShort("lvl")});
            }
        }
        return arraylist;
    }

    public static boolean stackHasEnchantment(ItemStack itemstack, int e) {
        List<int[]> allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(ItemStack itemstack, int e) {
        List<int[]> allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return ai[1];
        }
        return -1;
    }

    public static boolean doesEnchantmentConflict(List<int[]> enchantments, Enchantment e) {
        for (int[] ai : enchantments) {
            if (e.canApplyTogether(Enchantment.enchantmentsList[ai[0]])) continue;
            return true;
        }
        return false;
    }

    public static RuntimeException throwCME(String msg) {
        if (CommonUtils.isClient()) {
            return ClientHandler.throwCME(msg);
        }
        throw new RuntimeException(msg);
    }

    public static ItemStack[] extractRecipeItems(Object obj) {
        if (obj instanceof ItemStack) {
            return new ItemStack[]{(ItemStack)obj};
        }
        if (obj instanceof ItemStack[]) {
            return (ItemStack[])obj;
        }
        if (obj instanceof List) {
            return ((List)obj).toArray(new ItemStack[0]);
        }
        throw new ClassCastException(obj + " not an ItemStack, ItemStack[] or List<ItemStack?");
    }

    public static List<Integer> getRange(final int start, final int end) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return start + index;
            }

            @Override
            public int size() {
                return end - start;
            }
        };
    }

    public static StringBuilder fixTrailingCommaList(StringBuilder sb) {
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static void logOnce(Throwable t, Set<String> stackTraces, String message) {
        NEIServerUtils.logOnce(t, stackTraces, message, "");
    }

    public static void logOnce(Throwable t, Set<String> stackTraces, String message, String identifier) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String stackTrace = identifier + sw.toString();
        if (!stackTraces.contains(stackTrace)) {
            NEIServerConfig.logger.error(message, t);
            stackTraces.add(stackTrace);
        }
    }

    public static ItemStack getModdedItem(String itemId, String nbtString) {
        ItemStack itemStack;
        int meta = -1;
        if (!itemId.contains(":")) {
            NEIClientConfig.logger.info(String.format("Item ID %s is missing colon", itemId));
            return null;
        }
        String[] split = itemId.split(":");
        String itemLookupId = split[0] + ":" + split[1];
        if (split.length >= 3) {
            int mIdx = -1;
            if (split[2].matches("\\d+")) {
                mIdx = 2;
            } else {
                itemLookupId = itemLookupId + ":" + split[2];
                if (split.length >= 4) {
                    mIdx = 3;
                }
            }
            if (mIdx != -1) {
                meta = Integer.parseInt(split[mIdx]);
            }
        }
        if (meta != -1) {
            itemStack = GameRegistry.makeItemStack((String)itemLookupId, (int)meta, (int)1, (String)(nbtString == null ? "" : nbtString));
        } else {
            itemStack = GameRegistry.findItemStack((String)split[0], (String)split[1], (int)1);
            if (nbtString != null && !nbtString.isEmpty()) {
                try {
                    NBTBase nbttag = JsonToNBT.func_150315_a((String)nbtString);
                    if (!(nbttag instanceof NBTTagCompound)) {
                        NEIClientConfig.logger.info("Unexpected NBT string - multiple values {}", new Object[]{nbtString});
                        return null;
                    }
                    itemStack.setTagCompound((NBTTagCompound)nbttag);
                }
                catch (NBTException e) {
                    FMLLog.getLogger().log(Level.WARN, "Encountered an exception parsing ItemStack NBT string {}", new Object[]{nbtString, e});
                    return null;
                }
            }
        }
        return itemStack;
    }

    public static NBTTagCompound readNBT(File file) throws IOException {
        NBTTagCompound tag;
        if (!file.exists()) {
            return null;
        }
        FileInputStream in = new FileInputStream(file);
        try {
            tag = CompressedStreamTools.readCompressed((InputStream)in);
        }
        catch (ZipException e) {
            if (e.getMessage().equals("Not in GZIP format")) {
                tag = CompressedStreamTools.read((File)file);
            }
            throw e;
        }
        in.close();
        return tag;
    }

    public static void writeNBT(NBTTagCompound tag, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        CompressedStreamTools.writeCompressed((NBTTagCompound)tag, (OutputStream)out);
        out.close();
    }

    public static int divideCeil(int numerator, int denominator) {
        return (int)Math.ceil((float)numerator / (float)denominator);
    }

    private static class GTMetaBaseItemHolder {
        private static final Class<?> gtMetaBaseItem = GTMetaBaseItemHolder.loadMetaBaseItem();

        private GTMetaBaseItemHolder() {
        }

        private static Class<?> loadMetaBaseItem() {
            try {
                ClassLoader loader = NEIServerUtils.class.getClassLoader();
                return ReflectionHelper.getClass((ClassLoader)loader, (String[])new String[]{"gregtech.api.items.MetaBaseItem", "gregtech.api.items.GT_MetaBase_Item"});
            }
            catch (Exception ignored) {
                return null;
            }
        }
    }
}

