/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.guihook.GuiContainerManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public class DefaultOverlayRenderer
implements IRecipeOverlayRenderer {
    final IStackPositioner positioner;
    ArrayList<PositionedStack> ingreds;

    public DefaultOverlayRenderer(List<PositionedStack> ai, IStackPositioner positioner) {
        this.positioner = positioner;
        this.ingreds = new ArrayList();
        for (PositionedStack stack : ai) {
            this.ingreds.add(stack.copy());
        }
        this.ingreds = positioner.positionStacks(this.ingreds);
    }

    @Override
    public void renderOverlay(GuiContainerManager gui, Slot slot) {
        GL11.glPushAttrib((int)24640);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        for (PositionedStack stack : this.ingreds) {
            if (stack.relx != slot.xDisplayPosition || stack.rely != slot.yDisplayPosition || slot.getHasStack()) continue;
            GuiContainerManager.drawItem(stack.relx, stack.rely, stack.item);
            DefaultOverlayRenderer.drawHover(stack.relx, stack.rely);
        }
        GL11.glPopAttrib();
    }

    private static void drawHover(int x, int y) {
        NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)x, (int)y, (int)16, (int)16, (int)0x66555555));
    }
}

