/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.FavoriteRecipes;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.Widget;
import codechicken.nei.api.IGuiContainerOverlay;
import codechicken.nei.api.ShortcutInputHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.AcceptsFollowingTooltipLineHandler;
import codechicken.nei.recipe.GuiFavoriteButton;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerRef;
import cpw.mods.fml.common.eventhandler.Event;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class NEIRecipeWidget
extends Widget {
    protected AcceptsFollowingTooltipLineHandler acceptsFollowingTooltipLineHandler;
    protected final WeakHashMap<PositionedStack, List<ItemStack>> permutations = new WeakHashMap();
    protected boolean update = true;
    protected int cycleticks = 0;
    protected int lastcycle = -1;
    protected final RecipeHandlerRef handlerRef;
    protected final HandlerInfo handlerInfo;
    protected boolean showAsWidget = false;
    protected List<GuiRecipeButton> recipeButtons = null;

    public NEIRecipeWidget(RecipeHandlerRef handlerRef) {
        this.handlerRef = handlerRef;
        this.handlerInfo = GuiRecipeTab.getHandlerInfo(this.handlerRef.handler);
        this.update();
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void update() {
        if (this.showAsWidget || !this.handlerInfo.getUseCustomScroll()) {
            int recipeHeight = this.handlerRef.handler.getRecipeHeight(this.handlerRef.recipeIndex);
            this.w = Math.max(166, this.handlerInfo.getWidth());
            this.h = recipeHeight > 0 ? recipeHeight : this.handlerInfo.getHeight();
            this.h += this.handlerInfo.getYShift();
        }
        this.update = true;
    }

    public List<GuiRecipeButton> getRecipeButtons() {
        if (this.recipeButtons == null) {
            this.recipeButtons = !this.getOutputs().isEmpty() ? this.initButtons() : Collections.emptyList();
        }
        return Collections.unmodifiableList(this.recipeButtons);
    }

    protected List<GuiRecipeButton> getRecipeButtonsIfInit() {
        if (this.recipeButtons == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.recipeButtons);
    }

    public RecipeHandlerRef getRecipeHandlerRef() {
        return this.handlerRef;
    }

    public Recipe getRecipe() {
        return Recipe.of(this.handlerRef);
    }

    public HandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    public void showAsWidget(boolean show) {
        this.showAsWidget = show;
    }

    protected List<GuiRecipeButton> initButtons() {
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        if (guiRecipe != null) {
            GuiRecipeButton.UpdateRecipeButtonsEvent.Pre preEvent = new GuiRecipeButton.UpdateRecipeButtonsEvent.Pre(guiRecipe, this, this.handlerInfo);
            if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
                return preEvent.buttonList;
            }
            GuiRecipeButton.UpdateRecipeButtonsEvent.Post postEvent = new GuiRecipeButton.UpdateRecipeButtonsEvent.Post(guiRecipe, this, this.getDefatulButtons());
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
            return postEvent.buttonList;
        }
        return this.getDefatulButtons();
    }

    protected List<GuiRecipeButton> getDefatulButtons() {
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        ArrayList<GuiRecipeButton> buttons = new ArrayList<GuiRecipeButton>();
        boolean showFavorites = NEIClientConfig.favoritesEnabled() && this.handlerInfo.getShowFavoritesButton();
        boolean showOverlay = this.handlerInfo.getShowOverlayButton();
        int x = Math.min(168, this.w) - 12;
        int y = this.h - 12 - 6;
        if (guiContainer instanceof IGuiContainerOverlay) {
            IGuiContainerOverlay overlay = (IGuiContainerOverlay)guiContainer;
            guiContainer = overlay.getFirstScreen();
        }
        if (showOverlay) {
            buttons.add(new GuiOverlayButton(guiContainer, this.handlerRef, x, y));
            y -= 13;
        }
        if (showFavorites) {
            buttons.add(new GuiFavoriteButton(this.handlerRef, x, y));
        }
        return buttons;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        int yShift = this.handlerInfo.getYShift();
        if (this.update) {
            this.update = false;
            if (!NEIClientUtils.shiftKey() && this.cycleticks++ / 20 != this.lastcycle || this.lastcycle == -1) {
                this.lastcycle = this.cycleticks / 20;
                this.updatePermutations();
            }
            for (GuiRecipeButton button : this.getRecipeButtons()) {
                button.update();
            }
        }
        GL11.glPushAttrib((int)24640);
        GL11.glTranslatef((float)this.x, (float)(this.y + yShift), (float)0.0f);
        this.handlerRef.handler.drawBackground(this.handlerRef.recipeIndex);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiContainerManager.enableMatrixStackLogging();
        for (PositionedStack pStack : this.getInputs()) {
            GuiContainerManager.drawItem(pStack.relx, pStack.rely, pStack.item);
            if (!pStack.contains(mouseX - this.x, mouseY - this.y - yShift)) continue;
            NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)pStack.relx, (int)pStack.rely, (int)16, (int)16, (int)-2130706433));
        }
        for (PositionedStack pStack : this.getCatalysts()) {
            GuiContainerManager.drawItem(pStack.relx, pStack.rely, pStack.item);
            if (!pStack.contains(mouseX - this.x, mouseY - this.y - yShift)) continue;
            NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)pStack.relx, (int)pStack.rely, (int)16, (int)16, (int)-2130706433));
        }
        for (PositionedStack pStack : this.getOutputs()) {
            GuiContainerManager.drawItem(pStack.relx, pStack.rely, pStack.item);
            if (!pStack.contains(mouseX - this.x, mouseY - this.y - yShift)) continue;
            NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)pStack.relx, (int)pStack.rely, (int)16, (int)16, (int)-2130706433));
        }
        GuiContainerManager.disableMatrixStackLogging();
        this.handlerRef.handler.drawForeground(this.handlerRef.recipeIndex);
        GuiRecipeButton overlayButton = this.getRecipeButtons().stream().filter(b -> this.showAsWidget ? b instanceof GuiOverlayButton : b.contains(mouseX - this.x, mouseY - this.y - yShift)).findAny().orElse(null);
        if (overlayButton != null && overlayButton.enabled) {
            NEIClientUtils.gl2DRenderContext(() -> overlayButton.drawItemOverlay());
        }
        GL11.glTranslatef((float)(-this.x), (float)(-this.y - yShift), (float)0.0f);
        GL11.glPopAttrib();
        if (!this.showAsWidget) {
            Minecraft mc = NEIClientUtils.mc();
            for (GuiRecipeButton button : this.getRecipeButtons()) {
                button.xPosition += this.x;
                button.yPosition += this.y;
                button.drawButton(mc, mouseX, mouseY);
                button.xPosition -= this.x;
                button.yPosition -= this.y;
            }
        }
        LayoutManager.recipeHandlerWidget.drawGuiPlaceholder(this);
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        return false;
    }

    @Override
    public void lastKeyTyped(int keyID, char keyChar) {
        Point mouse = GuiDraw.getMousePosition();
        this.forEachButtons(button -> {
            if (button.contains(mouse.x, mouse.y)) {
                button.lastKeyTyped(keyChar, keyID);
            }
            return null;
        }, null);
    }

    @Override
    public boolean handleClick(int mouseX, int mouseY, int button) {
        Minecraft mc;
        if (ShortcutInputHandler.handleMouseClick(this.getStackMouseOver(mouseX, mouseY))) {
            return true;
        }
        if (button == 0 && this.forEachButtons(arg_0 -> NEIRecipeWidget.lambda$handleClick$6(mc = NEIClientUtils.mc(), mouseX, mouseY, arg_0), false).booleanValue()) {
            return true;
        }
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        if (guiRecipe == null) {
            return false;
        }
        return this.handlerRef.handler.mouseClicked(guiRecipe, button, this.handlerRef.recipeIndex);
    }

    @Override
    public List<String> handleTooltip(int mouseX, int mouseY, List<String> tooltip) {
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        if (guiRecipe == null) {
            return tooltip;
        }
        List<String> localTooltip = this.handlerRef.handler.handleTooltip(guiRecipe, tooltip, this.handlerRef.recipeIndex);
        return this.forEachButtons(button -> button.contains(mouseX, mouseY) ? button.handleTooltip(localTooltip) : null, localTooltip);
    }

    @Override
    public List<String> handleItemTooltip(ItemStack itemstack, int mousex, int mousey, List<String> tooltip) {
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        if (guiRecipe == null) {
            return tooltip;
        }
        tooltip = this.handlerRef.handler.handleItemTooltip(guiRecipe, itemstack, tooltip, this.handlerRef.recipeIndex);
        if (NEIClientConfig.showCycledIngredientsTooltip() && itemstack != null) {
            int yShift = this.handlerInfo.getYShift();
            PositionedStack hovered = null;
            for (PositionedStack pStack : this.getInputs()) {
                if (!pStack.contains(mousex - this.x, mousey - this.y - yShift)) continue;
                hovered = pStack;
                break;
            }
            if (hovered == null) {
                for (PositionedStack pStack : this.getCatalysts()) {
                    if (!pStack.contains(mousex - this.x, mousey - this.y - yShift)) continue;
                    hovered = pStack;
                }
            }
            if (hovered == null || hovered.items.length <= 1) {
                this.acceptsFollowingTooltipLineHandler = null;
            } else if (this.acceptsFollowingTooltipLineHandler == null || this.acceptsFollowingTooltipLineHandler.tooltipGUID != hovered) {
                this.acceptsFollowingTooltipLineHandler = AcceptsFollowingTooltipLineHandler.of(hovered, hovered.getFilteredPermutations(), hovered.item);
            }
        } else if (this.acceptsFollowingTooltipLineHandler != null) {
            this.acceptsFollowingTooltipLineHandler = null;
        }
        if (this.acceptsFollowingTooltipLineHandler != null) {
            tooltip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.acceptsFollowingTooltipLineHandler));
        }
        return tooltip;
    }

    @Override
    public Map<String, String> handleHotkeys(int mouseX, int mouseY, Map<String, String> hotkeys) {
        Map<String, String> buttonHotkeys = this.forEachButtons(button -> button.contains(mouseX, mouseY) ? button.handleHotkeys(mouseX, mouseY, hotkeys) : null, hotkeys);
        if (this.acceptsFollowingTooltipLineHandler != null) {
            buttonHotkeys.put(NEIClientUtils.getKeyName(0x4000000, -2013265920), NEIClientUtils.translate("recipe.accepts.scroll", new Object[0]));
        }
        return buttonHotkeys;
    }

    @Override
    public boolean onMouseWheel(int scroll, int mx, int my) {
        if (this.forEachButtons(button -> button.contains(mx, my) ? Boolean.valueOf(button.mouseScrolled(scroll)) : null, false).booleanValue()) {
            return true;
        }
        if (this.scrollPermutations(scroll, mx, my)) {
            return true;
        }
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        return guiRecipe != null && this.handlerRef.handler.mouseScrolled(guiRecipe, scroll, this.handlerRef.recipeIndex);
    }

    protected boolean scrollPermutations(int scroll, int mx, int my) {
        if (!NEIClientUtils.shiftKey()) {
            return false;
        }
        PositionedStack overStack = this.getPositionedStackMouseOver(mx, my);
        if (overStack != null && overStack.items.length > 1) {
            List<ItemStack> items = overStack.getFilteredPermutations();
            int stackIndex = this.indexOf(items, overStack.item);
            ItemStack stack = items.get((items.size() - scroll + stackIndex) % items.size());
            Stream.concat(this.getInputs().stream(), this.getCatalysts().stream()).filter(pStack -> pStack.containsWithNBT(stack)).forEach(pStack -> pStack.setPermutationToRender(stack));
            if (this.acceptsFollowingTooltipLineHandler != null) {
                this.acceptsFollowingTooltipLineHandler.setActiveStack(((PositionedStack)this.acceptsFollowingTooltipLineHandler.tooltipGUID).item);
            }
            return true;
        }
        return false;
    }

    protected int indexOf(List<ItemStack> list, ItemStack stack) {
        for (int i = 0; i < list.size(); ++i) {
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT(list.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    protected <R> R forEachButtons(Function<GuiRecipeButton, R> callback, R defaultValue) {
        for (GuiRecipeButton button : this.getRecipeButtonsIfInit()) {
            button.xPosition += this.x;
            button.yPosition += this.y;
            R result = callback.apply(button);
            button.xPosition -= this.x;
            button.yPosition -= this.y;
            if (result == null) continue;
            return result;
        }
        return defaultValue;
    }

    public boolean isFocusedRecipe(int mx, int my) {
        int yShift = this.handlerInfo.getYShift();
        for (PositionedStack pStackOver : this.getOutputs()) {
            if (!pStackOver.contains(mx - this.x, my - this.y - yShift)) continue;
            return true;
        }
        return false;
    }

    public PositionedStack getPositionedStackMouseOver(int mx, int my) {
        int yShift = this.handlerInfo.getYShift();
        for (PositionedStack pStack : this.getInputs()) {
            if (!pStack.contains(mx - this.x, my - this.y - yShift)) continue;
            return pStack;
        }
        for (PositionedStack pStack : this.getCatalysts()) {
            if (!pStack.contains(mx - this.x, my - this.y - yShift)) continue;
            return pStack;
        }
        for (PositionedStack pStack : this.getOutputs()) {
            if (!pStack.contains(mx - this.x, my - this.y - yShift)) continue;
            return pStack;
        }
        return null;
    }

    @Override
    public ItemStack getStackMouseOver(int mx, int my) {
        PositionedStack pStack = this.getPositionedStackMouseOver(mx, my);
        return pStack != null ? pStack.item : null;
    }

    protected GuiRecipe<?> getGuiRecipe() {
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        if (guiContainer instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)guiContainer;
            return guiRecipe;
        }
        return null;
    }

    protected GuiContainer getFirstGui() {
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        if (guiContainer instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)guiContainer;
            return guiRecipe.firstGui;
        }
        return guiContainer;
    }

    protected void updatePermutations() {
        List permutations;
        for (PositionedStack pStack : this.getInputs()) {
            if (pStack.items.length <= 1) continue;
            permutations = this.permutations.computeIfAbsent(pStack, stack -> stack.getFilteredPermutations(FavoriteRecipes::contains));
            pStack.setPermutationToRender((ItemStack)permutations.get(this.lastcycle % permutations.size()));
        }
        for (PositionedStack pStack : this.getCatalysts()) {
            if (pStack.items.length <= 1) continue;
            permutations = this.permutations.computeIfAbsent(pStack, stack -> stack.getFilteredPermutations(FavoriteRecipes::contains));
            pStack.setPermutationToRender((ItemStack)permutations.get(this.lastcycle % permutations.size()));
        }
        if (this.acceptsFollowingTooltipLineHandler != null) {
            this.acceptsFollowingTooltipLineHandler.setActiveStack(((PositionedStack)this.acceptsFollowingTooltipLineHandler.tooltipGUID).item);
        }
    }

    protected List<PositionedStack> getInputs() {
        return this.handlerRef.handler.getIngredientStacks(this.handlerRef.recipeIndex);
    }

    protected List<PositionedStack> getOutputs() {
        PositionedStack pStackResult = this.handlerRef.handler.getResultStack(this.handlerRef.recipeIndex);
        return pStackResult != null ? Arrays.asList(pStackResult) : this.handlerRef.handler.getOtherStacks(this.handlerRef.recipeIndex);
    }

    protected List<PositionedStack> getCatalysts() {
        if (this.handlerRef.handler.getResultStack(this.handlerRef.recipeIndex) == null) {
            return Collections.emptyList();
        }
        return this.handlerRef.handler.getOtherStacks(this.handlerRef.recipeIndex);
    }

    private static /* synthetic */ Boolean lambda$handleClick$6(Minecraft mc, int mouseX, int mouseY, GuiRecipeButton guibutton) {
        if (guibutton.mousePressed(mc, mouseX, mouseY)) {
            NEIClientUtils.playClickSound();
            guibutton.mouseReleased(mouseX, mouseY);
            return true;
        }
        return null;
    }
}

