/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.search;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.search.AbstractSearchExpressionVisitor;
import codechicken.nei.search.SearchExpressionParser;
import codechicken.nei.shadow.org.antlr.v4.runtime.ParserRuleContext;
import codechicken.nei.shadow.org.antlr.v4.runtime.tree.ParseTree;
import codechicken.nei.shadow.org.antlr.v4.runtime.tree.RuleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;

public class ItemFilterVisitor
extends AbstractSearchExpressionVisitor<ItemFilter> {
    private static final Pattern REGEX_ESCAPED_SPACE_PATTERN = Pattern.compile("([^\\\\](?:\\\\\\\\)+)?\\\\ ");
    private static final Pattern ESCAPED_SYMBOL_PATTERN = Pattern.compile("\\\\(.)");
    private static final Pattern ESCAPED_QUOTE_PATTERN = Pattern.compile("\\\\\"");
    private static final Pattern ESCAPED_SPACE_PATTERN = Pattern.compile("\\\\ ");

    public ItemFilterVisitor(SearchTokenParser searchParser) {
        super(searchParser);
    }

    @Override
    public ItemFilter visitChildren(RuleNode node) {
        if (node instanceof ParserRuleContext) {
            return this.visitChildren((ParserRuleContext)node, null);
        }
        return this.defaultResult();
    }

    @Override
    public ItemFilter visitRecipeSearchExpression(SearchExpressionParser.RecipeSearchExpressionContext ctx) {
        if (ctx.recipeClauseExpression() != null) {
            ArrayList<ItemFilter> anyFilters = new ArrayList<ItemFilter>();
            ArrayList<ItemFilter> allFilters = new ArrayList<ItemFilter>();
            for (SearchExpressionParser.RecipeClauseExpressionContext clauseCtx : ctx.recipeClauseExpression()) {
                this.addIngredientPermutationItemFilter(clauseCtx.searchExpression(), anyFilters, allFilters);
            }
            return this.constructFilter(anyFilters, allFilters);
        }
        return this.defaultResult();
    }

    @Override
    public ItemFilter visitOrExpression(SearchExpressionParser.OrExpressionContext ctx) {
        return this.visitChildren(ctx, ItemList.AnyMultiItemFilter::new);
    }

    @Override
    public ItemFilter visitSequenceExpression(SearchExpressionParser.SequenceExpressionContext ctx) {
        return this.visitChildren(ctx, ItemList.AllMultiItemFilter::new);
    }

    @Override
    public ItemFilter visitNegateExpression(SearchExpressionParser.NegateExpressionContext ctx) {
        return new ItemList.NegatedItemFilter(this.visitChildren(ctx));
    }

    @Override
    public ItemFilter visitPrefixedExpression(SearchExpressionParser.PrefixedExpressionContext ctx) {
        if (ctx.token() != null) {
            String cleanPattern = this.getCleanPattern(ctx.token());
            SearchTokenParser.ISearchParserProvider provider = this.searchParser.getProvider(ctx.token().prefix.charValue());
            if (cleanPattern == null || provider == null) {
                return this.defaultResult();
            }
            return provider.getFilter(cleanPattern);
        }
        return this.defaultResult();
    }

    @Override
    public ItemFilter visitToken(SearchExpressionParser.TokenContext ctx) {
        String cleanPattern = this.getCleanPattern(ctx);
        if (cleanPattern != null) {
            return this.getAlwaysProvidersFilter(cleanPattern);
        }
        return this.defaultResult();
    }

    @Override
    protected ItemFilter defaultResult() {
        return new ItemList.NothingItemFilter();
    }

    private void addIngredientPermutationItemFilter(SearchExpressionParser.SearchExpressionContext ctx, List<ItemFilter> anyFilters, List<ItemFilter> allFilters) {
        if (ctx.type == 0 || ctx.type == 3) {
            if (ctx.allRecipe) {
                allFilters.add((ItemFilter)this.visit(ctx));
            } else {
                anyFilters.add((ItemFilter)this.visit(ctx));
            }
        }
    }

    private ItemFilter constructFilter(List<ItemFilter> anyFilters, List<ItemFilter> allFilters) {
        if (anyFilters.isEmpty()) {
            return this.constructFilter(allFilters, ItemList.AllMultiItemFilter::new);
        }
        if (allFilters.isEmpty()) {
            return this.constructFilter(anyFilters, ItemList.AnyMultiItemFilter::new);
        }
        ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
        filters.add(this.constructFilter(allFilters, ItemList.AllMultiItemFilter::new));
        filters.add(this.constructFilter(anyFilters, ItemList.AnyMultiItemFilter::new));
        return this.constructFilter(filters, ItemList.AllMultiItemFilter::new);
    }

    private String getCleanPattern(SearchExpressionParser.TokenContext ctx) {
        String cleanPattern = null;
        if (ctx.plainText() != null) {
            cleanPattern = Pattern.quote(ESCAPED_SYMBOL_PATTERN.matcher(ctx.plainText().getText()).replaceAll("$1"));
        } else if (ctx.regex() != null) {
            if (ctx.regex().REGEX_CONTENT() != null) {
                cleanPattern = ctx.regex().REGEX_CONTENT().getSymbol().getText();
                int spaceModeEnabled = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
                if (spaceModeEnabled == 1) {
                    cleanPattern = REGEX_ESCAPED_SPACE_PATTERN.matcher(cleanPattern).replaceAll("$1 ");
                }
            }
        } else if (ctx.quoted() != null && ctx.quoted().QUOTED_CONTENT() != null) {
            cleanPattern = ctx.quoted().QUOTED_CONTENT().getSymbol().getText();
            cleanPattern = ESCAPED_QUOTE_PATTERN.matcher(cleanPattern).replaceAll("\"");
            cleanPattern = Pattern.quote(cleanPattern);
            int spaceModeEnabled = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
            if (spaceModeEnabled == 1) {
                cleanPattern = ESCAPED_SPACE_PATTERN.matcher(cleanPattern).replaceAll(" ");
            }
        }
        return cleanPattern;
    }

    private ItemFilter visitChildren(ParserRuleContext node, Function<List<ItemFilter>, ItemFilter> filterConstructor) {
        if (node.children != null && !node.children.isEmpty()) {
            if (filterConstructor == null) {
                for (ParseTree child : node.children) {
                    if (!(child instanceof RuleNode)) continue;
                    return (ItemFilter)this.visit(child);
                }
                return this.defaultResult();
            }
            ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
            for (ParseTree child : node.children) {
                if (!(child instanceof RuleNode)) continue;
                filters.add((ItemFilter)this.visit(child));
            }
            return this.constructFilter(filters, filterConstructor);
        }
        return this.defaultResult();
    }

    private ItemFilter getAlwaysProvidersFilter(String searchText) {
        List<ItemFilter> filters = this.searchParser.getAlwaysProvidersFilters(searchText);
        return this.constructFilter(filters, ItemList.AnyMultiItemFilter::new);
    }

    private ItemFilter constructFilter(List<ItemFilter> filters, Function<List<ItemFilter>, ItemFilter> constructor) {
        if (!filters.isEmpty()) {
            if (filters.size() == 1) {
                return filters.get(0);
            }
            return constructor.apply(filters);
        }
        return this.defaultResult();
    }
}

