/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.drawable;

import codechicken.nei.Image;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class DrawableResource
extends Image {
    private final ResourceLocation resourceLocation;
    private final int textureWidth;
    private final int textureHeight;
    private final int paddingTop;
    private final int paddingBottom;
    private final int paddingLeft;
    private final int paddingRight;

    public DrawableResource(ResourceLocation resourceLocation, int u, int v, int width, int height, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight, int textureWidth, int textureHeight) {
        super(u, v, width, height);
        this.resourceLocation = resourceLocation;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
    }

    public int getWidth() {
        return this.width + this.paddingLeft + this.paddingRight;
    }

    public int getHeight() {
        return this.height + this.paddingTop + this.paddingBottom;
    }

    public void draw(int xOffset, int yOffset) {
        this.draw(xOffset, yOffset, 0, 0, 0, 0);
    }

    public void draw(int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        boolean is2DTexture = GL11.glGetBoolean((int)3553);
        int width = this.width - maskRight - maskLeft;
        int height = this.height - maskBottom - maskTop;
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resourceLocation);
        this.drawModalRectWithCustomSizedTexture(xOffset + maskLeft, yOffset + maskTop, maskLeft, maskTop, width, height);
        if (!is2DTexture) {
            GL11.glDisable((int)3553);
        }
    }

    public void draw(int xOffset, int yOffset, int width, int height, int sliceLeft, int sliceRight, int sliceTop, int sliceBottom) {
        int textureWidth = this.getWidth();
        int textureHeight = this.getHeight();
        int middleWidth = textureWidth - sliceLeft - sliceRight;
        int middleHeight = textureHeight - sliceTop - sliceBottom;
        int tileWidth = width - sliceLeft - sliceRight;
        int tileHeight = height - sliceTop - sliceBottom;
        if (middleWidth > 0 && middleHeight > 0 && tileWidth > 0 && tileHeight > 0) {
            int tileHeightSize;
            int tileH;
            int tileWidthSize;
            int tileW;
            boolean is2DTexture = GL11.glGetBoolean((int)3553);
            int tileWidthCount = tileWidth / middleWidth;
            int remainderWidth = tileWidth - tileWidthCount * middleWidth;
            int tileHeightCount = tileHeight / middleHeight;
            int remainderHeight = tileHeight - tileHeightCount * middleHeight;
            GL11.glEnable((int)3553);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resourceLocation);
            for (tileW = 0; tileW <= tileWidthCount; ++tileW) {
                tileWidthSize = tileW == tileWidthCount ? remainderWidth : middleWidth;
                int x = xOffset + sliceLeft + tileW * middleWidth;
                for (int tileH2 = 0; tileH2 <= tileHeightCount; ++tileH2) {
                    int tileHeightSize2 = tileH2 == tileHeightCount ? remainderHeight : middleHeight;
                    this.drawModalRectWithCustomSizedTexture(x, yOffset + sliceTop + tileH2 * middleHeight, sliceLeft, sliceTop, tileWidthSize, tileHeightSize2);
                }
            }
            if (sliceTop > 0) {
                for (tileW = 0; tileW <= tileWidthCount; ++tileW) {
                    tileWidthSize = tileW == tileWidthCount ? remainderWidth : middleWidth;
                    this.drawModalRectWithCustomSizedTexture(xOffset + sliceLeft + tileW * middleWidth, yOffset, sliceLeft, 0, tileWidthSize, sliceTop);
                }
            }
            if (sliceBottom > 0) {
                for (tileW = 0; tileW <= tileWidthCount; ++tileW) {
                    tileWidthSize = tileW == tileWidthCount ? remainderWidth : middleWidth;
                    this.drawModalRectWithCustomSizedTexture(xOffset + sliceLeft + tileW * middleWidth, yOffset + sliceTop + tileHeight, sliceLeft, sliceTop + middleHeight, tileWidthSize, sliceBottom);
                }
            }
            if (sliceLeft > 0) {
                for (tileH = 0; tileH <= tileHeightCount; ++tileH) {
                    tileHeightSize = tileH == tileHeightCount ? remainderHeight : middleHeight;
                    this.drawModalRectWithCustomSizedTexture(xOffset, yOffset + sliceTop + tileH * middleHeight, 0, sliceTop, sliceLeft, tileHeightSize);
                }
            }
            if (sliceRight > 0) {
                for (tileH = 0; tileH <= tileHeightCount; ++tileH) {
                    tileHeightSize = tileH == tileHeightCount ? remainderHeight : middleHeight;
                    this.drawModalRectWithCustomSizedTexture(xOffset + sliceLeft + tileWidth, yOffset + sliceTop + tileH * middleHeight, sliceLeft + middleWidth, sliceTop, sliceRight, tileHeightSize);
                }
            }
            if (sliceLeft > 0 && sliceTop > 0) {
                this.drawModalRectWithCustomSizedTexture(xOffset, yOffset, 0, 0, sliceLeft, sliceTop);
            }
            if (sliceRight > 0 && sliceTop > 0) {
                this.drawModalRectWithCustomSizedTexture(xOffset + sliceLeft + tileWidth, yOffset, sliceLeft + middleWidth, 0, sliceRight, sliceTop);
            }
            if (sliceLeft > 0 && sliceBottom > 0) {
                this.drawModalRectWithCustomSizedTexture(xOffset, yOffset + sliceTop + tileHeight, 0, sliceTop + middleHeight, sliceLeft, sliceBottom);
            }
            if (sliceRight > 0 && sliceBottom > 0) {
                this.drawModalRectWithCustomSizedTexture(xOffset + sliceLeft + tileWidth, yOffset + sliceTop + tileHeight, sliceLeft + middleWidth, sliceTop + middleHeight, sliceRight, sliceBottom);
            }
            if (!is2DTexture) {
                GL11.glDisable((int)3553);
            }
        }
    }

    private void drawModalRectWithCustomSizedTexture(int xOffset, int yOffset, int u, int v, int width, int height) {
        Gui.func_146110_a((int)(xOffset + this.paddingLeft), (int)(yOffset + this.paddingTop), (float)(this.x + u), (float)(this.y + v), (int)width, (int)height, (float)this.textureWidth, (float)this.textureHeight);
    }
}

