/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.Button;
import codechicken.nei.GuiNEIButton;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.RecipeSearchField;
import codechicken.nei.RestartableTask;
import codechicken.nei.SearchField;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.IGuiContainerOverlay;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.TaggedInventoryArea;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.filter.AllMultiRecipeFilter;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.guihook.IGuiClientSide;
import codechicken.nei.guihook.IGuiHandleMouseWheel;
import codechicken.nei.recipe.AcceptsFollowingTooltipLineHandler;
import codechicken.nei.recipe.ContainerRecipe;
import codechicken.nei.recipe.GuiFavoriteButton;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.GuiRecipeCatalyst;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.GuiRecipeTabs;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.recipe.SearchRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public abstract class GuiRecipe<H extends IRecipeHandler>
extends GuiContainer
implements IGuiContainerOverlay,
IGuiClientSide,
IGuiHandleMouseWheel,
IContainerTooltipHandler,
INEIGuiHandler {
    private static final int BG_TOP_HEIGHT = 6;
    private static final int BG_MIDDLE_HEIGHT = 154;
    private static final int BG_BOTTOM_HEIGHT = 6;
    private static final int BG_TOP_Y = 0;
    private static final int BG_MIDDLE_Y = 6;
    private static final int BG_BOTTOM_Y = 160;
    private static final int BORDER_PADDING = 6;
    private static final int BUTTON_WIDTH = 13;
    private static final int BUTTON_HEIGHT = 12;
    public static final List<IRecipeFilter.IRecipeFilterProvider> recipeFilterers = new LinkedList<IRecipeFilter.IRecipeFilterProvider>();
    protected boolean limitToOneRecipe = false;
    protected AcceptsFollowingTooltipLineHandler acceptsFollowingTooltipLineHandler;
    final DrawableResource bgTop = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 0, 176, 6).build();
    final DrawableResource bgMiddle = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 6, 176, 154).build();
    final DrawableResource bgBottom = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 160, 176, 6).build();
    public ArrayList<H> currenthandlers = new ArrayList();
    public int page;
    public int recipetype;
    private Recipe.RecipeId recipeId;
    public ContainerRecipe slotcontainer;
    public GuiContainer firstGui;
    public GuiScreen firstGuiGeneral;
    public GuiScreen prevGui;
    public GuiButton nextpage;
    public GuiButton prevpage;
    private GuiButton nexttype;
    private GuiButton prevtype;
    @Deprecated
    private GuiOverlayButton[] overlayButtons = new GuiOverlayButton[0];
    private final List<GuiRecipeButton> recipeButtons = new ArrayList<GuiRecipeButton>();
    private String recipePageCacheKey = "";
    private final Rectangle area = new Rectangle();
    private final GuiRecipeTabs recipeTabs = new GuiRecipeTabs(this);
    private final GuiRecipeCatalyst guiRecipeCatalyst = new GuiRecipeCatalyst(this);
    private SearchRecipeHandler<H> handler;
    private HandlerInfo handlerInfo;
    private int yShift = 0;
    protected static final RestartableTask updateFilter = new RestartableTask("NEI Recipe Filtering"){

        @Override
        public void execute() {
            GuiRecipe guiRecipe;
            SearchRecipeHandler searchHandler;
            GuiScreen currentScreen = NEIClientUtils.mc().currentScreen;
            if (currentScreen instanceof GuiRecipe && (searchHandler = (guiRecipe = (GuiRecipe)currentScreen).handler) != null && searchHandler.searchingAvailable()) {
                if (searchField.text().isEmpty()) {
                    searchHandler.setSearchIndices(null);
                    guiRecipe.changePage(0);
                } else {
                    IRecipeFilter filter = searchField.getRecipeFilter();
                    List<Integer> filtered = searchHandler.getSearchResult(filter);
                    if (filtered == null) {
                        this.stop();
                    }
                    if (this.interrupted()) {
                        return;
                    }
                    searchHandler.setSearchIndices(filtered);
                    guiRecipe.changePage(0);
                }
            }
        }
    };
    protected static final RecipeSearchField searchField = new RecipeSearchField(""){

        @Override
        protected boolean noResults() {
            GuiScreen currentScreen = NEIClientUtils.mc().currentScreen;
            return !(currentScreen instanceof GuiRecipe) || ((GuiRecipe)currentScreen).numRecipes() > 0;
        }

        @Override
        public void onTextChange(String oldText) {
            updateFilter.restart();
        }
    };
    protected static final Button toggleSearch = new Button(){

        @Override
        public boolean onButtonPress(boolean rightclick) {
            if (rightclick) {
                return false;
            }
            if (searchField.isVisible()) {
                searchField.setText("");
                searchField.setFocus(false);
                searchField.setVisible(false);
                this.state = 0;
            } else {
                searchField.setVisible(true);
                searchField.setFocus(true);
                this.state = 2;
            }
            return true;
        }
    };
    private boolean isHeightHackApplied = false;

    protected GuiRecipe(GuiScreen prevgui) {
        super((Container)new ContainerRecipe());
        this.slotcontainer = (ContainerRecipe)this.inventorySlots;
        this.prevGui = prevgui;
        this.firstGuiGeneral = prevgui;
        if (prevgui instanceof GuiContainer) {
            this.firstGui = (GuiContainer)prevgui;
        }
        if (prevgui instanceof IGuiContainerOverlay) {
            IGuiContainerOverlay gui = (IGuiContainerOverlay)prevgui;
            this.firstGui = gui.getFirstScreen();
            this.firstGuiGeneral = gui.getFirstScreenGeneral();
        }
    }

    public void limitToOneRecipe() {
        this.limitToOneRecipe = true;
    }

    public boolean isLimitedToOneRecipe() {
        return this.limitToOneRecipe;
    }

    public void initGui() {
        this.xSize = 176;
        this.ySize = Math.min(Math.max(this.height - 68, 166), 370);
        if (!this.limitToOneRecipe) {
            super.initGui();
        } else {
            this.guiLeft = (this.width - this.xSize) / 2;
            this.ySize = this.getWidgetSize().height;
            this.mc = NEIClientUtils.mc();
            this.fontRendererObj = this.mc.fontRenderer;
            ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
            this.width = scaledresolution.getScaledWidth();
            this.height = scaledresolution.getScaledHeight();
        }
        this.guiTop = (this.height - this.ySize) / 2 + 10;
        if (this.handler == null) {
            this.setRecipePage(this.recipetype);
        }
        this.checkYShift();
        int rightButtonX = this.guiLeft + this.xSize - 6 - 13;
        int leftButtonX = this.guiLeft + 6;
        this.nexttype = new GuiNEIButton(0, leftButtonX, this.guiTop + 3, 13, 12, "<"){

            public void mouseReleased(int mouseX, int mouseY) {
                GuiRecipe.this.prevType();
            }
        };
        this.prevtype = new GuiNEIButton(1, rightButtonX, this.guiTop + 3, 13, 12, ">"){

            public void mouseReleased(int mouseX, int mouseY) {
                GuiRecipe.this.nextType();
            }
        };
        this.nextpage = new GuiNEIButton(2, leftButtonX, this.guiTop + 17, 13, 12, "<"){

            public void mouseReleased(int mouseX, int mouseY) {
                GuiRecipe.this.prevPage();
            }
        };
        this.prevpage = new GuiNEIButton(3, rightButtonX, this.guiTop + 17, 13, 12, ">"){

            public void mouseReleased(int mouseX, int mouseY) {
                GuiRecipe.this.nextPage();
            }
        };
        GuiRecipe.toggleSearch.icon = new DrawableBuilder("nei:textures/nei_sprites.png", 0, 76, 10, 10).build();
        this.buttonList.addAll(Arrays.asList(this.nexttype, this.prevtype, this.nextpage, this.prevpage));
        this.recipeButtons.clear();
        this.recipePageCacheKey = "";
        if (this.currenthandlers.size() == 1) {
            this.nexttype.visible = false;
            this.prevtype.visible = false;
        }
        this.recipeTabs.initLayout();
        this.refreshPage();
    }

    private void updateRecipePage() {
        String cacheKey;
        List<Integer> indices = this.getRecipeIndices();
        String string = cacheKey = indices.isEmpty() ? "" : this.handlerInfo.getHandlerName() + ":" + indices.get(0) + ":" + indices.get(indices.size() - 1);
        if (!cacheKey.equals(this.recipePageCacheKey)) {
            this.recipePageCacheKey = cacheKey;
            for (int recipeIndex : indices) {
                for (PositionedStack pStack : this.handler.original.getIngredientStacks(recipeIndex)) {
                    pStack.setPermutationToRender(pStack.getFilteredPermutations().get(0));
                }
            }
            int xOffset = (this.limitToOneRecipe ? 0 : this.guiLeft) + this.xSize - 6;
            int yOffset = (this.limitToOneRecipe ? -12 : this.guiTop - 18) + this.getRefIndexPosition((int)0).y;
            int height = this.handlerInfo.getHeight() - this.yShift;
            boolean showFavorites = NEIClientConfig.favoritesEnabled() && this.handlerInfo.getShowFavoritesButton();
            boolean showOverlay = this.handlerInfo.getShowOverlayButton();
            GuiRecipeButton.UpdateRecipeButtonsEvent.Pre preEvent = new GuiRecipeButton.UpdateRecipeButtonsEvent.Pre(this, xOffset, yOffset, height, this.handlerInfo);
            List<GuiRecipeButton> buttons = new ArrayList();
            if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
                buttons = preEvent.buttonList;
            } else {
                for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
                    int recipeIndex = indices.get(refIndex);
                    if (this.handler.original.getResultStack(recipeIndex) == null && this.handler.original.getOtherStacks(recipeIndex).isEmpty()) continue;
                    int x = xOffset - 12;
                    int y = yOffset + height * (refIndex + 1);
                    if (showOverlay) {
                        buttons.add(new GuiOverlayButton(this.firstGui, RecipeHandlerRef.of(this.handler.original, recipeIndex), x, y));
                        y -= 13;
                    }
                    if (!showFavorites) continue;
                    buttons.add(new GuiFavoriteButton(RecipeHandlerRef.of(this.handler.original, recipeIndex), x, y));
                }
                if (this.equals(this.mc.currentScreen)) {
                    GuiRecipeButton.UpdateRecipeButtonsEvent.Post postEvent = new GuiRecipeButton.UpdateRecipeButtonsEvent.Post(this, buttons);
                    MinecraftForge.EVENT_BUS.post((Event)postEvent);
                    buttons = postEvent.buttonList;
                }
            }
            if (!showFavorites) {
                buttons.removeIf(GuiFavoriteButton.class::isInstance);
            }
            if (!showOverlay) {
                buttons.removeIf(GuiOverlayButton.class::isInstance);
            }
            this.overlayButtons = (GuiOverlayButton[])buttons.stream().filter(GuiOverlayButton.class::isInstance).toArray(GuiOverlayButton[]::new);
            this.buttonList.removeIf(this.recipeButtons::contains);
            this.recipeButtons.clear();
            this.recipeButtons.addAll(buttons);
            this.buttonList.addAll(buttons);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRecipeFilter getRecipeListFilter() {
        if (recipeFilterers.isEmpty()) {
            return null;
        }
        AllMultiRecipeFilter recipeFilter = new AllMultiRecipeFilter();
        List<IRecipeFilter.IRecipeFilterProvider> list = recipeFilterers;
        synchronized (list) {
            for (IRecipeFilter.IRecipeFilterProvider p : recipeFilterers) {
                IRecipeFilter filter = p.getRecipeFilter();
                if (filter == null) continue;
                recipeFilter.filters.add(filter);
            }
        }
        return recipeFilter.filters.size() == 1 ? recipeFilter.filters.get(0) : recipeFilter;
    }

    public static ItemFilter getSearchItemFilter() {
        return searchField.getFilter();
    }

    private void checkYShift() {
        this.yShift = this.handlerInfo == null ? 0 : this.handlerInfo.getYShift();
    }

    public void setRecipePage(int idx) {
        this.setRecipePage(idx, 0);
    }

    public void setRecipePage(int idx, int refIndex) {
        this.recipetype = (this.currenthandlers.size() + idx) % this.currenthandlers.size();
        this.handler = new SearchRecipeHandler<IRecipeHandler>((IRecipeHandler)this.currenthandlers.get(this.recipetype));
        this.handlerInfo = GuiRecipeTab.getHandlerInfo(this.handler.original);
        if (!this.limitToOneRecipe) {
            searchField.setText("");
            searchField.setVisible(false);
            GuiRecipe.toggleSearch.state = 0;
        }
        this.page = Math.min(Math.max(0, refIndex), this.numRecipes() - 1) / this.getRecipesPerPage();
        this.changePage(0);
        this.recipeTabs.calcPageNumber();
        this.checkYShift();
    }

    public List<GuiRecipeButton> getRecipeButtons() {
        return Collections.unmodifiableList(this.recipeButtons);
    }

    public List<GuiButton> getOverlayButtons() {
        return Collections.unmodifiableList(Arrays.asList((GuiButton[])this.recipeButtons.stream().filter(GuiOverlayButton.class::isInstance).toArray(GuiButton[]::new)));
    }

    public int openTargetRecipe(Recipe.RecipeId recipeId) {
        int refIndex = -1;
        int recipetype = 0;
        this.recipeId = recipeId;
        if (this.recipeId != null) {
            for (int j = 0; j < this.currenthandlers.size(); ++j) {
                IRecipeHandler localHandler = (IRecipeHandler)this.currenthandlers.get(j);
                HandlerInfo localHandlerInfo = GuiRecipeTab.getHandlerInfo(localHandler);
                if (!localHandlerInfo.getHandlerName().equals(this.recipeId.getHandleName())) continue;
                recipetype = j;
                if (this.recipeId.getIngredients().isEmpty()) break;
                refIndex = SearchRecipeHandler.findFirst(localHandler, recipeIndex -> this.recipeId.equalsIngredients(localHandler.getIngredientStacks(recipeIndex)));
                break;
            }
        }
        this.setRecipePage(recipetype, Math.max(0, refIndex));
        return refIndex;
    }

    public Recipe getFocusedRecipe() {
        List<Integer> indices = this.getRecipeIndices();
        for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
            int recipeIndex = indices.get(refIndex);
            if (!this.recipeInFocus(refIndex, recipeIndex)) continue;
            return Recipe.of(this.handler.original, recipeIndex);
        }
        return null;
    }

    protected boolean recipeInFocus(int refIndex, int recipeIndex) {
        PositionedStack result = this.handler.original.getResultStack(recipeIndex);
        if (result != null && this.isMouseOver(result, refIndex)) {
            return true;
        }
        List<PositionedStack> stacks = this.handler.original.getOtherStacks(recipeIndex);
        for (PositionedStack stack : stacks) {
            if (!this.isMouseOver(stack, refIndex)) continue;
            return true;
        }
        return false;
    }

    public boolean isMouseOver(PositionedStack stack, int refIndex) {
        Slot mouseoverSlot;
        Point p = this.getRefIndexPosition(refIndex);
        Point mousepos = GuiDraw.getMousePosition();
        Slot stackSlot = this.slotcontainer.getSlotWithStack(stack, p.x, p.y);
        return stackSlot == (mouseoverSlot = this.getSlotAtPosition(mousepos.x, mousepos.y));
    }

    public String getHandlerName() {
        return this.handlerInfo.getHandlerName();
    }

    public H getHandler() {
        return this.handler.original;
    }

    public List<Integer> getRecipeIndices() {
        int recipesPerPage = this.getRecipesPerPage();
        int minIndex = this.page * recipesPerPage;
        int maxIndex = Math.min(this.numRecipes(), (this.page + 1) * recipesPerPage);
        ArrayList<Integer> range = new ArrayList<Integer>();
        for (int index = minIndex; index < maxIndex; ++index) {
            range.add(this.handler.ref(index));
        }
        return range;
    }

    private int numRecipes() {
        return this.handler == null ? 0 : this.handler.numRecipes();
    }

    public void keyTyped(char c, int i) {
        if (searchField.isVisible() && searchField.focused() && searchField.handleKeyPress(i, c)) {
            return;
        }
        if (i == 1) {
            this.mc.displayGuiScreen(this.firstGuiGeneral);
            NEICPH.sendRequestContainer();
            return;
        }
        if (searchField.isVisible() && searchField.focused()) {
            searchField.lastKeyTyped(i, c);
            return;
        }
        if (GuiContainerManager.getManager(this).lastKeyTyped(i, c)) {
            return;
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (int recipeIndex : this.getRecipeIndices()) {
                if (!this.handler.original.keyTyped(this, c, i, recipeIndex)) continue;
                return;
            }
            Point mouse = GuiDraw.getMousePosition();
            for (GuiRecipeButton button : this.recipeButtons) {
                if (!button.contains(mouse.x, mouse.y)) continue;
                button.lastKeyTyped(this, c, i);
            }
        }
        if (i == this.mc.gameSettings.keyBindInventory.getKeyCode()) {
            this.mc.displayGuiScreen(this.firstGuiGeneral);
            NEICPH.sendRequestContainer();
        } else if (NEIClientConfig.isKeyHashDown("gui.back")) {
            this.mc.displayGuiScreen(this.prevGui);
        } else if (NEIClientConfig.isKeyHashDown("gui.prev_machine")) {
            this.prevType();
        } else if (NEIClientConfig.isKeyHashDown("gui.next_machine")) {
            this.nextType();
        } else if (NEIClientConfig.isKeyHashDown("gui.prev_recipe")) {
            this.prevPage();
        } else if (NEIClientConfig.isKeyHashDown("gui.next_recipe")) {
            this.nextPage();
        }
    }

    protected void mouseClicked(int mousex, int mousey, int button) {
        if (!this.limitToOneRecipe && this.handler != null && this.handler.searchingAvailable()) {
            if (toggleSearch.contains(mousex - this.guiLeft, mousey - this.guiTop)) {
                toggleSearch.handleClick(mousex - this.guiLeft, mousey - this.guiTop, button);
            } else if (searchField.contains(mousex - this.guiLeft, mousey - this.guiTop)) {
                searchField.handleClick(mousex - this.guiLeft, mousey - this.guiTop, button);
            } else {
                searchField.onGuiClick(mousex - this.guiLeft, mousey - this.guiTop);
            }
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (int recipeIndex : this.getRecipeIndices()) {
                if (!this.handler.original.mouseClicked(this, button, recipeIndex)) continue;
                return;
            }
        }
        if (this.recipeTabs.mouseClicked(mousex, mousey, button)) {
            return;
        }
        super.mouseClicked(mousex, mousey, button);
    }

    @Override
    public void mouseScrolled(int scroll) {
        if (this.recipeTabs.mouseScrolled(scroll)) {
            return;
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            Point mouse = GuiDraw.getMousePosition();
            for (GuiRecipeButton button : this.recipeButtons) {
                if (!button.contains(mouse.x, mouse.y) || !button.mouseScrolled(this, scroll)) continue;
                return;
            }
            Iterator<Object> iterator = this.getRecipeIndices().iterator();
            while (iterator.hasNext()) {
                int recipeIndex = (Integer)iterator.next();
                if (!this.handler.original.mouseScrolled(this, scroll, recipeIndex)) continue;
                return;
            }
        }
        if (NEIClientUtils.shiftKey()) {
            if (scroll < 0) {
                this.nextType();
            } else {
                this.prevType();
            }
            return;
        }
        if (new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize).contains(GuiDraw.getMousePosition())) {
            if (scroll > 0) {
                this.prevPage();
            } else {
                this.nextPage();
            }
        }
    }

    public void updateScreen() {
        super.updateScreen();
        this.onUpdate();
    }

    public void onUpdate() {
        this.handler.original.onUpdate();
        if (this.limitToOneRecipe) {
            this.refreshSlots();
        } else {
            this.refreshPage();
        }
    }

    @Override
    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        String s;
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            Iterator<Object> iterator = this.getRecipeIndices().iterator();
            while (iterator.hasNext()) {
                int recipeIndex = iterator.next();
                currenttip = this.handler.original.handleTooltip(this, currenttip, recipeIndex);
            }
            for (GuiRecipeButton button : this.recipeButtons) {
                if (!button.contains(mousex, mousey)) continue;
                currenttip = button.handleTooltip(this, currenttip);
            }
        }
        this.recipeTabs.handleTooltip(mousex, mousey, currenttip);
        if (currenttip.isEmpty() && searchField.isVisible() && new Rectangle(GuiRecipe.searchField.x + GuiRecipe.searchField.w, 15, 44, 16).contains(mousex - this.guiLeft, mousey - this.guiTop) && this.fontRendererObj.getStringWidth(s = String.format("%d/%d", this.page + 1, (this.numRecipes() - 1) / this.getRecipesPerPage() + 1)) >= 45) {
            currenttip.add(s);
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        List<Integer> indices = this.getRecipeIndices();
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (int recipeIndex : indices) {
                currenttip = this.handler.original.handleItemTooltip(this, itemstack, currenttip, recipeIndex);
            }
        }
        if (NEIClientConfig.showCycledIngredientsTooltip() && itemstack != null) {
            PositionedStack hovered = null;
            block6: for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
                int recipeIndex;
                recipeIndex = indices.get(refIndex);
                List<List> stackGroups = Arrays.asList(this.handler.original.getIngredientStacks(recipeIndex), this.handler.original.getOtherStacks(recipeIndex));
                for (List group : stackGroups) {
                    for (PositionedStack pStack : group) {
                        if (!this.isMouseOver(pStack, refIndex)) continue;
                        hovered = pStack;
                        break block6;
                    }
                }
            }
            if (hovered == null || hovered.items.length <= 1) {
                this.acceptsFollowingTooltipLineHandler = null;
            } else if (this.acceptsFollowingTooltipLineHandler == null || this.acceptsFollowingTooltipLineHandler.tooltipGUID != hovered) {
                this.acceptsFollowingTooltipLineHandler = AcceptsFollowingTooltipLineHandler.of(hovered, hovered.getFilteredPermutations(), hovered.item);
            }
        } else if (this.acceptsFollowingTooltipLineHandler != null) {
            this.acceptsFollowingTooltipLineHandler = null;
        }
        if (this.acceptsFollowingTooltipLineHandler != null) {
            this.acceptsFollowingTooltipLineHandler.setActiveStack(((PositionedStack)this.acceptsFollowingTooltipLineHandler.tooltipGUID).item);
            currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.acceptsFollowingTooltipLineHandler));
        }
        return currenttip;
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (GuiRecipeButton button : this.recipeButtons) {
                if (!button.contains(mousex, mousey)) continue;
                hotkeys = button.handleHotkeys(gui, mousex, mousey, hotkeys);
            }
        }
        if (this.acceptsFollowingTooltipLineHandler != null) {
            hotkeys.put(NEIClientUtils.getKeyName(0x4000000, -2013265920), NEIClientUtils.translate("recipe.accepts.scroll", new Object[0]));
        }
        return hotkeys;
    }

    @Override
    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
        return currenttip;
    }

    private void nextPage() {
        this.changePage(1);
    }

    private void prevPage() {
        this.changePage(-1);
    }

    protected void nextType() {
        this.setRecipePage(++this.recipetype);
    }

    protected void prevType() {
        this.setRecipePage(--this.recipetype);
    }

    protected void changePage(int shift) {
        int recipesPerPage = this.getRecipesPerPage();
        int numRecipes = this.numRecipes();
        if (numRecipes > 0) {
            int numPages = (int)Math.ceil((float)numRecipes / (float)recipesPerPage);
            this.page = Math.min(Math.max(0, this.page), numPages);
            this.page = (numPages + this.page + shift) % numPages;
        } else {
            this.page = 0;
        }
    }

    public void refreshPage() {
        this.changePage(0);
        int recipesPerPage = this.getRecipesPerPage();
        boolean multiplepages = this.numRecipes() > recipesPerPage;
        int numRecipes = Math.min(this.numRecipes() - this.page * recipesPerPage, recipesPerPage);
        this.area.width = this.handlerInfo.getWidth();
        this.area.height = this.handlerInfo.getHeight() * numRecipes;
        this.area.x = this.guiLeft - 2;
        this.area.y = this.guiTop - 4 + this.yShift;
        this.checkYShift();
        if (!this.limitToOneRecipe) {
            RecipeCatalysts.updatePosition(this.ySize - 6 - 12);
            GuiRecipe.toggleSearch.h = 12;
            GuiRecipe.toggleSearch.w = 12;
            GuiRecipe.toggleSearch.x = 19;
            GuiRecipe.toggleSearch.y = 17;
            GuiRecipe.searchField.y = 16;
            GuiRecipe.searchField.x = 19 + GuiRecipe.toggleSearch.w - 1;
            GuiRecipe.searchField.w = this.xSize - 38 + 1 - GuiRecipe.toggleSearch.w - 45;
            GuiRecipe.searchField.h = 14;
        }
        this.nextpage.enabled = this.prevpage.enabled = multiplepages;
        this.updateRecipePage();
        this.refreshSlots();
        this.recipeTabs.refreshPage();
    }

    private void refreshSlots() {
        this.slotcontainer.inventorySlots.clear();
        List<Integer> indices = this.getRecipeIndices();
        for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
            int recipeIndex = indices.get(refIndex);
            Point p = this.getRefIndexPosition(refIndex);
            if (this.isHeightHackApplied) {
                p.translate(0, 16);
            }
            TemplateRecipeHandler.disableCycledIngredients = false;
            for (PositionedStack stack : this.handler.original.getIngredientStacks(recipeIndex)) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            for (PositionedStack stack : this.handler.original.getOtherStacks(recipeIndex)) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            PositionedStack result = this.handler.original.getResultStack(recipeIndex);
            if (result != null) {
                this.slotcontainer.addSlot(result, p.x, p.y);
            }
            if (!this.limitToOneRecipe) {
                for (PositionedStack catalyst : RecipeCatalysts.getRecipeCatalysts(this.handler.original)) {
                    int xOffset = -15;
                    int yOffset = 6;
                    this.slotcontainer.addSlot(catalyst, xOffset, yOffset);
                }
            }
            TemplateRecipeHandler.disableCycledIngredients = true;
        }
    }

    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int ySkip;
        GuiContainerManager.enable2DRender();
        int recipesPerPage = this.getRecipesPerPage();
        int n = ySkip = this.limitToOneRecipe ? 7 : 32;
        if (!this.limitToOneRecipe) {
            String s = this.handler.original.getRecipeName().trim();
            this.fontRendererObj.drawStringWithShadow(s, (this.xSize - this.fontRendererObj.getStringWidth(s)) / 2, 5, 0xFFFFFF);
            if (this.handler.searchingAvailable()) {
                toggleSearch.draw(mouseX - this.guiLeft, mouseY - this.guiTop);
            }
            if (searchField.isVisible()) {
                searchField.draw(mouseX - this.guiLeft, mouseY - this.guiTop);
                s = NEIClientUtils.cropText(this.fontRendererObj, String.format("%d/%d", this.page + 1, (this.numRecipes() - 1) / recipesPerPage + 1), 45);
                this.fontRendererObj.drawStringWithShadow(s, GuiRecipe.searchField.x + GuiRecipe.searchField.w + (44 - this.fontRendererObj.getStringWidth(s)) / 2, 19, 0xFFFFFF);
            } else {
                s = NEIClientUtils.translate("recipe.page", this.page + 1, (this.numRecipes() - 1) / recipesPerPage + 1);
                this.fontRendererObj.drawStringWithShadow(s, (this.xSize - this.fontRendererObj.getStringWidth(s)) / 2, 19, 0xFFFFFF);
            }
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            List<Integer> indices = this.getRecipeIndices();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)5.0f, (float)(ySkip + this.yShift), (float)0.0f);
            for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
                GuiOverlayButton overlayButton;
                int recipeIndex = indices.get(refIndex);
                this.handler.original.drawForeground(recipeIndex);
                if (this.limitToOneRecipe && (overlayButton = (GuiOverlayButton)this.recipeButtons.stream().filter(b -> b instanceof GuiOverlayButton && b.handlerRef.recipeIndex == recipeIndex).findAny().orElse(null)) != null && overlayButton.enabled) {
                    overlayButton.drawItemOverlay();
                }
                GL11.glTranslatef((float)0.0f, (float)this.handlerInfo.getHeight(), (float)0.0f);
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)5.0f, (float)(ySkip + this.yShift), (float)0.0f);
            if (!this.limitToOneRecipe) {
                for (GuiRecipeButton button : this.recipeButtons) {
                    if (!button.contains(mouseX, mouseY)) continue;
                    GL11.glTranslatef((float)0.0f, (float)(this.handlerInfo.getHeight() * indices.indexOf(button.handlerRef.recipeIndex)), (float)0.0f);
                    button.drawItemOverlay();
                    break;
                }
            }
            GL11.glPopMatrix();
        }
    }

    public void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        int ySkip = this.limitToOneRecipe ? 7 : 32;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundTiled(this.guiLeft, this.guiTop);
        if (NEIClientConfig.areJEIStyleTabsVisible() && !this.limitToOneRecipe) {
            GuiRecipe.drawRect((int)(this.guiLeft + 6 + 13 - 1), (int)this.nexttype.yPosition, (int)(this.guiLeft + this.xSize - 6 - 13), (int)(this.nexttype.yPosition + 12), (int)0x30000000);
            GuiRecipe.drawRect((int)(this.guiLeft + 6 + 13 - 1), (int)this.nextpage.yPosition, (int)(this.guiLeft + this.xSize - 6 - 13), (int)(this.nextpage.yPosition + 12), (int)0x30000000);
            RenderHelper.enableGUIStandardItemLighting();
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
            this.recipeTabs.draw(mouseX, mouseY);
            if (NEIClientConfig.areJEIStyleRecipeCatalystsVisible()) {
                this.guiRecipeCatalyst.draw();
            }
            RenderHelper.disableStandardItemLighting();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.guiLeft + 5), (float)(this.guiTop + ySkip + this.yShift), (float)0.0f);
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (int recipeIndex : this.getRecipeIndices()) {
                this.handler.original.drawBackground(recipeIndex);
                GL11.glTranslatef((float)0.0f, (float)this.handlerInfo.getHeight(), (float)0.0f);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawBackgroundTiled(int j, int k) {
        int handlerHeight = this.getWidgetSize().height;
        this.bgTop.draw(j, k + 0);
        int tiledHeight = handlerHeight - 6 - 6;
        if (tiledHeight > 0) {
            int yTileCount = tiledHeight / 154;
            int yRemainder = tiledHeight - yTileCount * 154;
            int yStart = k + 6 + tiledHeight;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tileHeight = yTile == yTileCount ? yRemainder : 154;
                int y = yStart - (yTile + 1) * 154;
                if (tileHeight <= 0) continue;
                this.bgMiddle.draw(j, y, 154 - tileHeight, 0, 0, 0);
            }
        }
        this.bgBottom.draw(j, k + handlerHeight - 6);
    }

    public Dimension getWidgetSize() {
        if (this.handlerInfo == null) {
            return new Dimension(this.xSize, this.ySize);
        }
        int handlerHeight = this.limitToOneRecipe ? this.handlerInfo.getHeight() + this.yShift + 6 + 6 : this.ySize;
        return new Dimension(this.xSize, handlerHeight);
    }

    @Override
    public GuiContainer getFirstScreen() {
        return this.firstGui;
    }

    @Override
    public GuiScreen getFirstScreenGeneral() {
        return this.firstGuiGeneral;
    }

    private int getRecipesPerPage() {
        return this.limitToOneRecipe ? 1 : this.getRecipesPerPage(this.handlerInfo);
    }

    private int getRecipesPerPage(HandlerInfo handlerInfo) {
        if (handlerInfo != null) {
            return Math.max(Math.min((this.ySize - 36) / handlerInfo.getHeight(), handlerInfo.getMaxRecipesPerPage()), 1);
        }
        if (this.handler != null) {
            return this.handler.original.recipiesPerPage();
        }
        return 1;
    }

    public Point getRecipePosition(int recipe) {
        return this.getRefIndexPosition(this.getRecipeIndices().indexOf(recipe));
    }

    protected Point getRefIndexPosition(int refIndex) {
        return new Point(5, (this.isHeightHackApplied ? 16 : 32) - (this.limitToOneRecipe ? 25 : 0) + this.yShift + refIndex % this.getRecipesPerPage() * this.handlerInfo.getHeight());
    }

    public abstract ArrayList<H> getCurrentRecipeHandlers();

    @Override
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    @Override
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    @Override
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    @Override
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        if (searchField.isVisible() && searchField.contains(mousex - this.guiLeft, mousey - this.guiTop)) {
            searchField.setText(SearchField.getEscapedSearchText(draggedStack));
            return true;
        }
        return false;
    }

    @Override
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return this.area.intersects(x, y, w, h);
    }

    protected static Recipe.RecipeId getCurrentRecipeId(GuiScreen gui) {
        if (gui instanceof GuiRecipe) {
            GuiRecipe gRecipe = (GuiRecipe)gui;
            if (gRecipe.handler.numRecipes() > 0) {
                List<Integer> indices = gRecipe.getRecipeIndices();
                int curRecipe = indices.isEmpty() ? 0 : indices.get(0);
                Recipe recipe = Recipe.of(gRecipe.handler.original, curRecipe);
                return recipe != null ? recipe.getRecipeId() : null;
            }
        }
        return null;
    }

    private class CompatibilityHacks
    implements AutoCloseable {
        private final int trueHeight;
        private final int trueGuiTop;
        private final GuiScreen trueGui;

        private CompatibilityHacks() {
            this.trueHeight = GuiRecipe.this.height;
            this.trueGuiTop = GuiRecipe.this.guiTop;
            GuiRecipe.this.isHeightHackApplied = NEIClientConfig.heightHackHandlerRegex.stream().map(pattern -> pattern.matcher(((GuiRecipe)GuiRecipe.this).handler.original.getHandlerId())).anyMatch(Matcher::matches);
            if (GuiRecipe.this.isHeightHackApplied) {
                GuiRecipe.this.guiTop += 16;
                GuiRecipe.this.height = 2 * GuiRecipe.this.guiTop + 166;
            }
            this.trueGui = NEIClientUtils.mc().currentScreen;
            if (GuiRecipe.this.limitToOneRecipe) {
                NEIClientUtils.mc().currentScreen = GuiRecipe.this;
            }
        }

        @Override
        public void close() {
            GuiRecipe.this.guiTop = this.trueGuiTop;
            GuiRecipe.this.height = this.trueHeight;
            if (GuiRecipe.this.limitToOneRecipe && NEIClientUtils.mc().currentScreen == GuiRecipe.this) {
                NEIClientUtils.mc().currentScreen = this.trueGui;
            }
            GuiRecipe.this.isHeightHackApplied = false;
        }
    }
}

