/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemStackSet;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;

public class BrewingRecipeHandler
extends TemplateRecipeHandler {
    public static final ItemStackSet ingredients = new ItemStackSet();
    public static final HashSet<BrewingRecipe> apotions = new HashSet();
    private static ItemStack DRAGONS_BREATH = null;
    private static Item LINGERING_POTION_ITEM = null;

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(58, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(92, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(68, 23, 28, 18), "brewing", new Object[0]));
    }

    @Override
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBrewingStand.class;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.brewing", new Object[0]);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("brewing") && this.getClass() == BrewingRecipeHandler.class) {
            for (BrewingRecipe recipe : apotions) {
                this.arecipes.add(new CachedBrewingRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        boolean isLingering;
        if (result == null) {
            return;
        }
        Item out = result.getItem();
        boolean isPotion = out == Items.potionitem;
        boolean bl = isLingering = LINGERING_POTION_ITEM != null && out == LINGERING_POTION_ITEM;
        if (!isPotion && !isLingering) {
            return;
        }
        int damage = result.getItemDamage();
        apotions.stream().filter(recipe -> recipe.result.item.getItem() == out && recipe.result.item.getItemDamage() == damage).map(x$0 -> new CachedBrewingRecipe((BrewingRecipe)x$0)).collect(Collectors.toCollection(() -> this.arecipes));
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        boolean passIt;
        if (ingredient == null) {
            return;
        }
        boolean bl = passIt = ingredient.getItem() == Items.potionitem || LINGERING_POTION_ITEM != null && ingredient.getItem() == LINGERING_POTION_ITEM || ingredients.contains(ingredient);
        if (!passIt) {
            return;
        }
        apotions.stream().filter(recipe -> NEIServerUtils.areStacksSameType(recipe.ingredient.item, ingredient) || NEIServerUtils.areStacksSameType(recipe.precursorPotion.item, ingredient) || NEIServerUtils.areStacksSameType(recipe.result.item, ingredient)).map(x$0 -> new CachedBrewingRecipe((BrewingRecipe)x$0)).collect(Collectors.toCollection(() -> this.arecipes));
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/brewing_stand.png";
    }

    @Override
    public void drawExtras(int recipe) {
        this.drawProgressBar(92, 5, 176, 0, 8, 30, 120, 1);
        this.drawProgressBar(60, 1, 185, -2, 12, 30, 35, 3);
    }

    public static void searchPotions() {
        HashSet<Integer> newPotions;
        TreeSet<Integer> allPotions = new TreeSet<Integer>();
        HashSet<Integer> searchPotions = new HashSet<Integer>();
        searchPotions.add(0);
        allPotions.add(0);
        do {
            newPotions = new HashSet<Integer>();
            for (Integer basePotion : searchPotions) {
                if (ItemPotion.isSplash((int)basePotion)) continue;
                for (ItemStack ingred : ingredients.values()) {
                    int result = PotionHelper.applyIngredient((int)basePotion, (String)ingred.getItem().getPotionEffect(ingred));
                    if (ItemPotion.isSplash((int)result)) {
                        BrewingRecipeHandler.addPotion(ingred, basePotion, result, allPotions, newPotions);
                        continue;
                    }
                    List baseMods = Items.potionitem.getEffects(basePotion.intValue());
                    List newMods = Items.potionitem.getEffects(result);
                    if (basePotion > 0 && baseMods == newMods || baseMods != null && (baseMods.equals(newMods) || newMods == null) || basePotion == result || BrewingRecipeHandler.levelModifierChanged(basePotion, result)) continue;
                    BrewingRecipeHandler.addPotion(ingred, basePotion, result, allPotions, newPotions);
                }
            }
        } while (!(searchPotions = newPotions).isEmpty());
        API.setItemListEntries((Item)Items.potionitem, allPotions.stream().map(potionID -> new ItemStack((Item)Items.potionitem, 1, potionID.intValue())).collect(Collectors.toList()));
        API.addSubset("Items.Potions", new ItemStackSet().with(new Item[]{Items.potionitem}));
        API.addSubset("Items.Potions.Splash", item -> item.getItem() == Items.potionitem && (item.getItemDamage() & 0x4000) != 0);
        ItemStackSet positivepots = new ItemStackSet();
        ItemStackSet negativepots = new ItemStackSet();
        ItemStackSet neutralpots = new ItemStackSet();
        Iterator<Object> iterator = allPotions.iterator();
        while (iterator.hasNext()) {
            int potionID2 = (Integer)iterator.next();
            List effectlist = Items.potionitem.getEffects(potionID2);
            int type = 0;
            if (effectlist != null && !effectlist.isEmpty()) {
                for (PotionEffect potioneffect : effectlist) {
                    if (Potion.potionTypes[potioneffect.getPotionID()].isBadEffect()) {
                        --type;
                        continue;
                    }
                    ++type;
                }
            }
            (type == 0 ? neutralpots : (type > 0 ? positivepots : negativepots)).add(new ItemStack((Item)Items.potionitem, 1, potionID2));
        }
        API.addSubset("Items.Potions.Positive", positivepots);
        API.addSubset("Items.Potions.Negative", negativepots);
        API.addSubset("Items.Potions.Neutral", neutralpots);
        BrewingRecipeHandler.tryResolveEFRItems();
        if (DRAGONS_BREATH != null && LINGERING_POTION_ITEM != null) {
            ingredients.add(DRAGONS_BREATH.copy());
            ArrayList<BrewingRecipe> snapshot = new ArrayList<BrewingRecipe>(apotions);
            for (BrewingRecipe bgr : snapshot) {
                int meta;
                ItemStack splashOut;
                if (bgr == null || bgr.result == null || bgr.result.item == null || (splashOut = bgr.result.item).getItem() != Items.potionitem || !ItemPotion.isSplash((int)(meta = splashOut.getItemDamage()))) continue;
                int lingeringMeta = meta & 0xFFFFBFFF;
                ItemStack precursorSplash = splashOut.copy();
                ItemStack lingeringOut = new ItemStack(LINGERING_POTION_ITEM, 1, lingeringMeta);
                apotions.add(new BrewingRecipe(DRAGONS_BREATH, precursorSplash, lingeringOut));
            }
            List<ItemStack> allLingering = apotions.stream().map(lpr -> lpr.result != null ? lpr.result.item : null).filter(lps -> lps != null && lps.getItem() == LINGERING_POTION_ITEM).collect(Collectors.toList());
            if (!allLingering.isEmpty()) {
                API.setItemListEntries(LINGERING_POTION_ITEM, allLingering);
                API.addSubset("Items.Potions.Lingering", stack -> stack.getItem() == LINGERING_POTION_ITEM);
            }
        }
    }

    private static boolean levelModifierChanged(int basePotionID, int result) {
        int basemod = basePotionID & 0xE0;
        int resultmod = result & 0xE0;
        return basemod != 0 && basemod != resultmod;
    }

    private static void addPotion(ItemStack ingred, int basePotion, int result, TreeSet<Integer> allPotions, HashSet<Integer> newPotions) {
        apotions.add(new BrewingRecipe(ingred, basePotion, result));
        if (allPotions.add(result)) {
            newPotions.add(result);
        }
    }

    private static void tryResolveEFRItems() {
        if (DRAGONS_BREATH == null) {
            Item breath = (Item)Item.itemRegistry.getObject("etfuturum:dragon_breath");
            ItemStack itemStack = DRAGONS_BREATH = breath != null ? new ItemStack(breath) : null;
        }
        if (LINGERING_POTION_ITEM == null) {
            LINGERING_POTION_ITEM = (Item)Item.itemRegistry.getObject("etfuturum:lingering_potion");
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "brewing";
    }

    public static class BrewingRecipe {
        public PositionedStack precursorPotion;
        public PositionedStack result;
        public PositionedStack ingredient;

        public BrewingRecipe(ItemStack ingred, int basePotionID, int resultDamage) {
            this.precursorPotion = new PositionedStack(new ItemStack((Item)Items.potionitem, 1, basePotionID), 51, 35);
            this.ingredient = new PositionedStack(ingred, 74, 6);
            this.result = new PositionedStack(new ItemStack((Item)Items.potionitem, 1, resultDamage), 97, 35);
        }

        public BrewingRecipe(ItemStack ingred, ItemStack precursor, ItemStack resultStack) {
            this.precursorPotion = new PositionedStack(precursor, 51, 35);
            this.ingredient = new PositionedStack(ingred, 74, 6);
            this.result = new PositionedStack(resultStack, 97, 35);
        }
    }

    public class CachedBrewingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final BrewingRecipe recipe;

        public CachedBrewingRecipe(BrewingRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        public PositionedStack getResult() {
            return this.recipe.result;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.recipe.ingredient);
            recipestacks.add(this.recipe.precursorPotion);
            return recipestacks;
        }
    }
}

