/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.GuiNEIButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.RecipeHandlerRef;
import cpw.mods.fml.common.eventhandler.Cancelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiScreenEvent;

public abstract class GuiRecipeButton
extends GuiNEIButton {
    public static final int BUTTON_WIDTH = 12;
    public static final int BUTTON_HEIGHT = 12;
    public final RecipeHandlerRef handlerRef;

    protected GuiRecipeButton(RecipeHandlerRef point, int x, int y, int buttonId, String label) {
        super(buttonId, x, y, 12, 12, label);
        this.handlerRef = point;
    }

    abstract List<String> handleTooltip(GuiRecipe<?> var1, List<String> var2);

    abstract Map<String, String> handleHotkeys(GuiContainer var1, int var2, int var3, Map<String, String> var4);

    abstract void lastKeyTyped(GuiRecipe<?> var1, char var2, int var3);

    abstract void drawItemOverlay();

    public boolean mouseScrolled(GuiRecipe<?> gui, int scroll) {
        return false;
    }

    public Rectangle4i bounds() {
        return new Rectangle4i(this.xPosition, this.yPosition, this.width, this.height);
    }

    public boolean contains(int mx, int my) {
        return this.bounds().contains(mx, my);
    }

    public static class UpdateRecipeButtonsEvent
    extends GuiScreenEvent {
        public List<GuiRecipeButton> buttonList;

        public UpdateRecipeButtonsEvent(GuiRecipe<?> gui, List<GuiRecipeButton> buttonList) {
            super(gui);
            this.buttonList = new ArrayList<GuiRecipeButton>(buttonList);
        }

        public static class Post
        extends UpdateRecipeButtonsEvent {
            public Post(GuiRecipe<?> gui, List<GuiRecipeButton> buttonList) {
                super(gui, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends UpdateRecipeButtonsEvent {
            public int xOffset;
            public int yOffset;
            public int height;
            public HandlerInfo handlerInfo;

            public Pre(GuiRecipe<?> gui, int xOffset, int yOffset, int height, HandlerInfo handlerInfo) {
                super(gui, new ArrayList<GuiRecipeButton>());
                this.xOffset = xOffset;
                this.yOffset = yOffset;
                this.height = height;
                this.handlerInfo = handlerInfo;
            }
        }
    }
}

