/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.LangProxy;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.NEIActions;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.util.NEIKeyboardUtils;
import codechicken.nei.util.NEIMouseUtils;
import com.google.common.collect.Iterables;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class NEIClientUtils
extends NEIServerUtils {
    public static LangProxy lang = new LangProxy("nei");
    private static final Map<Locale, DecimalFormat> decimalFormatters = new HashMap<Locale, DecimalFormat>();
    public static final int ALT_HASH = 0x8000000;
    public static final int SHIFT_HASH = 0x4000000;
    public static final int CTRL_HASH = 0x2000000;

    public static Minecraft mc() {
        return Minecraft.getMinecraft();
    }

    public static String translate(String key, Object ... params) {
        return lang.format(key, params);
    }

    public static void printChatMessage(IChatComponent msg) {
        if (NEIClientUtils.mc().ingameGUI != null) {
            NEIClientUtils.mc().ingameGUI.getChatGUI().printChatMessage(msg);
        }
    }

    private static DecimalFormat getDecimalFormat() {
        return decimalFormatters.computeIfAbsent(Locale.getDefault(Locale.Category.FORMAT), locale -> {
            DecimalFormat numberFormat = new DecimalFormat();
            numberFormat.setGroupingUsed(true);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setRoundingMode(RoundingMode.HALF_UP);
            DecimalFormatSymbols decimalFormatSymbols = numberFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator(',');
            numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            return numberFormat;
        });
    }

    public static String formatNumbers(BigInteger aNumber) {
        return NEIClientUtils.getDecimalFormat().format(aNumber);
    }

    public static String formatNumbers(long aNumber) {
        return NEIClientUtils.getDecimalFormat().format(aNumber);
    }

    public static String formatNumbers(double aNumber) {
        return NEIClientUtils.getDecimalFormat().format(aNumber);
    }

    public static void deleteHeldItem() {
        NEIClientUtils.deleteSlotStack(-999);
    }

    public static void dropHeldItem() {
        NEIClientUtils.mc().playerController.windowClick(((GuiContainer)NEIClientUtils.mc().currentScreen).inventorySlots.windowId, -999, 0, 0, (EntityPlayer)NEIClientUtils.mc().thePlayer);
    }

    public static void deleteSlotStack(int slotNumber) {
        NEIClientUtils.setSlotContents(slotNumber, null, true);
    }

    public static void decreaseSlotStack(int slotNumber) {
        ItemStack stack;
        ItemStack itemStack = stack = slotNumber == -999 ? NEIClientUtils.getHeldItem() : NEIClientUtils.mc().thePlayer.openContainer.getSlot(slotNumber).getStack();
        if (stack == null) {
            return;
        }
        if (stack.stackSize == 1) {
            NEIClientUtils.deleteSlotStack(slotNumber);
        } else {
            stack = stack.copy();
            --stack.stackSize;
            NEIClientUtils.setSlotContents(slotNumber, stack, true);
        }
    }

    public static void deleteEverything() {
        NEICPH.sendDeleteAllItems();
    }

    public static void deleteItemsOfType(ItemStack type) {
        Container c = NEIClientUtils.getGuiContainer().inventorySlots;
        for (int i = 0; i < c.inventorySlots.size(); ++i) {
            ItemStack stack;
            Slot slot = c.getSlot(i);
            if (slot == null || (stack = slot.getStack()) == null || stack.getItem() != type.getItem() || stack.getItemDamage() != type.getItemDamage()) continue;
            NEIClientUtils.setSlotContents(i, null, true);
            slot.putStack(null);
        }
    }

    public static ItemStack getHeldItem() {
        return NEIClientUtils.mc().thePlayer.inventory.getItemStack();
    }

    public static void setSlotContents(int slot, ItemStack item, boolean containerInv) {
        NEICPH.sendSetSlot(slot, item, containerInv);
        if (slot == -999) {
            NEIClientUtils.mc().thePlayer.inventory.setItemStack(item);
        }
    }

    public static void cheatItem(ItemStack stack, int button, int mode) {
        if (!NEIClientConfig.canCheatItem(stack)) {
            return;
        }
        if (mode == -1 && button == 0 && NEIClientUtils.shiftKey() && NEIClientConfig.hasSMPCounterPart()) {
            for (IInfiniteItemHandler handler : ItemInfo.infiniteHandlers) {
                ItemStack inf;
                if (!handler.canHandleItem(stack) || (inf = handler.getInfiniteItem(stack)) == null) continue;
                NEIClientUtils.giveStack(inf, inf.stackSize, true);
                return;
            }
            NEIClientUtils.cheatItem(stack, button, 0);
        } else if (button == 1) {
            NEIClientUtils.giveStack(stack, 1);
        } else if (mode == 1 && stack.stackSize < stack.getMaxStackSize()) {
            NEIClientUtils.giveStack(stack, stack.getMaxStackSize() - stack.stackSize);
        } else {
            NEIClientUtils.giveStack(stack);
        }
    }

    public static void giveStack(ItemStack itemstack) {
        NEIClientUtils.giveStack(itemstack, itemstack.stackSize);
    }

    public static void giveStack(ItemStack itemstack, int i) {
        NEIClientUtils.giveStack(itemstack, i, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void giveStack(ItemStack base, int i, boolean infinite) {
        ItemStack stack = NEIClientUtils.copyStack(base, i);
        if (NEIClientConfig.hasSMPCounterPart()) {
            ItemStack typestack = NEIClientUtils.copyStack(stack, 1);
            if (!infinite && !NEIClientUtils.canItemFitInInventory((EntityPlayer)NEIClientUtils.mc().thePlayer, stack) && NEIClientUtils.mc().currentScreen instanceof GuiContainer) {
                List handlerSlots;
                GuiContainer gui = NEIClientUtils.getGuiContainer();
                try {
                    GuiInfo.readLock.lock();
                    handlerSlots = GuiInfo.guiHandlers.stream().map(handler -> handler.getItemSpawnSlots(gui, typestack)).filter(x -> x != null).collect(Collectors.toCollection(LinkedList::new));
                }
                finally {
                    GuiInfo.readLock.unlock();
                }
                int increment = typestack.getMaxStackSize();
                int given = 0;
                Iterator iterator = Iterables.concat((Iterable)handlerSlots).iterator();
                while (iterator.hasNext()) {
                    int slotNo = (Integer)iterator.next();
                    Slot slot = gui.inventorySlots.getSlot(slotNo);
                    if (!slot.isItemValid(typestack) || !InventoryUtils.canStack((ItemStack)slot.getStack(), (ItemStack)typestack)) continue;
                    int qty = Math.min(stack.stackSize - given, increment);
                    int current = slot.getHasStack() ? slot.getStack().stackSize : 0;
                    qty = Math.min(qty, slot.getSlotStackLimit() - current);
                    ItemStack newStack = NEIClientUtils.copyStack(typestack, qty + current);
                    slot.putStack(newStack);
                    NEIClientUtils.setSlotContents(slotNo, newStack, true);
                    if ((given += qty) < stack.stackSize) continue;
                    break;
                }
                if (given > 0) {
                    NEICPH.sendGiveItem(NEIClientUtils.copyStack(typestack, given), false, false);
                }
            } else {
                NEICPH.sendGiveItem(stack, infinite, true);
            }
        } else {
            int qty;
            for (int given = 0; given < stack.stackSize; given += qty) {
                qty = Math.min(stack.stackSize - given, stack.getMaxStackSize());
                NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.item"), NEIClientUtils.mc().thePlayer.getCommandSenderName(), Item.getIdFromItem((Item)stack.getItem()), qty, stack.getItemDamage(), stack.hasTagCompound() ? stack.getTagCompound().toString() : "", Item.itemRegistry.getNameForObject((Object)stack.getItem()));
            }
        }
    }

    public static boolean canItemFitInInventory(EntityPlayer player, ItemStack itemstack) {
        return InventoryUtils.getInsertibleQuantity((InventoryRange)new InventoryRange((IInventory)player.inventory, 0, 36), (ItemStack)itemstack) > 0;
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean controlKey() {
        if (Minecraft.isRunningOnMac) {
            return Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220);
        }
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static int getGamemode() {
        if (NEIClientConfig.invCreativeMode()) {
            return 2;
        }
        if (NEIClientUtils.mc().playerController.isInCreativeMode()) {
            return 1;
        }
        if (NEIClientUtils.mc().playerController.currentGameType.isAdventure()) {
            return 3;
        }
        return 0;
    }

    public static boolean isValidGamemode(String s) {
        return s.equals("survival") || NEIClientConfig.canPerformAction(s) && Arrays.asList(NEIClientConfig.getStringArrSetting("inventory.gamemodes")).contains(s);
    }

    public static int getNextGamemode() {
        int mode;
        int nmode = mode = NEIClientUtils.getGamemode();
        while ((nmode = (nmode + 1) % NEIActions.gameModes.length) != mode && !NEIClientUtils.isValidGamemode(NEIActions.gameModes[nmode])) {
        }
        return nmode;
    }

    public static void cycleGamemode() {
        int nmode;
        int mode = NEIClientUtils.getGamemode();
        if (mode == (nmode = NEIClientUtils.getNextGamemode())) {
            return;
        }
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendGamemode(nmode);
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.creative"), NEIClientUtils.getGameType(nmode), NEIClientUtils.mc().thePlayer.getCommandSenderName());
        }
    }

    public static long getTime() {
        return NEIClientUtils.mc().theWorld.getWorldInfo().getWorldTime();
    }

    public static void setTime(long l) {
        NEIClientUtils.mc().theWorld.getWorldInfo().setWorldTime(l);
    }

    public static void setHourForward(int hour) {
        long day = NEIClientUtils.getTime() / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendSetTime(hour);
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.time"), newTime);
        }
    }

    public static void sendCommand(String command, Object ... args) {
        if (command.isEmpty()) {
            return;
        }
        NumberFormat numberformat = NumberFormat.getIntegerInstance();
        numberformat.setGroupingUsed(false);
        MessageFormat messageformat = new MessageFormat(command);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Integer) && !(args[i] instanceof Long)) continue;
            messageformat.setFormatByArgumentIndex(i, numberformat);
        }
        NEIClientUtils.mc().thePlayer.sendChatMessage(messageformat.format(args));
    }

    public static boolean isRaining() {
        return NEIClientUtils.mc().theWorld.getWorldInfo().isRaining();
    }

    public static void toggleRaining() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleRain();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.rain"), NEIClientUtils.isRaining() ? 0 : 1);
        }
    }

    public static void healPlayer() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendHeal();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.heal"), NEIClientUtils.mc().thePlayer.getCommandSenderName());
        }
    }

    public static void sendChatItemLink(ItemStack stackover) {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendChatLink(stackover);
        }
    }

    public static void toggleMagnetMode() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleMagnetMode();
        }
    }

    public static ArrayList<int[]> concatIntegersToRanges(List<Integer> damages) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (damages.size() == 0) {
            return ranges;
        }
        Collections.sort(damages);
        int start = -1;
        int next = 0;
        for (Integer i : damages) {
            if (start == -1) {
                start = next = i.intValue();
                continue;
            }
            if (next + 1 != i) {
                ranges.add(new int[]{start, next});
                start = next = i.intValue();
                continue;
            }
            next = i;
        }
        ranges.add(new int[]{start, next});
        return ranges;
    }

    public static ArrayList<int[]> addIntegersToRanges(List<int[]> ranges, List<Integer> damages) {
        for (int[] range : ranges) {
            for (int integer = range[0]; integer <= range[1]; ++integer) {
                damages.add(integer);
            }
        }
        return NEIClientUtils.concatIntegersToRanges(damages);
    }

    public static String cropText(FontRenderer fontRenderer, String text, int containerWidth) {
        int textWidth = fontRenderer.getStringWidth(text);
        if (textWidth > containerWidth) {
            int dots = fontRenderer.getStringWidth("...");
            if (containerWidth > dots) {
                textWidth += dots;
                while (textWidth > containerWidth) {
                    textWidth -= fontRenderer.getCharWidth(text.charAt(text.length() - 1));
                    text = text.substring(0, text.length() - 1);
                }
                return text + "...";
            }
            return "...";
        }
        return text;
    }

    public static boolean safeKeyDown(int keyCode) {
        try {
            return Keyboard.isKeyDown((int)keyCode);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static void setItemQuantity(int i) {
        NEIClientConfig.world.nbt.setInteger("quantity", i);
    }

    public static GuiContainer getGuiContainer() {
        if (NEIClientUtils.mc().currentScreen instanceof GuiContainer) {
            return (GuiContainer)NEIClientUtils.mc().currentScreen;
        }
        return null;
    }

    public static boolean altKey() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static int getMetaHash() {
        if (Keyboard.getEventKeyState()) {
            int hash = 0;
            if (NEIClientUtils.altKey()) {
                hash |= 0x8000000;
            }
            if (NEIClientUtils.shiftKey()) {
                hash |= 0x4000000;
            }
            if (NEIClientUtils.controlKey()) {
                hash |= 0x2000000;
            }
            return hash;
        }
        return 0;
    }

    public static int getKeyHash() {
        int keycode;
        if (Keyboard.getEventKeyState() && !NEIKeyboardUtils.isHashKey(keycode = Keyboard.getEventKey())) {
            return NEIClientUtils.getMetaHash() + keycode;
        }
        return 0;
    }

    public static String getKeyName(int keyBind, int mouseBind) {
        String mouseHash;
        StringJoiner keyText = new StringJoiner(" + ");
        String keyHash = keyBind == 0 ? "" : NEIKeyboardUtils.getKeyName(keyBind);
        String string = mouseHash = mouseBind == Integer.MIN_VALUE ? "" : NEIMouseUtils.getKeyName(mouseBind);
        if (!keyHash.isEmpty()) {
            keyText.add(keyHash);
        }
        if (!mouseHash.isEmpty()) {
            keyText.add(mouseHash);
        }
        return keyText.toString();
    }

    public static void playClickSound() {
        NEIClientUtils.mc().getSoundHandler().playSound((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
    }

    public static void reportErrorBuffered(Throwable e, Set<String> buffer, String cause) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = cause + sw;
        if (buffer.contains(stackTrace)) {
            return;
        }
        System.err.println("Error while rendering: " + cause + " (" + e.getMessage() + ")");
        e.printStackTrace();
        buffer.add(stackTrace);
    }

    public static void reportErrorBuffered(Throwable e, Set<String> buffer, ItemStack cause) {
        if (cause != null) {
            NEIClientUtils.reportErrorBuffered(e, buffer, cause.toString());
        } else {
            NEIClientUtils.reportErrorBuffered(e, buffer, "null");
        }
    }

    public static void drawRect(double left, double top, double width, double height, Color color) {
        boolean is2DTexture = GL11.glGetBoolean((int)3553);
        boolean isBlend = GL11.glGetBoolean((int)3042);
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        tessellator.startDrawingQuads();
        tessellator.addVertex(left, top + height, 0.0);
        tessellator.addVertex(left + width, top + height, 0.0);
        tessellator.addVertex(left + width, top, 0.0);
        tessellator.addVertex(left, top, 0.0);
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (is2DTexture) {
            GL11.glEnable((int)3553);
        }
        if (!isBlend) {
            GL11.glDisable((int)3042);
        }
    }

    public static void drawNEIOverlayText(String text, Rectangle4i rect, float scale, int color, boolean shadow, Alignment alignment) {
        float screenScale = (float)NEIClientUtils.mc().currentScreen.width * 1.0f / (float)NEIClientUtils.mc().displayWidth;
        double smallTextScale = Math.max(screenScale, Math.max(scale, 1.0f) * (GuiDraw.fontRenderer.getUnicodeFlag() ? 0.75f : 0.5f));
        NEIClientUtils.gl2DRenderContext(() -> {
            int width = GuiDraw.fontRenderer.getStringWidth(text);
            float partW = (float)rect.w / 2.0f;
            float partH = (float)rect.h / 2.0f;
            double offsetX = Math.ceil((double)((float)rect.x + partW + partW * (float)alignment.x) - (double)((float)width / 2.0f * (float)(alignment.x + 1)) * smallTextScale);
            double offsetY = Math.ceil((double)((float)rect.y + partH + partH * (float)alignment.y) - (double)((float)GuiDraw.fontRenderer.FONT_HEIGHT / 2.0f * (float)(alignment.y + 1)) * smallTextScale);
            GL11.glTranslated((double)offsetX, (double)offsetY, (double)0.0);
            GL11.glScaled((double)smallTextScale, (double)smallTextScale, (double)1.0);
            GuiDraw.fontRenderer.drawString(text, 0, 0, color, shadow);
            GL11.glScaled((double)(1.0 / smallTextScale), (double)(1.0 / smallTextScale), (double)1.0);
            GL11.glTranslated((double)(-1.0 * offsetX), (double)(-1.0 * offsetY), (double)0.0);
        });
    }

    public static void drawNEIOverlayText(String text, int x, int y) {
        NEIClientUtils.drawNEIOverlayText(text, new Rectangle4i(x, y, 16, 16), 0.5f, 16635957, false, Alignment.TopLeft);
    }

    public static void gl2DRenderContext(Runnable callback) {
        boolean isLighting = GL11.glGetBoolean((int)2896);
        boolean isDepthTest = GL11.glGetBoolean((int)2929);
        boolean isAlphaTest = GL11.glGetBoolean((int)3008);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)2929);
        callback.run();
        if (isLighting) {
            GL11.glEnable((int)2896);
        }
        if (isDepthTest) {
            GL11.glEnable((int)2929);
        }
        if (!isAlphaTest) {
            GL11.glDisable((int)3008);
        }
    }

    public static class Alignment {
        public final int x;
        public final int y;
        public static final Alignment TopLeft = new Alignment(-1, -1);
        public static final Alignment TopCenter = new Alignment(0, -1);
        public static final Alignment TopRight = new Alignment(1, -1);
        public static final Alignment CenterLeft = new Alignment(-1, 0);
        public static final Alignment Center = new Alignment(0, 0);
        public static final Alignment CenterRight = new Alignment(1, 0);
        public static final Alignment BottomLeft = new Alignment(-1, 1);
        public static final Alignment BottomCenter = new Alignment(0, 1);
        public static final Alignment BottomRight = new Alignment(1, 1);

        public Alignment(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public float getX(float parentWidth, float childWidth) {
            float x = (float)(this.x + 1) / 2.0f;
            return parentWidth * x - childWidth * x;
        }

        public float getY(float parentHeight, float childHeight) {
            float y = (float)(this.y + 1) / 2.0f;
            return parentHeight * y - childHeight * y;
        }
    }
}

