/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.core.gui.GuiScreenWidget;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.config.Option;
import codechicken.nei.guihook.GuiContainerManager;
import java.awt.Point;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiPanelSettings
extends GuiScreenWidget {
    private final Option opt;
    private PanelPlaceholder bookmarksPanel;
    private PanelPlaceholder itemsPanel;

    public GuiPanelSettings(Option opt) {
        super(176, 198);
        this.opt = opt;
        this.bookmarksPanel = new PanelPlaceholder(opt, opt.name + ".bookmarks");
        this.itemsPanel = new PanelPlaceholder(opt, opt.name + ".items");
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public void keyTyped(char c, int keycode) {
        if (keycode == 1 || keycode == 14) {
            Minecraft.getMinecraft().displayGuiScreen((GuiScreen)this.opt.slot.getGui());
            return;
        }
        super.keyTyped(c, keycode);
    }

    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CCRenderState.changeTexture((String)"nei:textures/gui/inv.png");
        int x = this.guiLeft;
        int y = this.guiTop - 4;
        this.drawTexturedModalRect(x - 23, y, 0, 0, 199, 204);
    }

    public void drawScreen(int mousex, int mousey, float f) {
        this.drawGuiContainerBackgroundLayer(f, mousex, mousey);
        this.drawDefaultBackground();
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        this.bookmarksPanel.resize(this.getBookmarkDefaultSize());
        this.itemsPanel.resize(this.getItemsDefaultSize());
        this.bookmarksPanel.draw(mousex, mousey);
        this.itemsPanel.draw(mousex, mousey);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        RenderHelper.enableStandardItemLighting();
    }

    private Rectangle4i getBookmarkDefaultSize() {
        return new Rectangle4i(2, 2, this.guiLeft - 4, this.height - 4);
    }

    protected Rectangle4i getItemsDefaultSize() {
        return new Rectangle4i(this.guiLeft + this.xSize + 2, 2, this.width - (this.guiLeft + this.xSize + 4), this.height - 4);
    }

    protected void mouseClicked(int x, int y, int button) {
        this.bookmarksPanel.mouseClicked(x, y, button);
        this.itemsPanel.mouseClicked(x, y, button);
    }

    protected void mouseMovedOrUp(int x, int y, int button) {
        this.bookmarksPanel.mouseMovedOrUp(x, y, button);
        this.itemsPanel.mouseMovedOrUp(x, y, button);
    }

    protected static class PanelPlaceholder {
        protected static int PANEL_SIZE = 16;
        private final Option opt;
        private final String name;
        private Rectangle4i margin;
        private Point dragDown;
        private String dragDir;
        private int x = 0;
        private int y = 0;
        private int w = 0;
        private int h = 0;
        private PanelResizeButton leftButton = new PanelResizeButton(PANEL_SIZE, PANEL_SIZE * 2);
        private PanelResizeButton topButton = new PanelResizeButton(PANEL_SIZE * 2, PANEL_SIZE);
        private PanelResizeButton rightButton = new PanelResizeButton(PANEL_SIZE, PANEL_SIZE * 2);
        private PanelResizeButton bottomButton = new PanelResizeButton(PANEL_SIZE * 2, PANEL_SIZE);

        public PanelPlaceholder(Option opt, String name) {
            this.opt = opt;
            this.name = name;
        }

        public void resize(Rectangle4i margin) {
            this.margin = margin;
            int[] padding = this.getPaddings();
            this.x = margin.x + padding[0];
            this.y = margin.y + padding[1];
            this.w = margin.w - padding[2] - padding[0];
            this.h = margin.h - padding[3] - padding[1];
            this.leftButton.x = this.x;
            this.leftButton.y = this.y + this.h / 2 - PanelPlaceholder.PANEL_SIZE;
            this.rightButton.x = this.x + this.w - PanelPlaceholder.PANEL_SIZE;
            this.rightButton.y = this.y + this.h / 2 - PanelPlaceholder.PANEL_SIZE;
            this.topButton.x = this.x + this.w / 2 - PanelPlaceholder.PANEL_SIZE;
            this.topButton.y = this.y;
            this.bottomButton.x = this.x + this.w / 2 - PanelPlaceholder.PANEL_SIZE;
            this.bottomButton.y = this.y + this.h - PanelPlaceholder.PANEL_SIZE;
        }

        public void draw(int mousex, int mousey) {
            Gui.drawRect((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + PANEL_SIZE), (int)-1146443094);
            Gui.drawRect((int)this.x, (int)(this.y + this.h - PANEL_SIZE), (int)(this.x + this.w), (int)(this.y + this.h), (int)-1146443094);
            Gui.drawRect((int)this.x, (int)this.y, (int)(this.x + 2), (int)(this.y + this.h), (int)-1146443094);
            Gui.drawRect((int)(this.x + this.w), (int)this.y, (int)(this.x + this.w - 2), (int)(this.y + this.h), (int)-1146443094);
            Gui.drawRect((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + 2), (int)-1146443094);
            Gui.drawRect((int)this.x, (int)(this.y + this.h), (int)(this.x + this.w), (int)(this.y + this.h - 2), (int)-1146443094);
            this.drawItems();
            this.leftButton.draw(mousex, mousey);
            this.rightButton.draw(mousex, mousey);
            this.topButton.draw(mousex, mousey);
            this.bottomButton.draw(mousex, mousey);
        }

        protected int[] getPaddings() {
            int minWidth = ItemsGrid.SLOT_SIZE;
            int minHeight = ItemsGrid.SLOT_SIZE;
            int paddingLeft = (int)Math.ceil((double)(this.margin.w * this.opt.renderTag(this.name + ".left").getIntValue()) / 100000.0);
            int paddingTop = (int)Math.ceil((double)(this.margin.h * this.opt.renderTag(this.name + ".top").getIntValue()) / 100000.0);
            int paddingRight = (int)Math.ceil((double)(this.margin.w * this.opt.renderTag(this.name + ".right").getIntValue()) / 100000.0);
            int paddingBottom = (int)Math.ceil((double)(this.margin.h * this.opt.renderTag(this.name + ".bottom").getIntValue()) / 100000.0);
            if (this.dragDir != null) {
                Point mouse = GuiDraw.getMousePosition();
                Point drag = new Point(mouse.x - this.dragDown.x, mouse.y - this.dragDown.y);
                if (this.dragDir == "left") {
                    paddingLeft = Math.min(Math.max(0, this.margin.w - paddingRight - minWidth), Math.max(0, paddingLeft + drag.x));
                } else if (this.dragDir == "right") {
                    paddingRight = Math.min(Math.max(0, this.margin.w - paddingLeft - minWidth), Math.max(0, paddingRight - drag.x));
                } else if (this.dragDir == "top") {
                    paddingTop = Math.min(Math.max(0, this.margin.h - paddingBottom - minHeight), Math.max(0, paddingTop + drag.y));
                } else if (this.dragDir == "bottom") {
                    paddingBottom = Math.min(Math.max(0, this.margin.h - paddingTop - minHeight), Math.max(0, paddingBottom - drag.y));
                } else if (this.dragDir == "move") {
                    int width = this.margin.w - paddingRight - paddingLeft;
                    int height = this.margin.h - paddingTop - paddingBottom;
                    paddingLeft = Math.min(Math.max(0, this.margin.w - width), Math.max(0, paddingLeft + drag.x));
                    paddingTop = Math.min(Math.max(0, this.margin.h - height), Math.max(0, paddingTop + drag.y));
                    paddingRight = this.margin.w - paddingLeft - width;
                    paddingBottom = this.margin.h - paddingTop - height;
                }
            }
            int deltaHeight = Math.min(0, this.margin.h - paddingTop - paddingBottom - minHeight) / 2;
            paddingLeft = Math.min(paddingLeft, Math.max(0, this.margin.w - paddingRight - minWidth));
            paddingRight = Math.min(paddingRight, Math.max(0, this.margin.w - paddingLeft - minWidth));
            paddingTop = Math.min(this.margin.h - minHeight, Math.max(0, paddingTop + deltaHeight));
            paddingBottom = Math.min(this.margin.h - paddingTop - minHeight, Math.max(0, paddingBottom - deltaHeight));
            return new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
        }

        protected void drawItems() {
            int columns = (this.w - 2) / ItemsGrid.SLOT_SIZE;
            int rows = (this.h - (PANEL_SIZE + 2) * 2 - 2) / ItemsGrid.SLOT_SIZE;
            int paddingLeft = this.w % ItemsGrid.SLOT_SIZE / 2;
            ArrayList<ItemStack> items = ItemPanels.itemPanel.getItems();
            if (items.isEmpty()) {
                return;
            }
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    this.drawItem(this.x + paddingLeft + ItemsGrid.SLOT_SIZE * c + 1, this.y + PANEL_SIZE + 2 + ItemsGrid.SLOT_SIZE * r + 1, (ItemStack)items.get((r * columns + c) % items.size()));
                }
            }
        }

        protected void drawItem(int x, int y, ItemStack stack) {
            float scale = (float)ItemsGrid.SLOT_SIZE / 18.0f;
            float inverseScaleFactor = 1.0f / scale;
            float shiftX = (float)x * inverseScaleFactor;
            float shiftY = (float)y * inverseScaleFactor;
            GL11.glScaled((double)scale, (double)scale, (double)1.0);
            GL11.glTranslated((double)shiftX, (double)shiftY, (double)0.0);
            GuiContainerManager.drawItem(0, 0, stack, true, "");
            GL11.glTranslated((double)(-1.0f * shiftX), (double)(-1.0f * shiftY), (double)0.0);
            GL11.glScaled((double)inverseScaleFactor, (double)inverseScaleFactor, (double)1.0);
        }

        public boolean contains(int pointX, int pointY) {
            return new Rectangle4i(this.x, this.y, this.w, this.h).contains(pointX, pointY);
        }

        protected void mouseClicked(int x, int y, int button) {
            if (this.contains(x, y)) {
                this.dragDown = GuiDraw.getMousePosition();
                this.dragDir = this.leftButton.contains(x, y) ? "left" : (this.rightButton.contains(x, y) ? "right" : (this.topButton.contains(x, y) ? "top" : (this.bottomButton.contains(x, y) ? "bottom" : "move")));
            }
        }

        protected void mouseMovedOrUp(int x, int y, int button) {
            if (button == 0 && this.dragDown != null) {
                int[] padding = this.getPaddings();
                this.opt.renderTag(this.name + ".left").setIntValue(padding[0] * 100000 / this.margin.w);
                this.opt.renderTag(this.name + ".top").setIntValue(padding[1] * 100000 / this.margin.h);
                this.opt.renderTag(this.name + ".right").setIntValue(padding[2] * 100000 / this.margin.w);
                this.opt.renderTag(this.name + ".bottom").setIntValue(padding[3] * 100000 / this.margin.h);
                this.dragDir = null;
                this.dragDown = null;
            }
        }
    }

    protected static class PanelResizeButton {
        private int x;
        private int y;
        private int w;
        private int h;

        public PanelResizeButton(int w, int h) {
            this.w = w;
            this.h = h;
        }

        public void draw(int mousex, int mousey) {
            Gui.drawRect((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + this.h), (int)-1146443094);
            Gui.drawRect((int)(this.x + 2), (int)(this.y + 2), (int)(this.x + this.w - 2), (int)(this.y + this.h - 2), (int)(this.contains(mousex, mousey) ? -16777216 : -1157627904));
        }

        public boolean contains(int pointX, int pointY) {
            return new Rectangle4i(this.x, this.y, this.w, this.h).contains(pointX, pointY);
        }
    }
}

