/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config.preset;

import codechicken.core.gui.GuiScreenWidget;
import codechicken.nei.Button;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PresetsList;
import codechicken.nei.config.OptionScrollPane;
import codechicken.nei.config.preset.LeftPanel;
import codechicken.nei.config.preset.RightPanel;
import codechicken.nei.guihook.GuiContainerManager;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public class GuiPresetSettings
extends GuiScreenWidget {
    protected final PresetsList.Preset preset;
    protected final GuiScreen parent;
    protected final int slotIndex;
    public int marginleft;
    public int margintop;
    public int marginright;
    public int marginbottom;
    protected LeftPanel leftPanel;
    protected RightPanel rightPanel;
    protected Button backButton;
    protected Button saveButton;

    public GuiPresetSettings(final GuiScreen parent, final int slotIndex) {
        this.parent = parent;
        this.setMargins(6, 20, 6, 30);
        this.slotIndex = slotIndex;
        this.preset = slotIndex == -1 ? new PresetsList.Preset() : PresetsList.presets.get(slotIndex).copy();
        this.leftPanel = new LeftPanel(this.preset){

            @Override
            protected void onItemsChanges() {
                GuiPresetSettings.this.leftPanel.grid.restartFilter();
            }
        };
        this.rightPanel = new RightPanel(this.preset, slotIndex){

            @Override
            protected void onItemsChanges() {
                GuiPresetSettings.this.leftPanel.grid.restartFilter();
            }
        };
        this.backButton = new Button(NEIClientUtils.translate("options.back", new Object[0])){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                Minecraft.getMinecraft().displayGuiScreen(parent);
                return true;
            }
        };
        this.saveButton = new Button(NEIClientUtils.translate("options.save", new Object[0])){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (this.state == 0) {
                    if (slotIndex == -1) {
                        PresetsList.presets.add(GuiPresetSettings.this.preset);
                    } else {
                        PresetsList.presets.set(slotIndex, GuiPresetSettings.this.preset);
                    }
                    PresetsList.savePresets();
                    Minecraft.getMinecraft().displayGuiScreen(parent);
                    return true;
                }
                return false;
            }
        };
        this.add(this.leftPanel);
        this.add(this.rightPanel);
    }

    protected void setMargins(int left, int top, int right, int bottom) {
        this.marginleft = left;
        this.margintop = top;
        this.marginright = right;
        this.marginbottom = bottom;
    }

    protected Rectangle windowBounds() {
        return new Rectangle(this.marginleft, this.margintop, this.width - this.marginleft - this.marginright, this.height - this.margintop - this.marginbottom);
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public void updateScreen() {
        Rectangle bounds = this.windowBounds();
        int panelWidth = bounds.getWidth() * 2 / 5;
        this.leftPanel.setSize(bounds.getX(), bounds.getY() + 4, panelWidth, bounds.getHeight() - 6);
        this.rightPanel.setSize(bounds.getX() + bounds.getWidth() - panelWidth, bounds.getY() + 4, panelWidth, bounds.getHeight() - 6);
        int w = Math.min(200, this.width - 40);
        this.backButton.w = w / 2 - 3;
        this.backButton.h = 20;
        this.backButton.x = (this.width - w) / 2;
        this.backButton.y = this.height - 25;
        this.saveButton.state = this.preset.name.isEmpty() || this.preset.mode == null || this.preset.items.isEmpty() ? 2 : 0;
        this.saveButton.w = w / 2 - 3;
        this.saveButton.h = 20;
        this.saveButton.x = this.width / 2 + 3;
        this.saveButton.y = this.height - 25;
        super.updateScreen();
    }

    public void resize() {
        this.guiTop = 0;
        this.guiLeft = 0;
    }

    public void drawScreen(int mousex, int mousey, float f) {
        Rectangle bounds = this.windowBounds();
        this.drawDefaultBackground();
        GuiPresetSettings.drawOverlay(bounds.getY(), bounds.getHeight(), this.width, this.zLevel);
        this.drawCenteredString(Minecraft.getMinecraft().fontRenderer, NEIClientUtils.translate(this.slotIndex == -1 ? "presets.create" : "presets.update", new Object[0]), this.width / 2, 6, -1);
        this.backButton.draw(mousex, mousey);
        this.saveButton.draw(mousex, mousey);
        super.drawScreen(mousex, mousey, f);
        List<String> tooltip = new LinkedList<String>();
        tooltip = this.leftPanel.handleTooltip(mousex, mousey, tooltip);
        tooltip = this.rightPanel.handleTooltip(mousex, mousey, tooltip);
        GuiContainerManager.drawPagedTooltip(Minecraft.getMinecraft().fontRenderer, mousex + 12, mousey - 12, tooltip);
    }

    protected void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        if (this.backButton.contains(x, y)) {
            this.backButton.handleClick(x, y, button);
        }
        if (this.saveButton.contains(x, y)) {
            this.saveButton.handleClick(x, y, button);
        }
    }

    public static void drawOverlay(int y, int height, int screenwidth, float zLevel) {
        OptionScrollPane.drawOverlayTex(0, 0, screenwidth, y, zLevel);
        OptionScrollPane.drawOverlayTex(0, y + height, screenwidth, screenwidth - y - height, zLevel);
        OptionScrollPane.drawOverlayGrad(0, screenwidth, y, y + 4, zLevel);
        OptionScrollPane.drawOverlayGrad(0, screenwidth, y + height, y + height - 4, zLevel);
    }

    public static void drawOverlayTex(int x, int y, int w, int h, float zLevel) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.getMinecraft().renderEngine.bindTexture(Gui.optionsBackground);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        t.addVertexWithUV((double)x, (double)(y + h), (double)zLevel, 0.0, (double)h / 16.0);
        t.addVertexWithUV((double)(x + w), (double)(y + h), (double)zLevel, (double)w / 16.0, (double)h / 16.0);
        t.addVertexWithUV((double)(x + w), (double)y, (double)zLevel, (double)w / 16.0, 0.0);
        t.draw();
    }

    public static void drawOverlayGrad(int x1, int x2, int y1, int y2, float zLevel) {
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.setColorRGBA_I(0, 255);
        t.addVertex((double)x2, (double)y1, (double)zLevel);
        t.addVertex((double)x1, (double)y1, (double)zLevel);
        t.setColorRGBA_I(0, 0);
        t.addVertex((double)x1, (double)y2, (double)zLevel);
        t.addVertex((double)x2, (double)y2, (double)zLevel);
        t.draw();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
    }
}

