/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.FavoriteRecipes;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.bookmark.BookmarksGridSlot;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerQuery;
import codechicken.nei.recipe.StackInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class GuiCraftingRecipe
extends GuiRecipe<ICraftingHandler> {
    public static ArrayList<ICraftingHandler> craftinghandlers = new ArrayList();
    public static ArrayList<ICraftingHandler> serialCraftingHandlers = new ArrayList();
    private static Set<String> existingHandlers = new HashSet<String>();

    public static boolean openRecipeGui(String outputId, Object ... results) {
        return GuiCraftingRecipe.createRecipeGui(outputId, true, results) != null;
    }

    public static GuiRecipe<?> createRecipeGui(String outputId, boolean open, Object ... results) {
        Minecraft mc = NEIClientUtils.mc();
        for (int i = 0; i < results.length; ++i) {
            Object object = results[i];
            if (!(object instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)object;
            results[i] = StackInfo.normalizeRecipeQueryStack(stack.copy());
        }
        Recipe.RecipeId recipeId = "item".equals(outputId) ? GuiCraftingRecipe.getRecipeId(mc.currentScreen, (ItemStack)results[0]) : ("recipeId".equals(outputId) ? (Recipe.RecipeId)results[1] : GuiCraftingRecipe.getCurrentRecipeId(mc.currentScreen));
        ArrayList<ICraftingHandler> handlers = GuiCraftingRecipe.getCraftingHandlers(outputId, results);
        if (!handlers.isEmpty()) {
            GuiCraftingRecipe gui = new GuiCraftingRecipe(handlers);
            if (open) {
                Object object;
                if (NEIClientConfig.showHistoryPanelWidget() && "item".equals(outputId) && (object = results[0]) instanceof ItemStack) {
                    ItemStack stack = (ItemStack)object;
                    ItemPanels.itemPanel.historyPanel.addItem(stack);
                }
                mc.displayGuiScreen((GuiScreen)gui);
            }
            gui.openTargetRecipe(recipeId);
            return gui;
        }
        return null;
    }

    public static ArrayList<ICraftingHandler> getCraftingHandlers(String outputId, Object ... results) {
        UnaryOperator recipeHandlerFunction;
        ArrayList<ICraftingHandler> craftinghandlers = GuiCraftingRecipe.craftinghandlers;
        ArrayList<ICraftingHandler> serialCraftingHandlers = GuiCraftingRecipe.serialCraftingHandlers;
        if ("recipeId".equals(outputId)) {
            ItemStack stack = (ItemStack)results[0];
            Recipe.RecipeId recipeId = (Recipe.RecipeId)results[1];
            craftinghandlers = GuiCraftingRecipe.filterByHandlerName(craftinghandlers, recipeId.getHandleName());
            serialCraftingHandlers = GuiCraftingRecipe.filterByHandlerName(serialCraftingHandlers, recipeId.getHandleName());
            recipeHandlerFunction = h -> h.getRecipeHandler("item", stack);
        } else {
            recipeHandlerFunction = h -> h.getRecipeHandler(outputId, results);
        }
        RecipeHandlerQuery<ICraftingHandler> recipeQuery = new RecipeHandlerQuery<ICraftingHandler>(recipeHandlerFunction, craftinghandlers, serialCraftingHandlers, "Error while looking up crafting recipe", "outputId: " + outputId, "results: " + Arrays.toString(results));
        return recipeQuery.runWithProfiling(NEIClientUtils.translate("recipe.concurrent.crafting", new Object[0]));
    }

    private static ArrayList<ICraftingHandler> filterByHandlerName(ArrayList<ICraftingHandler> craftinghandlers, String handlerName) {
        return craftinghandlers.stream().filter(h -> GuiCraftingRecipe.getHandlerName(h).equals(handlerName)).collect(Collectors.toCollection(ArrayList::new));
    }

    private static String getHandlerName(ICraftingHandler handler) {
        return GuiRecipeTab.getHandlerInfo(handler).getHandlerName();
    }

    public static Recipe.RecipeId getRecipeId(GuiScreen gui, ItemStack stackover) {
        GuiRecipe guiRecipe;
        Recipe focusedRecipe;
        if (gui instanceof GuiRecipe && (focusedRecipe = (guiRecipe = (GuiRecipe)gui).getFocusedRecipe()) != null) {
            return focusedRecipe.getRecipeId();
        }
        Point mouseover = GuiDraw.getMousePosition();
        BookmarksGridSlot panelSlot = ItemPanels.bookmarkPanel.getSlotMouseOver(mouseover.x, mouseover.y);
        if (panelSlot != null) {
            return panelSlot.getType() == BookmarkItem.BookmarkItemType.INGREDIENT || panelSlot.getRecipeId() == null ? FavoriteRecipes.getFavorite(stackover) : panelSlot.getRecipeId();
        }
        ItemsGrid.ItemsGridSlot itemSlot = ItemPanels.itemPanel.getSlotMouseOver(mouseover.x, mouseover.y);
        if (itemSlot == null) {
            itemSlot = ItemPanels.itemPanel.historyPanel.getSlotMouseOver(mouseover.x, mouseover.y);
        }
        if (itemSlot == null) {
            itemSlot = ItemPanels.itemPanel.craftablesPanel.getSlotMouseOver(mouseover.x, mouseover.y);
        }
        if (itemSlot != null) {
            return ((ItemsGrid.ItemsGridSlot)itemSlot).getRecipeId();
        }
        return null;
    }

    private GuiCraftingRecipe(ArrayList<ICraftingHandler> handlers) {
        super(NEIClientUtils.mc().currentScreen);
        this.currenthandlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerRecipeHandler(ICraftingHandler handler) {
        String handlerId = handler.getHandlerId();
        if (existingHandlers.contains(handlerId)) {
            return;
        }
        Collection<Object> collection = existingHandlers;
        synchronized (collection) {
            existingHandlers.add(handlerId);
        }
        if (NEIClientConfig.serialHandlers.contains(handlerId)) {
            collection = serialCraftingHandlers;
            synchronized (collection) {
                serialCraftingHandlers.add(handler);
            }
        }
        collection = craftinghandlers;
        synchronized (collection) {
            craftinghandlers.add(handler);
        }
    }

    @Override
    public ArrayList<ICraftingHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }
}

