/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.nei.BookmarkPanel;
import codechicken.nei.bookmark.BookmarkGrid;
import codechicken.nei.bookmark.BookmarkGroup;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.recipe.Recipe;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupingItem {
    public BookmarkGrid grid;
    public int groupId = -1;
    public PointEntry startPoint;
    public PointEntry endPoint;

    public GroupingItem(BookmarkGrid grid, int groupId, int overRowIndex) {
        this.groupId = groupId;
        this.grid = grid;
        this.setStartPoint(overRowIndex);
    }

    public void setStartPoint(int overRowIndex) {
        this.startPoint = this.grid.getRowItemIndex(overRowIndex, true) != Integer.MIN_VALUE ? new PointEntry(overRowIndex + this.getRowShift(), this.getTopRowIndex(overRowIndex), this.getBottomRowIndex(overRowIndex)) : new PointEntry(overRowIndex + this.getRowShift(), -1, -1);
    }

    public void setEndPoint(int overRowIndex) {
        if (this.grid.getRowItemIndex(overRowIndex, true) != Integer.MIN_VALUE) {
            this.endPoint = new PointEntry(overRowIndex + this.getRowShift(), this.getTopRowIndex(overRowIndex), this.getBottomRowIndex(overRowIndex));
        }
    }

    public int getStartSlotIndex() {
        return this.startPoint.cursorRowIndex - this.getRowShift();
    }

    public int getEndSlotIndex() {
        return this.endPoint != null ? this.endPoint.cursorRowIndex - this.getRowShift() : 0;
    }

    public boolean hasEndRow() {
        return this.endPoint != null;
    }

    private int getRowShift() {
        return (this.grid.getPage() - 1) * this.grid.getRows();
    }

    public Map<Integer, Integer> prepareGroups(Map<Integer, Integer> groups) {
        int rowIndex;
        int topRowIndex = Math.min(this.startPoint.topRowIndex, this.endPoint.topRowIndex);
        int bottomRowIndex = Math.max(this.startPoint.bottomRowIndex, this.endPoint.bottomRowIndex);
        groups = new HashMap<Integer, Integer>(groups);
        if (this.groupId != 0) {
            if (this.startPoint.cursorRowIndex > this.endPoint.cursorRowIndex) {
                rowIndex = this.endPoint.topRowIndex - 1;
                while (groups.containsKey(rowIndex) && groups.get(rowIndex) == this.groupId) {
                    groups.put(rowIndex--, 0);
                }
            } else if (this.startPoint.cursorRowIndex < this.endPoint.cursorRowIndex) {
                rowIndex = this.endPoint.bottomRowIndex + 1;
                while (groups.containsKey(rowIndex) && groups.get(rowIndex) == this.groupId) {
                    groups.put(rowIndex++, 0);
                }
            }
        } else if (groups.containsKey(topRowIndex - 1) && groups.get(topRowIndex - 1).equals(groups.get(bottomRowIndex + 1))) {
            int groupId = groups.get(bottomRowIndex);
            int rowIndex2 = bottomRowIndex + 1;
            while (groups.containsKey(rowIndex2) && groups.get(rowIndex2) == groupId) {
                groups.put(rowIndex2, -1 * groups.get(rowIndex2));
                ++rowIndex2;
            }
        }
        for (rowIndex = topRowIndex; rowIndex <= bottomRowIndex && groups.containsKey(rowIndex); ++rowIndex) {
            groups.put(rowIndex, this.groupId);
        }
        return groups;
    }

    protected int getTopRowIndex(int overRowIndex) {
        int rowShift = this.getRowShift();
        int itemIndex = this.grid.getRowItemIndex(overRowIndex, true);
        if (itemIndex == Integer.MIN_VALUE) {
            return -1;
        }
        BookmarkItem item = this.grid.getCalculatedItem(itemIndex);
        if (item.recipeId != null && item.type != BookmarkItem.BookmarkItemType.ITEM) {
            List<Integer> sortedItems = this.grid.getSortedItems();
            BookmarkGroup group = this.grid.getGroup(item.groupId);
            boolean isCollapsedGroup = group.collapsed || group.crafting != null && group.viewMode == BookmarkPanel.BookmarkViewMode.DEFAULT;
            Recipe.RecipeId recipeId = group.crafting != null ? group.crafting.itemToRecipe.getOrDefault(itemIndex, item.recipeId) : item.recipeId;
            Set<Recipe.RecipeId> recipeRelations = group.crafting != null ? group.crafting.recipeRelations.getOrDefault(recipeId, Collections.singleton(recipeId)) : Collections.singleton(recipeId);
            for (Integer rItemIndex : sortedItems) {
                BookmarkItem rItem = this.grid.getCalculatedItem(rItemIndex);
                if (rItem.groupId != item.groupId || !isCollapsedGroup && (rItem.type == BookmarkItem.BookmarkItemType.ITEM || !recipeRelations.contains(rItem.recipeId))) continue;
                return this.grid.getAbsoluteSlotIndex(rItemIndex) / this.grid.getColumns();
            }
            return -1;
        }
        return rowShift + overRowIndex;
    }

    protected int getBottomRowIndex(int overRowIndex) {
        int rowShift = this.getRowShift();
        int itemIndex = this.grid.getRowItemIndex(overRowIndex, false);
        if (itemIndex == Integer.MIN_VALUE) {
            return -1;
        }
        BookmarkItem item = this.grid.getCalculatedItem(itemIndex);
        if (item.recipeId != null && item.type != BookmarkItem.BookmarkItemType.ITEM) {
            List<Integer> sortedItems = this.grid.getSortedItems();
            BookmarkGroup group = this.grid.getGroup(item.groupId);
            boolean isCollapsedGroup = group.collapsed || group.crafting != null && group.viewMode == BookmarkPanel.BookmarkViewMode.DEFAULT;
            Recipe.RecipeId recipeId = group.crafting != null ? group.crafting.itemToRecipe.getOrDefault(itemIndex, item.recipeId) : item.recipeId;
            Set<Recipe.RecipeId> recipeRelations = group.crafting != null ? group.crafting.recipeRelations.getOrDefault(recipeId, Collections.singleton(recipeId)) : Collections.singleton(recipeId);
            for (int index = sortedItems.size() - 1; index >= 0; --index) {
                int rItemIndex = sortedItems.get(index);
                BookmarkItem rItem = this.grid.getCalculatedItem(rItemIndex);
                if (rItem.groupId != item.groupId || !isCollapsedGroup && (rItem.type == BookmarkItem.BookmarkItemType.ITEM || !recipeRelations.contains(rItem.recipeId))) continue;
                return this.grid.getAbsoluteSlotIndex(rItemIndex) / this.grid.getColumns();
            }
            return -1;
        }
        return rowShift + overRowIndex;
    }

    public static class PointEntry {
        public int cursorRowIndex;
        public int topRowIndex;
        public int bottomRowIndex;

        public PointEntry(int clickSlotIndex, int topSlotIndex, int bottomSlotIndex) {
            this.cursorRowIndex = clickSlotIndex;
            this.topRowIndex = topSlotIndex;
            this.bottomRowIndex = bottomSlotIndex;
        }
    }
}

