/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.render.CCRenderState;
import codechicken.nei.GuiEnchantmentModifier;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIServerUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ContainerEnchantmentModifier
extends ContainerEnchantment {
    public final ArrayList<EnchantmentHash> slotEnchantment = new ArrayList();
    int level = 5;
    public int scrollclicky = -1;
    public float scrollpercent;
    public int scrollmousey;
    public float percentscrolled;
    public int relx = 60;
    public int rely = 14;
    public int height = 57;
    public int cwidth = 101;
    public int slotheight = 19;
    public GuiEnchantmentModifier parentscreen;

    public ContainerEnchantmentModifier(InventoryPlayer inventoryplayer, World world, int i, int j, int k) {
        super(inventoryplayer, world, i, j, k);
    }

    public int getNumSlots() {
        return this.slotEnchantment.size();
    }

    public int getScrollBarHeight() {
        int sbarh = (int)((float)this.height / (float)this.getContentHeight() * (float)this.height);
        if (sbarh > this.height) {
            return this.height;
        }
        return Math.max(sbarh, this.height / 15);
    }

    public int getScrollBarWidth() {
        return 7;
    }

    public int getContentHeight() {
        return this.slotheight * this.getNumSlots();
    }

    public int getScrolledSlots() {
        int slots = this.getNumSlots();
        int shownslots = this.height / this.slotheight;
        return (int)(this.percentscrolled * (float)(slots - shownslots) + 0.5f);
    }

    private int getClickedSlot(int mousey) {
        return (mousey - this.rely) / this.slotheight + this.getScrolledSlots();
    }

    public void calculatePercentScrolled() {
        int barempty = this.height - this.getScrollBarHeight();
        if (this.scrollclicky >= 0) {
            int scrolldiff = this.scrollmousey - this.scrollclicky;
            this.percentscrolled = (float)scrolldiff / (float)barempty + this.scrollpercent;
        }
        if (this.percentscrolled < 0.0f) {
            this.percentscrolled = 0.0f;
        }
        if (this.percentscrolled > 1.0f) {
            this.percentscrolled = 1.0f;
        }
        int sbary = this.rely + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        this.percentscrolled = (float)(sbary - this.rely) / (float)barempty;
    }

    public boolean clickScrollBar(int mousex, int mousey, int button) {
        int barempty = this.height - this.getScrollBarHeight();
        int sbary = this.rely + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        if (button == 0 && this.getScrollBarHeight() < this.height && (mousex -= this.parentscreen.guiLeft) >= this.relx + this.cwidth && mousex < this.relx + this.cwidth + this.getScrollBarWidth() && (mousey -= this.parentscreen.guiTop) >= this.rely && mousey < this.rely + this.height) {
            if (mousey < sbary) {
                this.percentscrolled = (float)(mousey - this.rely) / (float)barempty;
                this.calculatePercentScrolled();
            } else if (mousey > sbary + this.getScrollBarHeight()) {
                this.percentscrolled = (float)(mousey - this.rely - this.getScrollBarHeight() + 1) / (float)barempty;
                this.calculatePercentScrolled();
            } else {
                this.scrollclicky = mousey;
                this.scrollpercent = this.percentscrolled;
                this.scrollmousey = mousey;
            }
            return true;
        }
        return false;
    }

    public void mouseUp(int mousex, int mousey, int button) {
        if (this.scrollclicky >= 0 && button == 0) {
            this.scrollclicky = -1;
        }
    }

    public boolean clickButton(int mousex, int mousey, int button) {
        if ((mousex -= this.parentscreen.guiLeft) >= this.relx && mousex < this.relx + this.cwidth && (mousey -= this.parentscreen.guiTop) >= this.rely && mousey <= this.rely + this.height) {
            int slot = this.getClickedSlot(mousey);
            if (slot >= this.getNumSlots()) {
                return false;
            }
            this.toggleSlotEnchantment(slot);
            return true;
        }
        return false;
    }

    private void toggleSlotEnchantment(int slot) {
        EnchantmentHash e = this.slotEnchantment.get(slot);
        if (e.state == 2) {
            NEICPH.sendModifyEnchantment(e.enchantment.effectId, 0, false);
            e.state = 0;
        } else {
            if (e.state == 1) {
                return;
            }
            NEICPH.sendModifyEnchantment(e.enchantment.effectId, this.level, true);
            e.state = 2;
        }
        this.updateEnchantmentOptions(GuiEnchantmentModifier.validateEnchantments());
    }

    public boolean addEnchantment(int e, int level) {
        if (e < Enchantment.enchantmentsList.length && Enchantment.enchantmentsList[e] != null) {
            ((Slot)this.inventorySlots.get(0)).getStack().addEnchantment(Enchantment.enchantmentsList[e], level);
            return true;
        }
        return false;
    }

    public void removeEnchantment(int e) {
        ItemStack stack = ((Slot)this.inventorySlots.get(0)).getStack();
        NBTTagList nbttaglist = stack.getEnchantmentTagList();
        if (nbttaglist != null) {
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                short ID = nbttaglist.getCompoundTagAt(i).getShort("id");
                if (ID != e) continue;
                nbttaglist.removeTag(i);
                if (nbttaglist.tagCount() == 0) {
                    stack.getTagCompound().removeTag("ench");
                }
                if (stack.getTagCompound().hasNoTags()) {
                    stack.setTagCompound(null);
                }
                return;
            }
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }

    public void onCraftMatrixChanged(IInventory iinventory) {
        if (this.parentscreen != null) {
            this.updateEnchantmentOptions(GuiEnchantmentModifier.validateEnchantments());
        }
    }

    public void updateEnchantmentOptions(boolean validate) {
        int numoptions = this.slotEnchantment.size();
        this.slotEnchantment.clear();
        ItemStack toolstack = this.getSlot(0).getStack();
        if (toolstack == null) {
            this.percentscrolled = 0.0f;
            return;
        }
        Item item = toolstack.getItem();
        int enchantablity = item.getItemEnchantability();
        if (enchantablity == 0 && validate) {
            this.percentscrolled = 0.0f;
            return;
        }
        for (Enchantment e : Enchantment.enchantmentsList) {
            if (e == null || e.type == null || !e.type.canEnchantItem(item) && validate) continue;
            int state = 0;
            int level = -1;
            if (NEIServerUtils.stackHasEnchantment(toolstack, e.effectId)) {
                state = 2;
                level = NEIServerUtils.getEnchantmentLevel(toolstack, e.effectId);
            } else if (NEIServerUtils.doesEnchantmentConflict(NEIServerUtils.getEnchantments(toolstack), e) && validate) {
                state = 1;
            }
            this.slotEnchantment.add(new EnchantmentHash(e, state, level));
        }
        if (numoptions != this.slotEnchantment.size()) {
            this.percentscrolled = 0.0f;
        }
    }

    public void drawSlots(GuiEnchantmentModifier gui) {
        for (int slot = 0; slot < 3; ++slot) {
            int shade;
            String text = "";
            int containerslot = slot + this.getScrolledSlots();
            if (containerslot + 1 > this.slotEnchantment.size()) {
                shade = 1;
            } else {
                EnchantmentHash e = this.slotEnchantment.get(containerslot);
                shade = e.state;
                text = e.enchantment.getTranslatedName(e.level == -1 ? this.level : e.level);
                if (gui.mc.fontRenderer.getStringWidth(text) > 95 && text.contains("Projectile")) {
                    text = text.replace("Projectile", "Proj");
                }
                if (gui.mc.fontRenderer.getStringWidth(text) > 95 && text.contains("Protection")) {
                    text = text.replace("Protection", "Protect");
                }
                if (gui.mc.fontRenderer.getStringWidth(text) > 95 && text.contains("Bane of")) {
                    text = text.replace("Bane of ", "");
                }
            }
            CCRenderState.changeTexture((String)"textures/gui/container/enchanting_table.png");
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hasScrollBar()) {
                gui.drawTexturedModalRect(this.relx, this.rely + slot * this.slotheight, 0, gui.ySize + this.slotheight * shade, this.cwidth - 30, this.slotheight);
                gui.drawTexturedModalRect(this.relx + this.cwidth - 30, this.rely + slot * this.slotheight, this.cwidth - 23, gui.ySize + this.slotheight * shade, 30, this.slotheight);
            } else {
                gui.drawTexturedModalRect(this.relx, this.rely + slot * this.slotheight, 0, gui.ySize + this.slotheight * shade, this.cwidth + 7, this.slotheight);
            }
            gui.getFontRenderer().drawString(text, this.relx + 4, this.rely + slot * this.slotheight + 5, this.textColourFromState(shade));
        }
    }

    private boolean hasScrollBar() {
        return this.getNumSlots() > 3;
    }

    public void drawScrollBar(GuiEnchantmentModifier gui) {
        if (!this.hasScrollBar()) {
            return;
        }
        int sbary = this.rely + (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.percentscrolled) + 0.5);
        int sbarx = this.relx + this.cwidth;
        Gui.drawRect((int)sbarx, (int)this.rely, (int)(sbarx + this.getScrollBarWidth()), (int)(this.rely + this.height), (int)-14671840);
        Gui.drawRect((int)sbarx, (int)sbary, (int)(sbarx + this.getScrollBarWidth()), (int)(sbary + this.getScrollBarHeight()), (int)-7631989);
        Gui.drawRect((int)sbarx, (int)sbary, (int)(sbarx + this.getScrollBarWidth() - 1), (int)(sbary + this.getScrollBarHeight() - 1), (int)-986896);
        Gui.drawRect((int)(sbarx + 1), (int)(sbary + 1), (int)(sbarx + this.getScrollBarWidth() - 1), (int)(sbary + this.getScrollBarHeight() - 1), (int)-11184811);
        Gui.drawRect((int)(sbarx + 1), (int)(sbary + 1), (int)(sbarx + this.getScrollBarWidth() - 2), (int)(sbary + this.getScrollBarHeight() - 2), (int)-3750202);
    }

    private int textColourFromState(int shade) {
        switch (shade) {
            case 0: {
                return 6839882;
            }
            case 1: {
                return 4226832;
            }
        }
        return 0xFFFF80;
    }

    public void onUpdate(int mousex, int mousey) {
        this.processScrollMouse(mousey);
    }

    public void processScrollMouse(int mousey) {
        mousey -= this.parentscreen.guiTop;
        if (this.scrollclicky >= 0) {
            int scrolldiff = mousey - this.scrollclicky;
            int barupallowed = (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.scrollpercent) + 0.5);
            int bardownallowed = this.height - this.getScrollBarHeight() - barupallowed;
            this.scrollmousey = -scrolldiff > barupallowed ? this.scrollclicky - barupallowed : (scrolldiff > bardownallowed ? this.scrollclicky + bardownallowed : mousey);
            this.calculatePercentScrolled();
        }
    }

    public static class EnchantmentHash {
        final Enchantment enchantment;
        int state;
        final int level;

        public EnchantmentHash(Enchantment e, int i, int l) {
            this.enchantment = e;
            this.state = i;
            this.level = l;
        }
    }
}

