/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.search;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.search.AbstractSearchExpressionVisitor;
import codechicken.nei.search.SearchExpressionErrorListener;
import codechicken.nei.search.SearchExpressionLexer;
import codechicken.nei.search.SearchExpressionParser;
import codechicken.nei.search.SearchExpressionParserBaseVisitor;
import codechicken.nei.shadow.org.antlr.v4.runtime.CharStreams;
import codechicken.nei.shadow.org.antlr.v4.runtime.CodePointCharStream;
import codechicken.nei.shadow.org.antlr.v4.runtime.CommonTokenStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumChatFormatting;

public class SearchExpressionUtils {
    private static final Map<Integer, EnumChatFormatting> HIGHLIGHT_MAP = new HashMap<Integer, EnumChatFormatting>();

    public static EnumChatFormatting getHighlight(Integer parserType) {
        return HIGHLIGHT_MAP.get(parserType);
    }

    public static <T> T visitSearchExpression(String text, AbstractSearchExpressionVisitor<T> visitor) {
        SearchExpressionParser parser = SearchExpressionUtils.createSearchExpressionParser(text, visitor.getSearchParser(), visitor);
        return visitor.visitRecipeSearchExpression(parser.recipeSearchExpression());
    }

    private static <T> SearchExpressionParser createSearchExpressionParser(String text, SearchTokenParser searchParser, SearchExpressionParserBaseVisitor<T> visitor) {
        boolean doLogExceptions = NEIClientConfig.getBooleanSetting("inventory.search.logSearchExceptions");
        CodePointCharStream inputStream = CharStreams.fromString(text);
        SearchExpressionErrorListener errorListener = new SearchExpressionErrorListener();
        SearchExpressionLexer lexer = new SearchExpressionLexer(inputStream, searchParser);
        lexer.removeErrorListeners();
        if (doLogExceptions) {
            lexer.addErrorListener(errorListener);
        }
        CommonTokenStream tokenStream = new CommonTokenStream(lexer);
        SearchExpressionParser parser = new SearchExpressionParser(tokenStream);
        parser.removeErrorListeners();
        if (doLogExceptions) {
            parser.addErrorListener(errorListener);
        }
        return parser;
    }

    static {
        for (HIGHLIGHTS elem : HIGHLIGHTS.values()) {
            for (int parserType : elem.parserTypes) {
                HIGHLIGHT_MAP.put(parserType, elem.f);
            }
        }
    }

    public static enum HIGHLIGHTS {
        RECIPE(EnumChatFormatting.GREEN, 4, 5, 6),
        OR(EnumChatFormatting.GRAY, 8),
        BRACKETS(EnumChatFormatting.GRAY, 9, 10),
        NEGATE(EnumChatFormatting.BLUE, 3),
        REGEX(EnumChatFormatting.AQUA, 1, 15),
        QUOTED(EnumChatFormatting.GOLD, 2, 17);

        public final EnumChatFormatting f;
        public final int[] parserTypes;

        private HIGHLIGHTS(EnumChatFormatting format, int ... parserTypes) {
            this.f = format;
            this.parserTypes = parserTypes;
        }

        public String toString() {
            return this.f.toString();
        }
    }
}

