/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe.chain;

import codechicken.nei.ItemStackAmount;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeChainMath {
    private static final ItemStack ROOT_ITEM = new ItemStack((Block)Blocks.fire);
    private static final Recipe.RecipeId ROOT_RECIPE_ID = Recipe.RecipeId.of(ROOT_ITEM, "recipe-autocrafting", Collections.emptyList());
    public final Map<Recipe.RecipeId, Long> outputRecipes = new HashMap<Recipe.RecipeId, Long>();
    public final List<BookmarkItem> initialItems = new ArrayList<BookmarkItem>();
    public final List<BookmarkItem> recipeIngredients = new ArrayList<BookmarkItem>();
    public final List<BookmarkItem> recipeResults = new ArrayList<BookmarkItem>();
    public final Map<BookmarkItem, BookmarkItem> preferredItems = new HashMap<BookmarkItem, BookmarkItem>();
    public final Map<BookmarkItem, Long> requiredAmount = new HashMap<BookmarkItem, Long>();
    public final List<ItemStack> containerItems = new ArrayList<ItemStack>();
    private final List<ItemStack> containerItemsBlacklist = new ArrayList<ItemStack>();

    /*
     * WARNING - void declaration
     */
    private RecipeChainMath(List<BookmarkItem> recipeItems, Set<Recipe.RecipeId> collapsedRecipes) {
        HashMap<Recipe.RecipeId, Integer> recipeState = new HashMap<Recipe.RecipeId, Integer>();
        HashMap<Recipe.RecipeId, Long> multipliers = new HashMap<Recipe.RecipeId, Long>();
        for (BookmarkItem bookmarkItem : recipeItems) {
            if (bookmarkItem.recipeId == null) continue;
            recipeState.put(bookmarkItem.recipeId, recipeState.getOrDefault(bookmarkItem.recipeId, 0) | (bookmarkItem.isIngredient ? 1 : 2));
        }
        for (BookmarkItem bookmarkItem : recipeItems) {
            if (recipeState.getOrDefault(bookmarkItem.recipeId, 0) != 3) {
                this.initialItems.add(bookmarkItem.copy());
                continue;
            }
            if (bookmarkItem.isIngredient) {
                this.recipeIngredients.add(bookmarkItem.copyWithAmount(0L));
                continue;
            }
            this.recipeResults.add(bookmarkItem.copyWithAmount(0L));
            multipliers.put(bookmarkItem.recipeId, Math.max(multipliers.getOrDefault(bookmarkItem.recipeId, 0L), bookmarkItem.getMultiplier()));
        }
        for (Map.Entry entry : multipliers.entrySet()) {
            if ((Long)entry.getValue() <= 1L && !collapsedRecipes.contains(entry.getKey())) continue;
            this.collectPreferredItems((Recipe.RecipeId)entry.getKey(), this.preferredItems, new HashSet<Recipe.RecipeId>());
            this.removeLoop((Recipe.RecipeId)entry.getKey(), this.preferredItems, new HashSet<Recipe.RecipeId>());
            this.outputRecipes.put((Recipe.RecipeId)entry.getKey(), (Long)entry.getValue());
        }
        while (true) {
            void var6_13;
            Map maxReference = Collections.emptyMap();
            Object var6_12 = null;
            long maxMultiplier = 0L;
            int maxDepth = 0;
            for (Map.Entry entry : multipliers.entrySet()) {
                Recipe.RecipeId recipeId = (Recipe.RecipeId)entry.getKey();
                if (this.outputRecipes.containsKey(recipeId) || !this.preferredItems.values().stream().noneMatch(resItem -> resItem.recipeId.equals(recipeId))) continue;
                HashMap<BookmarkItem, BookmarkItem> references = new HashMap<BookmarkItem, BookmarkItem>(this.preferredItems);
                this.collectPreferredItems(recipeId, references, new HashSet<Recipe.RecipeId>());
                this.removeLoop(recipeId, references, new HashSet<Recipe.RecipeId>());
                int depth = this.getMaxDepth(recipeId, references);
                if (maxDepth >= depth && (maxDepth != depth || (Long)entry.getValue() <= maxMultiplier)) continue;
                maxMultiplier = (Long)entry.getValue();
                maxReference = references;
                Recipe.RecipeId recipeId2 = recipeId;
                maxDepth = depth;
            }
            if (maxReference.isEmpty()) break;
            this.preferredItems.putAll(maxReference);
            this.outputRecipes.put((Recipe.RecipeId)var6_13, (Long)multipliers.get(var6_13));
        }
        for (Map.Entry entry : multipliers.entrySet()) {
            Recipe.RecipeId recipeId = (Recipe.RecipeId)entry.getKey();
            boolean isOutputRecipe = this.outputRecipes.containsKey(recipeId);
            boolean recipeInMiddle = this.preferredItems.values().stream().anyMatch(resItem -> resItem.recipeId.equals(recipeId));
            if (!isOutputRecipe && !recipeInMiddle) {
                this.outputRecipes.put(recipeId, (Long)entry.getValue());
                continue;
            }
            if (!isOutputRecipe || !recipeInMiddle) continue;
            this.outputRecipes.put(recipeId, Math.max(0L, (Long)entry.getValue() - 1L));
        }
    }

    private void collectPreferredItems(Recipe.RecipeId recipeId, Map<BookmarkItem, BookmarkItem> preferredItems, Set<Recipe.RecipeId> visited) {
        visited.add(recipeId);
        for (BookmarkItem ingrItem : this.recipeIngredients) {
            if (ingrItem.factor <= 0L || !recipeId.equals(ingrItem.recipeId) || preferredItems.containsKey(ingrItem)) continue;
            BookmarkItem activeItem = null;
            BookmarkItem prefItem = null;
            for (BookmarkItem item : this.recipeResults) {
                if (item.factor <= 0L || visited.contains(item.recipeId) || !item.containsItems(ingrItem)) continue;
                if ((activeItem == null || item.factor > activeItem.factor) && NEIClientUtils.areStacksSameTypeCraftingWithNBT(ingrItem.itemStack, item.itemStack)) {
                    activeItem = item;
                    continue;
                }
                if (prefItem != null && item.factor <= prefItem.factor) continue;
                prefItem = item;
            }
            if (activeItem != null) {
                prefItem = activeItem;
            }
            if (prefItem == null) continue;
            preferredItems.put(ingrItem, prefItem);
            this.collectPreferredItems(prefItem.recipeId, preferredItems, visited);
        }
        visited.remove(recipeId);
    }

    private int getMaxDepth(Recipe.RecipeId recipeId, Map<BookmarkItem, BookmarkItem> preferredItems) {
        int maxDepth = 0;
        for (BookmarkItem ingrItem : preferredItems.keySet()) {
            if (ingrItem.factor <= 0L || !recipeId.equals(ingrItem.recipeId)) continue;
            maxDepth = Math.max(maxDepth, this.getMaxDepth(preferredItems.get((Object)ingrItem).recipeId, preferredItems) + 1);
        }
        return maxDepth;
    }

    private void removeLoop(Recipe.RecipeId recipeId, Map<BookmarkItem, BookmarkItem> preferredItems, Set<Recipe.RecipeId> visited) {
        visited.add(recipeId);
        for (BookmarkItem ingrItem : this.recipeIngredients) {
            if (ingrItem.factor <= 0L || !recipeId.equals(ingrItem.recipeId) || !preferredItems.containsKey(ingrItem)) continue;
            BookmarkItem prefItem = preferredItems.get(ingrItem);
            if (visited.contains(prefItem.recipeId)) {
                preferredItems.remove(ingrItem);
                continue;
            }
            this.removeLoop(prefItem.recipeId, preferredItems, visited);
        }
        visited.remove(recipeId);
    }

    public Recipe.RecipeId createMasterRoot() {
        ArrayList<BookmarkItem> rootIngredients = new ArrayList<BookmarkItem>();
        for (BookmarkItem item2 : this.recipeResults) {
            if (!this.outputRecipes.containsKey(item2.recipeId) || ROOT_RECIPE_ID.equals(item2.recipeId)) continue;
            long amount = item2.factor * this.outputRecipes.get(item2.recipeId);
            rootIngredients.add(BookmarkItem.of(-1, item2.getItemStack(amount), item2.getStackSize(amount), ROOT_RECIPE_ID, true, BookmarkItem.generatePermutations(item2.itemStack, null)));
        }
        this.outputRecipes.clear();
        this.outputRecipes.put(ROOT_RECIPE_ID, 1L);
        this.recipeResults.removeIf(item -> ROOT_RECIPE_ID.equals(item.recipeId));
        this.recipeResults.add(BookmarkItem.of(-1, ROOT_ITEM, 1L, ROOT_RECIPE_ID, false));
        this.recipeIngredients.addAll(rootIngredients);
        return ROOT_RECIPE_ID;
    }

    public boolean hasMasterRoot() {
        return this.outputRecipes.containsKey(ROOT_RECIPE_ID);
    }

    public static RecipeChainMath of(List<BookmarkItem> chainItems, Set<Recipe.RecipeId> collapsedRecipes) {
        return new RecipeChainMath(chainItems, collapsedRecipes);
    }

    public static RecipeChainMath of(Recipe recipe, long multiplier) {
        ArrayList<BookmarkItem> chainItems = new ArrayList<BookmarkItem>();
        Recipe.RecipeId recipeId = recipe.getRecipeId();
        ItemStack result = recipe.getResult();
        chainItems.add(BookmarkItem.of(-1, result, StackInfo.getAmount(result), recipeId, false));
        for (Recipe.RecipeIngredient ingr : recipe.getIngredients()) {
            chainItems.add(BookmarkItem.of(-1, ingr.getItemStack(), ingr.getAmount(), recipeId, true, BookmarkItem.generatePermutations(ingr.getItemStack(), recipe)));
        }
        for (BookmarkItem item : chainItems) {
            item.amount *= multiplier;
        }
        return new RecipeChainMath(chainItems, Collections.emptySet());
    }

    public ItemStackAmount getMissedItems() {
        long amount;
        ItemStackAmount missedItems = new ItemStackAmount();
        for (BookmarkItem item : this.recipeResults) {
            amount = item.amount - this.requiredAmount.getOrDefault(item, 0L);
            if (amount <= 0L) continue;
            missedItems.add(item.getItemStack(amount));
        }
        for (BookmarkItem item : this.recipeIngredients) {
            amount = this.requiredAmount.containsKey(this.preferredItems.get(item)) ? 0L : this.requiredAmount.getOrDefault(item, item.amount);
            if (amount <= 0L) continue;
            missedItems.add(item.getItemStack(amount));
        }
        for (BookmarkItem item : this.initialItems) {
            if (this.requiredAmount.getOrDefault(item, -1L) != 0L) continue;
            missedItems.add(item.getItemStack());
        }
        return missedItems;
    }

    private void resetCalculation() {
        for (BookmarkItem item : this.recipeIngredients) {
            item.amount = 0L;
        }
        for (BookmarkItem item : this.recipeResults) {
            item.amount = 0L;
        }
        this.preferredItems.clear();
        this.requiredAmount.clear();
        this.containerItems.clear();
        this.containerItemsBlacklist.clear();
        for (Recipe.RecipeId recipeId : this.outputRecipes.keySet()) {
            this.collectPreferredItems(recipeId, this.preferredItems, new HashSet<Recipe.RecipeId>());
            this.removeLoop(recipeId, this.preferredItems, new HashSet<Recipe.RecipeId>());
        }
    }

    public RecipeChainMath refresh() {
        long prefAmount;
        boolean isPausedItemDamageSound = StackInfo.isPausedItemDamageSound();
        StackInfo.pauseItemDamageSound(true);
        this.resetCalculation();
        if (this.outputRecipes.containsKey(ROOT_RECIPE_ID)) {
            for (BookmarkItem ingrItem : this.recipeIngredients) {
                if (!ROOT_RECIPE_ID.equals(ingrItem.recipeId) || !ingrItem.itemStack.getItem().hasContainerItem(ingrItem.itemStack)) continue;
                this.containerItemsBlacklist.add(ingrItem.itemStack);
            }
        }
        for (BookmarkItem prefItem : this.recipeResults) {
            if (prefItem.factor <= 0L || !this.outputRecipes.containsKey(prefItem.recipeId)) continue;
            prefAmount = prefItem.factor * this.outputRecipes.get(prefItem.recipeId);
            if (prefItem.itemStack.getItem().hasContainerItem(prefItem.itemStack)) {
                this.containerItemsBlacklist.add(prefItem.itemStack);
            }
            this.preferredItems.put(prefItem, prefItem);
            this.calculateSuitableRecipe(prefItem, prefAmount, new ArrayList<Recipe.RecipeId>());
            this.preferredItems.remove(prefItem);
        }
        for (BookmarkItem prefItem : this.recipeResults) {
            if (prefItem.factor <= 0L || !this.outputRecipes.containsKey(prefItem.recipeId) || !this.requiredAmount.containsKey(prefItem)) continue;
            prefAmount = prefItem.factor * this.outputRecipes.get(prefItem.recipeId);
            this.requiredAmount.put(prefItem, this.requiredAmount.get(prefItem) - prefAmount);
        }
        StackInfo.pauseItemDamageSound(isPausedItemDamageSound);
        return this;
    }

    private void prepareIngredients(Recipe.RecipeId recipeId, long stepShift, List<Recipe.RecipeId> visited) {
        for (BookmarkItem item : this.recipeIngredients) {
            if (item.factor <= 0L || !recipeId.equals(item.recipeId)) continue;
            this.calculateSuitableRecipe(item, item.factor * stepShift, visited);
        }
    }

    private void calculateSuitableRecipe(BookmarkItem ingrItem, long ingrAmount, List<Recipe.RecipeId> visited) {
        Iterator<Object> iterator;
        BookmarkItem prefItem = this.preferredItems.get(ingrItem);
        if (ingrAmount > 0L) {
            long shiftSize;
            long stackSize;
            ItemStack stack;
            iterator = ingrItem.permutations.values().iterator();
            while (iterator.hasNext() && (!this.hasContainerItem(stack = (ItemStack)iterator.next()) || (stackSize = ingrItem.getStackSize(ingrAmount)) == (shiftSize = this.shiftContainerItems(stack, stackSize)) || (ingrAmount = shiftSize * (long)ingrItem.fluidCellAmount) != 0L)) {
            }
        }
        if (ingrAmount > 0L) {
            BookmarkItem item;
            iterator = this.initialItems.iterator();
            while (iterator.hasNext() && (!(item = (BookmarkItem)iterator.next()).containsItems(ingrItem) || (ingrAmount = this.addRequiredAmount(item, ingrAmount, item.amount)) != 0L)) {
            }
        }
        if (prefItem == null) {
            this.addRequiredAmount(ingrItem, ingrAmount, Long.MAX_VALUE);
        } else if (visited.contains(prefItem.recipeId)) {
            this.addRequiredAmount(prefItem, ingrAmount, Long.MAX_VALUE);
        } else {
            this.addRequiredAmount(prefItem, ingrAmount, Long.MAX_VALUE);
            long shift = (long)Math.ceil((double)(this.requiredAmount.get(prefItem) - prefItem.amount) / (double)prefItem.factor);
            if (shift > 0L) {
                this.addShift(prefItem.recipeId, shift);
                visited.add(prefItem.recipeId);
                this.prepareIngredients(prefItem.recipeId, shift, visited);
                visited.remove(prefItem.recipeId);
            }
        }
    }

    private long addRequiredAmount(BookmarkItem prefItem, long ingrAmount, long maxAmount) {
        long shiftAmount;
        if (this.hasContainerItem(prefItem.itemStack)) {
            ItemStack itemStack = prefItem.itemStack;
            for (shiftAmount = this.requiredAmount.getOrDefault(prefItem, 0L).longValue(); ingrAmount > 0L && shiftAmount < maxAmount; shiftAmount += (long)prefItem.fluidCellAmount) {
                itemStack = itemStack.copy();
                itemStack.stackSize = 1;
                this.containerItems.add(itemStack);
                ingrAmount = this.shiftContainerItems(itemStack, prefItem.getStackSize(ingrAmount)) * (long)prefItem.fluidCellAmount;
            }
        } else {
            long initAmount = Math.min(ingrAmount, maxAmount - shiftAmount);
            shiftAmount += initAmount;
            ingrAmount -= initAmount;
        }
        this.requiredAmount.put(prefItem, shiftAmount);
        return ingrAmount;
    }

    private long shiftContainerItems(ItemStack aStack, long steps) {
        for (int i = 0; i < this.containerItems.size() && steps > 0L; ++i) {
            ItemStack bStack = this.containerItems.get(i);
            if (bStack == null || !NEIClientUtils.areStacksSameTypeCraftingWithNBT(aStack, bStack)) continue;
            ContainerItemResult result = this.getToolsContainerItems(bStack, steps);
            bStack = result.stack;
            steps = result.leftSteps;
            if (result.containerItem != null) {
                this.containerItems.add(result.containerItem);
            }
            this.containerItems.set(i, bStack);
        }
        this.containerItems.removeIf(stack -> stack == null);
        return steps;
    }

    private ContainerItemResult getToolsContainerItems(ItemStack aStack, long steps) {
        int damagePerContainerCraft;
        NBTTagCompound tagCompound = aStack.getTagCompound();
        if (tagCompound != null && tagCompound.hasKey("GT.ToolStats") && (damagePerContainerCraft = this.getGTToolDamagePerContainerCraft(aStack)) > 0) {
            NBTTagCompound toolStats = tagCompound.getCompoundTag("GT.ToolStats");
            long maxDamage = toolStats.getLong("MaxDamage");
            long damage = toolStats.getLong("Damage");
            long leftSteps = (maxDamage - damage) / (long)damagePerContainerCraft;
            long availableSteps = Math.min(steps, Math.max(1L, leftSteps));
            steps -= availableSteps;
            if (damage + availableSteps * (long)damagePerContainerCraft == maxDamage || leftSteps <= 0L) {
                aStack = null;
            } else {
                toolStats.setLong("Damage", damage + availableSteps * (long)damagePerContainerCraft);
            }
            return new ContainerItemResult(aStack, steps, null);
        }
        Item item = aStack.getItem();
        while (aStack != null && steps > 0L) {
            aStack = item.getContainerItem(aStack);
            --steps;
            if (aStack == null || item == aStack.getItem()) continue;
            return new ContainerItemResult(null, steps, aStack);
        }
        return new ContainerItemResult(aStack, steps, null);
    }

    private int getGTToolDamagePerContainerCraft(ItemStack aStack) {
        try {
            Object toolStats = aStack.getItem().getClass().getMethod("getToolStats", ItemStack.class).invoke((Object)aStack.getItem(), aStack);
            return (Integer)toolStats.getClass().getMethod("getToolDamagePerContainerCraft", new Class[0]).invoke(toolStats, new Object[0]);
        }
        catch (Throwable th) {
            th.printStackTrace();
            return 0;
        }
    }

    private boolean hasContainerItem(ItemStack aStack) {
        if (aStack.getItem().hasContainerItem(aStack)) {
            for (ItemStack bStack : this.containerItemsBlacklist) {
                if (!NEIClientUtils.areStacksSameTypeCraftingWithNBT(aStack, bStack)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void addShift(Recipe.RecipeId recipeId, long shift) {
        for (BookmarkItem item : this.recipeIngredients) {
            if (!recipeId.equals(item.recipeId)) continue;
            item.amount += item.factor * shift;
        }
        for (BookmarkItem item : this.recipeResults) {
            if (!recipeId.equals(item.recipeId)) continue;
            item.amount += item.factor * shift;
        }
    }

    private static class ContainerItemResult {
        public ItemStack stack;
        public ItemStack containerItem;
        public long leftSteps;

        public ContainerItemResult(ItemStack stack, long leftSteps, ItemStack containerItem) {
            this.stack = stack;
            this.leftSteps = leftSteps;
            this.containerItem = containerItem;
        }
    }
}

