/*
 * Decompiled with CFR 0.152.
 */
package com.crawkatt.meicamod.entity.custom;

import com.crawkatt.meicamod.effect.ModEffects;
import com.crawkatt.meicamod.entity.ModEntities;
import com.crawkatt.meicamod.entity.custom.BrotecitoEntity;
import com.crawkatt.meicamod.entity.goal.AvoidPlayerWhileCamouflagedGoal;
import com.crawkatt.meicamod.entity.goal.MeicaBowAttackGoal;
import com.crawkatt.meicamod.entity.projectile.IceArrow;
import com.crawkatt.meicamod.entity.projectile.PoisonArrow;
import com.crawkatt.meicamod.item.ModItems;
import com.crawkatt.meicamod.sound.ModSounds;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5534;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;

public class MeicaEntity
extends class_1588
implements class_1603 {
    private final class_3213 bossEvent = new class_3213((class_2561)class_2561.method_43470((String)"Meica"), class_1259.class_1260.field_5785, class_1259.class_1261.field_5793);

    public MeicaEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5946(class_1304.field_6173, 1.0f);
    }

    protected void method_5964(@NotNull class_5819 src, @NotNull class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)ModItems.MEICA_BOW));
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_6059(class_1294.field_5905) && this.method_6032() < this.method_6063()) {
            this.method_6025(0.3f);
        }
        if (this.method_23318() < 20.0) {
            this.escapeVoid();
        }
        if (!this.method_5805()) {
            return;
        }
        this.method_5964(this.field_5974, this.method_37908().method_8404(this.method_24515()));
    }

    private void escapeVoid() {
        class_1937 world = this.method_37908();
        class_1657 nearestPlayer = world.method_18460((class_1297)this, 100.0);
        if (nearestPlayer != null) {
            class_243 playerPos = nearestPlayer.method_19538();
            class_243 meicaPos = this.method_19538();
            if (!nearestPlayer.method_31549().field_7479 || !nearestPlayer.method_31549().field_7477) {
                this.method_20620(playerPos.field_1352, playerPos.field_1351, playerPos.field_1350);
                nearestPlayer.method_20620(meicaPos.field_1352, meicaPos.field_1351, meicaPos.field_1350);
                nearestPlayer.method_17356(ModSounds.MEICA_KILL_ENTITY_LAUGHT, this.method_5634(), 1.0f, 1.0f);
            }
        } else {
            this.teleportToSafeLocation();
        }
    }

    private void teleportToSafeLocation() {
        for (int i = 0; i < 10; ++i) {
            class_243 startPos = this.method_19538();
            class_243 safePos = class_5534.method_31534((class_1314)this, (int)16, (int)7, (class_243)startPos);
            if (safePos == null || !this.isSafeTeleportPosition(safePos)) continue;
            this.method_20620(safePos.field_1352, safePos.field_1351, safePos.field_1350);
            this.spawnParticles();
            break;
        }
    }

    public boolean isCamouflaged() {
        return this.method_6059(ModEffects.CAMOUFLAGE_COOLDOWN);
    }

    public void activateCamouflage() {
        this.method_6092(new class_1293(class_1294.field_5905, 200, 0, false, false));
        this.spawnParticles();
        for (int i = 0; i < 10; ++i) {
            class_243 pos = class_5534.method_31534((class_1314)this, (int)16, (int)7, (class_243)class_243.method_24955((class_2382)this.method_24515()));
            if (pos == null || !this.isSafeTeleportPosition(pos) || this.method_5968() == null) continue;
            this.spawnBrotecitosAround(this.method_5968());
            this.method_20620(pos.field_1352, pos.field_1351, pos.field_1350);
            this.method_6092(new class_1293(ModEffects.CAMOUFLAGE_COOLDOWN, 400, 1, false, false));
            break;
        }
    }

    private void spawnParticles() {
        class_2400 particle = class_2398.field_28803;
        for (int i = 0; i < 100; ++i) {
            double offsetX = (this.field_5974.method_43058() - 0.5) * 2.0;
            double offsetY = this.field_5974.method_43058() * 2.0;
            double offsetZ = (this.field_5974.method_43058() - 0.5) * 2.0;
            double speedX = (this.field_5974.method_43058() - 0.5) * 5.0;
            double speedY = this.field_5974.method_43058() * 5.0;
            double speedZ = (this.field_5974.method_43058() - 0.5) * 5.0;
            this.method_37908().method_8406((class_2394)particle, this.method_23317() + offsetX, this.method_23318() + offsetY, this.method_23321() + offsetZ, speedX, speedY, speedZ);
        }
    }

    private void spawnBrotecitosAround(class_1309 targetPlayer) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 playerPos = targetPlayer.method_24515();
            for (int i = 0; i < 3; ++i) {
                double offsetX = serverLevel.field_9229.method_43048(10) - 5;
                double offsetZ = serverLevel.field_9229.method_43048(10) - 5;
                class_2338 spawnPos = new class_2338((int)((double)playerPos.method_10263() + offsetX), playerPos.method_10264(), (int)((double)playerPos.method_10260() + offsetZ));
                if (!this.isSafeSpawnPosition(spawnPos)) continue;
                BrotecitoEntity brotecito = new BrotecitoEntity(ModEntities.BROTECITO, this.method_37908());
                brotecito.method_30634(spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260());
                brotecito.setAggressiveMode(true);
                brotecito.method_5980(targetPlayer);
                this.method_37908().method_8649((class_1297)brotecito);
            }
        }
    }

    private boolean isSafeSpawnPosition(class_2338 pos) {
        return this.method_37908().method_8320(pos).method_26215() && this.method_37908().method_8320(pos.method_10084()).method_26215() && this.method_37908().method_18026(new class_238(pos));
    }

    private boolean isSafeTeleportPosition(class_243 pos) {
        class_2338 blockPos = new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350);
        return this.method_37908().method_8320(blockPos).method_26215() && this.method_37908().method_8320(blockPos.method_10084()).method_26215() && this.method_37908().method_8587((class_1297)this, this.method_5829().method_997(pos));
    }

    public void method_7105(class_1309 target, float distanceFactor) {
        class_1667 arrow = this.getRandomArrowType(this.method_37908(), (class_1309)this);
        double d0 = target.method_23317() - this.method_23317();
        double d1 = target.method_5829().field_1322 + (double)(target.method_17682() / 3.0f) - arrow.method_23318();
        double d2 = target.method_23321() - this.method_23321();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.method_7485(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.method_37908().method_8407().method_5461() * 4));
        this.method_5783(class_3417.field_14600, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)arrow);
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)ModItems.MEICA_BOW));
    }

    private class_1667 getRandomArrowType(class_1937 level, class_1309 shooter) {
        class_5819 random = shooter.method_6051();
        int arrowType = random.method_43048(2);
        return switch (arrowType) {
            case 0 -> new PoisonArrow(level, shooter);
            case 1 -> new IceArrow(level, shooter);
            default -> new class_1667(level, shooter);
        };
    }

    public static class_5132 createMeicaAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23723, 2.0).method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23717, 50.0).method_26866();
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, new MeicaBowAttackGoal<MeicaEntity>(this, 1.0, 20, 30.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6201.method_6277(3, (class_1352)new AvoidPlayerWhileCamouflagedGoal(this, 1, 1.5, 10.0));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        if (!this.method_37908().field_9236) {
            class_1799 meicaBow = this.method_6118(class_1304.field_6173);
            meicaBow.method_7974(0);
            this.method_5775(meicaBow);
        }
    }

    public void method_5837(@NotNull class_3222 pServerPlayer) {
        super.method_5837(pServerPlayer);
        this.bossEvent.method_14088(pServerPlayer);
    }

    public void method_5742(@NotNull class_3222 pServerPlayer) {
        super.method_5742(pServerPlayer);
        this.bossEvent.method_14089(pServerPlayer);
    }

    public boolean method_5643(@NotNull class_1282 pSource, float pAmount) {
        if (pSource.method_48789(class_8103.field_42249) || pSource.method_48789(class_8103.field_42250) || this.method_6059(class_1294.field_5899)) {
            return false;
        }
        if ((double)this.method_6032() < (double)this.method_6063() * 0.5 && !this.isCamouflaged()) {
            if (this.method_5968() != null) {
                this.method_5968().method_6092(new class_1293(class_1294.field_5919, 200, 1, false, false));
            }
            this.activateCamouflage();
        }
        return super.method_5643(pSource, pAmount);
    }

    public boolean method_5722(class_1297 pTeam) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_238 brotecitosAround = this.method_5829().method_1014(10.0);
            return serverWorld.method_8390(BrotecitoEntity.class, brotecitosAround, class_1301.field_6155).stream().anyMatch(brotecito -> !brotecito.isEntityTamed());
        }
        return super.method_5722(pTeam);
    }

    public void method_6007() {
        super.method_6007();
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
    }

    public float method_6017() {
        return 1.0f;
    }

    protected class_3414 method_6002() {
        return this.selectRandomDeathSound();
    }

    private class_3414 selectRandomDeathSound() {
        return switch (this.field_5974.method_43048(3)) {
            case 0 -> ModSounds.MEICA_DEATH;
            case 1 -> ModSounds.MEICA_DEATH_2;
            default -> ModSounds.MEICA_DEATH_3;
        };
    }

    private class_3414 selectRandomKillSound() {
        return switch (this.field_5974.method_43048(3)) {
            case 0 -> ModSounds.MEICA_KILL_ENTITY;
            case 1 -> ModSounds.MEICA_KILL_ENTITY_LAUGHT;
            default -> ModSounds.MEICA_LAUGHT;
        };
    }

    public void playKillSound() {
        this.method_37908().method_47967(null, this.method_23317(), this.method_23318(), this.method_23321(), this.selectRandomKillSound(), this.method_5634(), 1.0f, 1.0f, this.field_5974.method_43055());
    }
}

