/*
 * Decompiled with CFR 0.152.
 */
package com.crawkatt.meicamod.entity.goal;

import com.crawkatt.meicamod.entity.custom.MeicaEntity;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1380;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5534;

public class AvoidPlayerWhileCamouflagedGoal
extends class_1352 {
    private final class_1588 entity;
    private final int farSpeed;
    private final double nearSpeed;
    private final double avoidDistance;
    private final class_1937 world;
    private class_1657 closestPlayer;
    private int ticksSinceLastSeen;
    private State currentState = State.IDLE;

    public AvoidPlayerWhileCamouflagedGoal(class_1588 entity, int farSpeed, double nearSpeed, double avoidDistance) {
        this.entity = entity;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.avoidDistance = avoidDistance;
        this.world = entity.method_37908();
        this.ticksSinceLastSeen = 0;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!((MeicaEntity)this.entity).isCamouflaged()) {
            return false;
        }
        this.closestPlayer = this.world.method_18460((class_1297)this.entity, this.avoidDistance);
        if (this.closestPlayer != null && this.entity.method_5858((class_1297)this.closestPlayer) < this.avoidDistance * this.avoidDistance) {
            this.currentState = State.AVOIDING;
            return true;
        }
        return false;
    }

    public void method_6269() {
        this.ticksSinceLastSeen = 0;
    }

    public void method_6268() {
        if (this.closestPlayer == null || !this.closestPlayer.method_5805()) {
            this.currentState = State.IDLE;
            return;
        }
        double distanceSquared = this.entity.method_5858((class_1297)this.closestPlayer);
        switch (this.currentState.ordinal()) {
            case 1: {
                this.handleAvoiding(distanceSquared);
                break;
            }
            case 2: {
                this.handleAttacking(distanceSquared);
                break;
            }
        }
        ++this.ticksSinceLastSeen;
    }

    public boolean method_6266() {
        return ((MeicaEntity)this.entity).isCamouflaged() && this.closestPlayer != null && this.entity.method_5858((class_1297)this.closestPlayer) < this.avoidDistance * this.avoidDistance;
    }

    private void handleAvoiding(double distanceSquared) {
        if (distanceSquared < 16.0) {
            this.currentState = State.ATTACKING;
            return;
        }
        class_243 escapePos = this.getEscapePos();
        if (escapePos != null) {
            this.entity.method_5942().method_6337(escapePos.field_1352, escapePos.field_1351, escapePos.field_1350, (double)this.farSpeed);
        }
    }

    private void handleAttacking(double distanceSquared) {
        class_1380 attackGoal = new class_1380((class_1588)((MeicaEntity)this.entity), this.nearSpeed, 20, 15.0f);
        attackGoal.method_6268();
        if (distanceSquared >= 16.0) {
            this.currentState = State.AVOIDING;
        }
    }

    private class_243 getEscapePos() {
        return class_5534.method_31534((class_1314)this.entity, (int)16, (int)7, (class_243)this.closestPlayer.method_19538());
    }

    private static enum State {
        IDLE,
        AVOIDING,
        ATTACKING;

    }
}

