/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.api;

import cn.handyplus.currency.constants.CurrencyConstants;
import cn.handyplus.currency.constants.CurrencyType;
import cn.handyplus.currency.enter.PlayerCurrencyEnter;
import cn.handyplus.currency.event.PlayerCurrencyChangeSuccessEvent;
import cn.handyplus.currency.lib.core.MapUtil;
import cn.handyplus.currency.service.PlayerCurrencyService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlayerCurrencyApi {
    public static boolean give(@NotNull UUID playerUuid, @NotNull String type, @NotNull Long amount, String operatorName, String operatorReason) {
        return PlayerCurrencyApi.give(Collections.singletonList(playerUuid), MapUtil.of(type, amount), operatorName, operatorReason);
    }

    public static boolean set(@NotNull UUID playerUuid, @NotNull String type, @NotNull Long amount, String operatorName, String operatorReason) {
        return PlayerCurrencyApi.set(Collections.singletonList(playerUuid), MapUtil.of(type, amount), operatorName, operatorReason);
    }

    public static boolean take(@NotNull UUID playerUuid, @NotNull String type, @NotNull Long amount, String operatorName, String operatorReason) {
        return PlayerCurrencyApi.take(Collections.singletonList(playerUuid), MapUtil.of(type, amount), operatorName, operatorReason);
    }

    public static boolean give(@NotNull UUID playerUuid, @NotNull Map<String, Long> currencyChangeMap, String operatorName, String operatorReason) {
        return PlayerCurrencyApi.give(Collections.singletonList(playerUuid), currencyChangeMap, operatorName, operatorReason);
    }

    public static boolean set(@NotNull UUID playerUuid, @NotNull Map<String, Long> currencyChangeMap, String operatorName, String operatorReason) {
        return PlayerCurrencyApi.set(Collections.singletonList(playerUuid), currencyChangeMap, operatorName, operatorReason);
    }

    public static boolean take(@NotNull UUID playerUuid, @NotNull Map<String, Long> currencyChangeMap, String operatorName, String operatorReason) {
        return PlayerCurrencyApi.take(Collections.singletonList(playerUuid), currencyChangeMap, operatorName, operatorReason);
    }

    public static synchronized boolean give(@NotNull List<UUID> playerUuidList, @NotNull Map<String, Long> currencyChangeMap, String operatorName, String operatorReason) {
        Objects.requireNonNull(playerUuidList);
        Objects.requireNonNull(currencyChangeMap);
        Map<String, Map<UUID, Long>> balanceMap = PlayerCurrencyApi.getBalanceMap(playerUuidList, currencyChangeMap);
        boolean rst = PlayerCurrencyService.getInstance().give(playerUuidList, currencyChangeMap);
        if (rst) {
            PlayerCurrencyApi.sendLogEvent(currencyChangeMap, operatorName, operatorReason, playerUuidList, balanceMap);
        }
        return rst;
    }

    public static synchronized boolean set(@NotNull List<UUID> playerUuidList, @NotNull Map<String, Long> currencyChangeMap, String operatorName, String operatorReason) {
        Objects.requireNonNull(playerUuidList);
        Objects.requireNonNull(currencyChangeMap);
        Map<String, Map<UUID, Long>> balanceMap = PlayerCurrencyApi.getBalanceMap(playerUuidList, currencyChangeMap);
        boolean rst = PlayerCurrencyService.getInstance().set(playerUuidList, currencyChangeMap);
        if (rst) {
            PlayerCurrencyApi.sendLogEvent(currencyChangeMap, operatorName, operatorReason, playerUuidList, balanceMap);
        }
        return rst;
    }

    public static synchronized boolean take(@NotNull List<UUID> playerUuidList, @NotNull Map<String, Long> currencyChangeMap, String operatorName, String operatorReason) {
        Objects.requireNonNull(playerUuidList);
        Objects.requireNonNull(currencyChangeMap);
        Map<String, Map<UUID, Long>> balanceMap = PlayerCurrencyApi.getBalanceMap(playerUuidList, currencyChangeMap);
        boolean rst = PlayerCurrencyService.getInstance().take(playerUuidList, currencyChangeMap);
        if (rst) {
            PlayerCurrencyApi.sendLogEvent(currencyChangeMap, operatorName, operatorReason, playerUuidList, balanceMap);
        }
        return rst;
    }

    public static Long look(@NotNull UUID playerUuid, @NotNull String type) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(playerUuid);
        Optional<PlayerCurrencyEnter> economyOptional = PlayerCurrencyService.getInstance().findByPlayerUuid(playerUuid, type);
        return economyOptional.map(PlayerCurrencyEnter::getBalance).orElse(0L);
    }

    public static Map<UUID, Long> look(@NotNull List<UUID> playerUuidList, @NotNull String type) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(playerUuidList);
        List<PlayerCurrencyEnter> playerCurrencyEnterList = PlayerCurrencyService.getInstance().findByPlayerUuidListAndType(playerUuidList, type);
        return playerCurrencyEnterList.stream().collect(Collectors.toMap(PlayerCurrencyEnter::getPlayerUuid, PlayerCurrencyEnter::getBalance));
    }

    public static Map<String, Long> look(@NotNull UUID playerUuid, @NotNull List<String> typeList) {
        Objects.requireNonNull(playerUuid);
        Objects.requireNonNull(typeList);
        List<PlayerCurrencyEnter> playerCurrencyEnterList = PlayerCurrencyService.getInstance().findByPlayerUuidAndTypeList(playerUuid, typeList);
        return playerCurrencyEnterList.stream().collect(Collectors.toMap(PlayerCurrencyEnter::getType, PlayerCurrencyEnter::getBalance));
    }

    public static Long lookTotal(@NotNull UUID playerUuid, @NotNull String type) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(playerUuid);
        Optional<PlayerCurrencyEnter> economyOptional = PlayerCurrencyService.getInstance().findByPlayerUuid(playerUuid, type);
        return economyOptional.map(PlayerCurrencyEnter::getTotal).orElse(0L);
    }

    public static List<String> findAllType() {
        return CurrencyType.getAll();
    }

    public static boolean register(Plugin plugin, String desc) {
        return PlayerCurrencyApi.register(plugin.getName(), desc);
    }

    public static void unregister(Plugin plugin) {
        PlayerCurrencyApi.unregister(plugin.getName());
    }

    public static boolean register(String type, String desc) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(desc);
        if (CurrencyConstants.API_REGISTER_CURRENCY_MAP.containsKey(type)) {
            return false;
        }
        CurrencyConstants.API_REGISTER_CURRENCY_MAP.put(type, desc);
        return true;
    }

    public static void unregister(String type) {
        Objects.requireNonNull(type);
        CurrencyConstants.API_REGISTER_CURRENCY_MAP.remove(type);
    }

    public static String getDesc(String type) {
        Objects.requireNonNull(type);
        return CurrencyType.getDesc(type);
    }

    private static void sendLogEvent(Map<String, Long> currencyChangeMap, String operatorName, String operatorReason, List<UUID> newPlayerUuidList, Map<String, Map<UUID, Long>> balanceMap) {
        for (String type : currencyChangeMap.keySet()) {
            for (UUID playerUuid : newPlayerUuidList) {
                PlayerCurrencyChangeSuccessEvent.callEvent(playerUuid, type, currencyChangeMap.get(type), balanceMap.get(type).getOrDefault(playerUuid, 0L), operatorName, operatorReason);
            }
        }
    }

    private static Map<String, Map<UUID, Long>> getBalanceMap(List<UUID> playerUuidList, Map<String, Long> currencyChangeMap) {
        HashMap<String, Map<UUID, Long>> balanceMap = MapUtil.newHashMapWithExpectedSize(currencyChangeMap.size());
        for (String type : currencyChangeMap.keySet()) {
            List<PlayerCurrencyEnter> playerCurrencyEnterList = PlayerCurrencyService.getInstance().getOrInit(playerUuidList, type);
            Map<UUID, Long> playerBalanceMap = playerCurrencyEnterList.stream().collect(Collectors.toMap(PlayerCurrencyEnter::getPlayerUuid, PlayerCurrencyEnter::getBalance));
            balanceMap.put(type, playerBalanceMap);
        }
        return balanceMap;
    }
}

