/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.command.admin;

import cn.handyplus.currency.constants.CurrencyType;
import cn.handyplus.currency.enter.PlayerCurrencyEnter;
import cn.handyplus.currency.lib.command.IHandyCommandEvent;
import cn.handyplus.currency.lib.constants.BaseConstants;
import cn.handyplus.currency.lib.db.Page;
import cn.handyplus.currency.lib.util.AssertUtil;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.lib.util.RgbTextUtil;
import cn.handyplus.currency.service.PlayerCurrencyService;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class BalTopCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "balTop";
    }

    @Override
    public String permission() {
        return "playerCurrency.balTop";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String type = args[1];
        AssertUtil.isTrue(CurrencyType.exist(type), BaseUtil.getMsgNotColor("typeFailureMsg"));
        String pageNumStr = this.getArg(args, 2).orElse("1");
        String pageSizeStr = this.getArg(args, 3).orElse("10");
        Integer pageNum = AssertUtil.isNumericToInt(pageNumStr, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Integer pageSize = AssertUtil.isNumericToInt(pageSizeStr, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Page<PlayerCurrencyEnter> page = PlayerCurrencyService.getInstance().page(type, pageNum, pageSize);
        String titleFormat = BaseConstants.LANG_CONFIG.getString("balanceTop.titleFormat", "&f----- &a\u6392\u884c\u699c ${type}&7(&f${page})&f-----");
        String noDataMsg = BaseConstants.LANG_CONFIG.getString("balanceTop.noDataMsg", "&7\u6ca1\u6709\u53ef\u6392\u884c\u7684\u6570\u636e");
        String itemFormat = BaseConstants.LANG_CONFIG.getString("balanceTop.itemFormat", "&6${rank}. &f${playerName} &7- &a${balance}");
        String nextPageText = BaseConstants.LANG_CONFIG.getString("balanceTop.nextPageText", "&8[&a\u70b9\u51fb\u67e5\u8be2&8]&7\u66f4\u591a\u4fe1\u606f");
        String title = titleFormat.replace("${type}", CurrencyType.getDesc(type)).replace("${page}", String.valueOf(pageNum));
        RgbTextUtil text = RgbTextUtil.getInstance().init(title + "\n");
        if (page.getTotal() < 1) {
            text.addExtra(noDataMsg);
            return;
        }
        for (int i = 0; i < page.getRecords().size(); ++i) {
            PlayerCurrencyEnter enter = page.getRecords().get(i);
            int rank = (pageNum - 1) * pageSize + i + 1;
            String rankFormat = BaseConstants.LANG_CONFIG.getString("balanceTop.rankFormat." + rank, itemFormat);
            String itemText = rankFormat.replace("${rank}", String.valueOf(rank)).replace("${playerName}", enter.getPlayerName()).replace("${balance}", String.valueOf(enter.getBalance()));
            text.addExtra(itemText + "\n");
        }
        if (pageNum < page.getTotalPages(pageSize)) {
            text.addExtra(RgbTextUtil.getInstance().init(nextPageText).addClickCommand("/ply balTop " + type + " " + (pageNum + 1)).build());
        }
        text.send(sender);
    }
}

