/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.currency.command.admin;

import cn.handyplus.currency.constants.CurrencyType;
import cn.handyplus.currency.lib.command.IHandyCommandEvent;
import cn.handyplus.currency.lib.util.AssertUtil;
import cn.handyplus.currency.lib.util.BaseUtil;
import cn.handyplus.currency.lib.util.MessageUtil;
import cn.handyplus.currency.service.PlayerCurrencyLogService;
import cn.handyplus.currency.service.PlayerCurrencyService;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ClearCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "clear";
    }

    @Override
    public String permission() {
        return "playerCurrency.clear";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String type = args[1];
        AssertUtil.isTrue(CurrencyType.exist(type), BaseUtil.getMsgNotColor("typeFailureMsg"));
        PlayerCurrencyService.getInstance().deleteByType(type);
        PlayerCurrencyLogService.getInstance().deleteByType(type);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("succeedMsg"));
    }
}

